/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.bankedexperience.data.modifiers;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import net.runelite.api.ItemComposition;
import net.runelite.api.Skill;
import net.runelite.client.game.ItemManager;
import thestonedturtle.bankedexperience.data.Activity;
import thestonedturtle.bankedexperience.data.modifiers.CarpentersOutfit;
import thestonedturtle.bankedexperience.data.modifiers.ConsumptionModifier;
import thestonedturtle.bankedexperience.data.modifiers.Modifier;
import thestonedturtle.bankedexperience.data.modifiers.SkillingOutfit;
import thestonedturtle.bankedexperience.data.modifiers.StaticModifier;
import thestonedturtle.bankedexperience.data.modifiers.ZealotsRobes;

public final class Modifiers {
    private static final Multimap<Skill, Modifier> modifiers = ArrayListMultimap.create();
    static final Set<Activity> BONES = ImmutableSet.of((Object)((Object)Activity.BONES), (Object)((Object)Activity.WOLF_BONES), (Object)((Object)Activity.BURNT_BONES), (Object)((Object)Activity.MONKEY_BONES), (Object)((Object)Activity.BAT_BONES), (Object)((Object)Activity.JOGRE_BONES), (Object[])new Activity[]{Activity.BIG_BONES, Activity.ZOGRE_BONES, Activity.SHAIKAHAN_BONES, Activity.BABYDRAGON_BONES, Activity.WYVERN_BONES, Activity.DRAGON_BONES, Activity.FAYRG_BONES, Activity.LAVA_DRAGON_BONES, Activity.RAURG_BONES, Activity.DAGANNOTH_BONES, Activity.OURG_BONES, Activity.SUPERIOR_DRAGON_BONES, Activity.WYRM_BONES, Activity.DRAKE_BONES, Activity.HYDRA_BONES});
    static final Set<Activity> ASHES = ImmutableSet.of((Object)((Object)Activity.FIENDISH_ASHES), (Object)((Object)Activity.VILE_ASHES), (Object)((Object)Activity.MALICIOUS_ASHES), (Object)((Object)Activity.ABYSSAL_ASHES), (Object)((Object)Activity.INFERNAL_ASHES));

    public static void prepare(ItemManager manager) {
        assert (modifiers.size() == 0);
        HashMap<Integer, ItemComposition[]> compositions = new HashMap<Integer, ItemComposition[]>();
        ItemComposition[] zealots = Modifiers.asCompositions(manager, 25438, 25434, 25436, 25440);
        compositions.put(zealots[0].getId(), zealots);
        ItemComposition[] farmers = Modifiers.asCompositions(manager, 13646, 13642, 13640, 13644);
        compositions.put(farmers[0].getId(), farmers);
        ItemComposition[] carpenters = Modifiers.asCompositions(manager, 24872, 24874, 24876, 24878);
        compositions.put(carpenters[0].getId(), carpenters);
        ItemComposition[] pyromancer = Modifiers.asCompositions(manager, 20708, 20704, 20706, 20710);
        compositions.put(pyromancer[0].getId(), pyromancer);
        SwingUtilities.invokeLater(() -> Modifiers.createModifiers(manager, compositions));
    }

    private static ItemComposition[] asCompositions(ItemManager manager, int ... itemIds) {
        ItemComposition[] results = new ItemComposition[itemIds.length];
        for (int i = 0; i < itemIds.length; ++i) {
            results[i] = manager.getItemComposition(itemIds[i]);
        }
        return results;
    }

    private static void createModifiers(ItemManager manager, Map<Integer, ItemComposition[]> compositions) {
        Modifiers.addModifier(new ZealotsRobes(manager, compositions.get(25438)));
        Modifiers.addModifier(new StaticModifier(Skill.PRAYER, "Demonic Offering (300% xp)", 3.0f, ASHES, null));
        Modifiers.addModifier(new StaticModifier(Skill.PRAYER, "Lit Gilded Altar (350% xp)", 3.5f, BONES, null));
        Modifiers.addModifier(new StaticModifier(Skill.PRAYER, "Ectofuntus (400% xp)", 4.0f, BONES, null));
        Modifiers.addModifier(new ConsumptionModifier(Skill.PRAYER, "Wildy Altar (350% xp & 50% Save)", 0.5f, BONES, null){

            @Override
            public double appliedXpRate(Activity activity) {
                return activity.getXp() * 3.5;
            }

            @Override
            public boolean compatibleWith(Modifier modifier) {
                if (modifier instanceof StaticModifier) {
                    return !this.touchesSameActivity(modifier);
                }
                return super.compatibleWith(modifier);
            }
        });
        Modifiers.addModifier(new SkillingOutfit(Skill.FARMING, "Farmer's Outfit", null, null, manager, compositions.get(13646)));
        Modifiers.addModifier(new CarpentersOutfit(manager, compositions.get(24872)));
        Modifiers.addModifier(new SkillingOutfit(Skill.FIREMAKING, "Pyromancer Outfit", null, null, manager, compositions.get(20708)));
    }

    private static void addModifier(Modifier modifier) {
        modifiers.put((Object)modifier.getSkill(), (Object)modifier);
    }

    public static Collection<Modifier> getBySkill(Skill skill) {
        return modifiers.get((Object)skill);
    }
}

