/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.bankedexperience.data.modifiers;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import net.runelite.api.Skill;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thestonedturtle.bankedexperience.data.Activity;
import thestonedturtle.bankedexperience.data.modifiers.ModifierComponent;
import thestonedturtle.bankedexperience.data.modifiers.ui.ModifierPanel;

public abstract class Modifier {
    private static final Logger log = LoggerFactory.getLogger(Modifier.class);
    private final Skill skill;
    private final String name;
    private final ImmutableSet<Activity> includedActivities;
    private final ImmutableSet<Activity> ignoredActivities;

    Modifier(Skill skill, String name) {
        this(skill, name, null, null);
    }

    Modifier(Skill skill, String name, Collection<Activity> included, Collection<Activity> ignored) {
        this.skill = skill;
        this.name = name;
        this.includedActivities = included == null ? ImmutableSet.of() : ImmutableSet.copyOf(included);
        this.ignoredActivities = ignored == null ? ImmutableSet.of() : ImmutableSet.copyOf(ignored);
    }

    public boolean appliesTo(Activity activity) {
        return this.skill.equals((Object)activity.getSkill()) && !this.ignoredActivities.contains((Object)activity) && (this.includedActivities.size() == 0 || this.includedActivities.contains((Object)activity));
    }

    public double appliedXpRate(Activity activity) {
        if (!this.appliesTo(activity)) {
            log.debug("Tried to modify an incompatible activity. Activity: {} | Modifier: {}", (Object)activity, (Object)this);
            return 0.0;
        }
        return activity.getXp();
    }

    public ModifierComponent generateModifierComponent() {
        return new ModifierPanel(this);
    }

    public boolean compatibleWith(Modifier modifier) {
        return true;
    }

    public boolean touchesSameActivity(Modifier modifier) {
        if (!modifier.getSkill().equals((Object)this.getSkill())) {
            return false;
        }
        if (modifier.getIncludedActivities().size() == 0 || this.getIncludedActivities().size() == 0) {
            return true;
        }
        for (Activity a : modifier.getIncludedActivities()) {
            if (!this.getIncludedActivities().contains((Object)a)) continue;
            return true;
        }
        return false;
    }

    public Skill getSkill() {
        return this.skill;
    }

    public String getName() {
        return this.name;
    }

    public ImmutableSet<Activity> getIncludedActivities() {
        return this.includedActivities;
    }

    public ImmutableSet<Activity> getIgnoredActivities() {
        return this.ignoredActivities;
    }
}

