/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.bankedexperience.data.modifiers;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import net.runelite.api.ItemComposition;
import net.runelite.api.Skill;
import net.runelite.client.game.ItemManager;
import thestonedturtle.bankedexperience.data.Activity;
import thestonedturtle.bankedexperience.data.modifiers.SkillingOutfit;

public class CarpentersOutfit
extends SkillingOutfit {
    private final Map<Activity, XpPerTask> xpPerMahoganyHomesActivityMap = ImmutableMap.builder().put((Object)Activity.MAHOGANY_HOMES_PLANK, (Object)new XpPerTask(39.955f, 53.695f)).put((Object)Activity.MAHOGANY_HOMES_OAK, (Object)new XpPerTask(66.163f, 133.84f)).put((Object)Activity.MAHOGANY_HOMES_TEAK, (Object)new XpPerTask(87.735f, 200.117f)).put((Object)Activity.MAHOGANY_HOMES_MAHOGANY, (Object)new XpPerTask(127.259f, 218.861f)).build();
    private static final Collection<Activity> EXCLUDED = ImmutableSet.of((Object)((Object)Activity.LONG_BONE), (Object)((Object)Activity.CURVED_BONE));

    CarpentersOutfit(ItemManager itemManager, ItemComposition ... items) {
        super(Skill.CONSTRUCTION, "Carpenter's Outfit", null, EXCLUDED, itemManager, items);
    }

    @Override
    public double appliedXpRate(Activity activity) {
        XpPerTask xpPerTask = this.xpPerMahoganyHomesActivityMap.get((Object)activity);
        if (xpPerTask == null) {
            return super.appliedXpRate(activity);
        }
        double bonusXP = this.calculateBonusXPMultiplier();
        double averagePlankXp = xpPerTask.averagePlankXp;
        double averageCompletionXpPerPlank = xpPerTask.averageCompletionXpPerPlank;
        return averagePlankXp * bonusXP + averageCompletionXpPerPlank;
    }

    private static class XpPerTask {
        private float averagePlankXp;
        private float averageCompletionXpPerPlank;

        public XpPerTask(float averagePlankXp, float averageCompletionXpPerPlank) {
            this.averagePlankXp = averagePlankXp;
            this.averageCompletionXpPerPlank = averageCompletionXpPerPlank;
        }
    }
}

