/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.bankedexperience.data;

import javax.annotation.Nullable;
import net.runelite.api.ItemComposition;
import net.runelite.client.game.ItemManager;
import thestonedturtle.bankedexperience.data.ItemInfo;

public class ItemStack {
    private final int id;
    private final double qty;
    @Nullable
    private ItemInfo info;

    public void updateItemInfo(ItemManager itemManager) {
        ItemComposition composition = itemManager.getItemComposition(this.id);
        this.info = new ItemInfo(composition.getName(), composition.isStackable());
    }

    public int getId() {
        return this.id;
    }

    public double getQty() {
        return this.qty;
    }

    @Nullable
    public ItemInfo getInfo() {
        return this.info;
    }

    public void setInfo(@Nullable ItemInfo info) {
        this.info = info;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemStack)) {
            return false;
        }
        ItemStack other = (ItemStack)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (Double.compare(this.getQty(), other.getQty()) != 0) {
            return false;
        }
        ItemInfo this$info = this.getInfo();
        ItemInfo other$info = other.getInfo();
        return !(this$info == null ? other$info != null : !((Object)this$info).equals(other$info));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ItemStack;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        long $qty = Double.doubleToLongBits(this.getQty());
        result = result * 59 + (int)($qty >>> 32 ^ $qty);
        ItemInfo $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : ((Object)$info).hashCode());
        return result;
    }

    public String toString() {
        return "ItemStack(id=" + this.getId() + ", qty=" + this.getQty() + ", info=" + this.getInfo() + ")";
    }

    public ItemStack(int id, double qty) {
        this.id = id;
        this.qty = qty;
    }
}

