/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.bankedexperience.data;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.runelite.api.ItemComposition;
import net.runelite.api.Skill;
import net.runelite.client.game.ItemManager;
import thestonedturtle.bankedexperience.data.Activity;
import thestonedturtle.bankedexperience.data.ItemInfo;

public enum ExperienceItem {
    LOGS(1511, Skill.CONSTRUCTION, "Logs"),
    OAK_LOGS(1521, Skill.CONSTRUCTION, "Logs"),
    TEAK_LOGS(6333, Skill.CONSTRUCTION, "Logs"),
    MAHOGANY_LOGS(6332, Skill.CONSTRUCTION, "Logs"),
    PLANK(960, Skill.CONSTRUCTION, "Planks"),
    OAK_PLANK(8778, Skill.CONSTRUCTION, "Planks"),
    TEAK_PLANK(8780, Skill.CONSTRUCTION, "Planks"),
    MAHOGANY_PLANK(8782, Skill.CONSTRUCTION, "Planks"),
    LONG_BONE(10976, Skill.CONSTRUCTION, "Other"),
    CURVED_BONE(10977, Skill.CONSTRUCTION, "Other"),
    GRIMY_GUAM_LEAF(199, Skill.HERBLORE, "Grimy Herbs"),
    GRIMY_MARRENTILL(201, Skill.HERBLORE, "Grimy Herbs"),
    GRIMY_TARROMIN(203, Skill.HERBLORE, "Grimy Herbs"),
    GRIMY_HARRALANDER(205, Skill.HERBLORE, "Grimy Herbs"),
    GRIMY_RANARR_WEED(207, Skill.HERBLORE, "Grimy Herbs"),
    GRIMY_TOADFLAX(3049, Skill.HERBLORE, "Grimy Herbs"),
    GRIMY_IRIT_LEAF(209, Skill.HERBLORE, "Grimy Herbs"),
    GRIMY_AVANTOE(211, Skill.HERBLORE, "Grimy Herbs"),
    GRIMY_KWUARM(213, Skill.HERBLORE, "Grimy Herbs"),
    GRIMY_SNAPDRAGON(3051, Skill.HERBLORE, "Grimy Herbs"),
    GRIMY_CADANTINE(215, Skill.HERBLORE, "Grimy Herbs"),
    GRIMY_LANTADYME(2485, Skill.HERBLORE, "Grimy Herbs"),
    GRIMY_DWARF_WEED(217, Skill.HERBLORE, "Grimy Herbs"),
    GRIMY_TORSTOL(219, Skill.HERBLORE, "Grimy Herbs"),
    GUAM_LEAF(249, Skill.HERBLORE, "Cleaned Herbs"),
    MARRENTILL(251, Skill.HERBLORE, "Cleaned Herbs"),
    TARROMIN(253, Skill.HERBLORE, "Cleaned Herbs"),
    HARRALANDER(255, Skill.HERBLORE, "Cleaned Herbs"),
    RANARR_WEED(257, Skill.HERBLORE, "Cleaned Herbs"),
    TOADFLAX(2998, Skill.HERBLORE, "Cleaned Herbs"),
    IRIT_LEAF(259, Skill.HERBLORE, "Cleaned Herbs"),
    AVANTOE(261, Skill.HERBLORE, "Cleaned Herbs"),
    KWUARM(263, Skill.HERBLORE, "Cleaned Herbs"),
    SNAPDRAGON(3000, Skill.HERBLORE, "Cleaned Herbs"),
    CADANTINE(265, Skill.HERBLORE, "Cleaned Herbs"),
    LANTADYME(2481, Skill.HERBLORE, "Cleaned Herbs"),
    DWARF_WEED(267, Skill.HERBLORE, "Cleaned Herbs"),
    TORSTOL(269, Skill.HERBLORE, "Cleaned Herbs"),
    GUAM_LEAF_POTION_UNF(91, Skill.HERBLORE, "Unfinished Potions"),
    MARRENTILL_POTION_UNF(93, Skill.HERBLORE, "Unfinished Potions"),
    TARROMIN_POTION_UNF(95, Skill.HERBLORE, "Unfinished Potions"),
    HARRALANDER_POTION_UNF(97, Skill.HERBLORE, "Unfinished Potions"),
    RANARR_POTION_UNF(99, Skill.HERBLORE, "Unfinished Potions"),
    TOADFLAX_POTION_UNF(3002, Skill.HERBLORE, "Unfinished Potions"),
    IRIT_POTION_UNF(101, Skill.HERBLORE, "Unfinished Potions"),
    AVANTOE_POTION_UNF(103, Skill.HERBLORE, "Unfinished Potions"),
    KWUARM_POTION_UNF(105, Skill.HERBLORE, "Unfinished Potions"),
    SNAPDRAGON_POTION_UNF(3004, Skill.HERBLORE, "Unfinished Potions"),
    CADANTINE_POTION_UNF(107, Skill.HERBLORE, "Unfinished Potions"),
    CADANTINE_BLOOD_POTION_UNF(22443, Skill.HERBLORE, "Unfinished Potions"),
    LANTADYME_POTION_UNF(2483, Skill.HERBLORE, "Unfinished Potions"),
    DWARF_WEED_POTION_UNF(109, Skill.HERBLORE, "Unfinished Potions"),
    TORSTOL_POTION_UNF(111, Skill.HERBLORE, "Unfinished Potions"),
    MARK_OF_GRACE(11849, Skill.HERBLORE, "Other"),
    AMYLASE_CRYSTAL(12640, Skill.HERBLORE, "Other"),
    LAVA_SCALE_SHARD(11994, Skill.HERBLORE, "Other"),
    EXTENDED_ANTIFIRE4(11951, Skill.HERBLORE),
    ANTIDOTE_PLUS_POTION_UNF(5942, Skill.HERBLORE, "Unfinished Potions"),
    ANTIDOTE_PLUS_PLUS_POTION_UNF(5951, Skill.HERBLORE, "Unfinished Potions"),
    CACTUS_SPINE(6016, Skill.HERBLORE, "Other"),
    WEAPON_POISON_PLUS_UNF(5936, Skill.HERBLORE, "Unfinished Potions"),
    CAVE_NIGHTSHADE(2398, Skill.HERBLORE, "Other"),
    WEAPON_POISON_PLUS_PLUS_UNF(5939, Skill.HERBLORE, "Unfinished Potions"),
    BONES(526, Skill.PRAYER, "Bones"),
    WOLF_BONES(2859, Skill.PRAYER, "Bones"),
    BURNT_BONES(528, Skill.PRAYER, "Bones"),
    MONKEY_BONES(3183, Skill.PRAYER, "Bones"),
    BAT_BONES(530, Skill.PRAYER, "Bones"),
    JOGRE_BONES(3125, Skill.PRAYER, "Bones"),
    BIG_BONES(532, Skill.PRAYER, "Bones"),
    ZOGRE_BONES(4812, Skill.PRAYER, "Bones"),
    SHAIKAHAN_BONES(3123, Skill.PRAYER, "Bones"),
    BABYDRAGON_BONES(534, Skill.PRAYER, "Bones"),
    WYVERN_BONES(6812, Skill.PRAYER, "Bones"),
    DRAGON_BONES(536, Skill.PRAYER, "Bones"),
    FAYRG_BONES(4830, Skill.PRAYER, "Bones"),
    LAVA_DRAGON_BONES(11943, Skill.PRAYER, "Bones"),
    RAURG_BONES(4832, Skill.PRAYER, "Bones"),
    DAGANNOTH_BONES(6729, Skill.PRAYER, "Bones"),
    OURG_BONES(4834, Skill.PRAYER, "Bones"),
    SUPERIOR_DRAGON_BONES(22124, Skill.PRAYER, "Bones"),
    WYRM_BONES(22780, Skill.PRAYER, "Bones"),
    DRAKE_BONES(22783, Skill.PRAYER, "Bones"),
    HYDRA_BONES(22786, Skill.PRAYER, "Bones"),
    BONEMEAL(4255, Skill.PRAYER, "Bonemeal"),
    WOLF_BONEMEAL(4262, Skill.PRAYER, "Bonemeal"),
    BURNT_BONEMEAL(4258, Skill.PRAYER, "Bonemeal"),
    MONKEY_BONEMEAL(4267, Skill.PRAYER, "Bonemeal"),
    BAT_BONEMEAL(4256, Skill.PRAYER, "Bonemeal"),
    JOGRE_BONEMEAL(4271, Skill.PRAYER, "Bonemeal"),
    BIG_BONEMEAL(4257, Skill.PRAYER, "Bonemeal"),
    ZOGRE_BONEMEAL(4852, Skill.PRAYER, "Bonemeal"),
    SHAIKAHAN_BONEMEAL(5615, Skill.PRAYER, "Bonemeal"),
    BABYDRAGON_BONEMEAL(4260, Skill.PRAYER, "Bonemeal"),
    WYVERN_BONEMEAL(6810, Skill.PRAYER, "Bonemeal"),
    DRAGON_BONEMEAL(4261, Skill.PRAYER, "Bonemeal"),
    FAYRG_BONEMEAL(4853, Skill.PRAYER, "Bonemeal"),
    LAVA_DRAGON_BONEMEAL(11922, Skill.PRAYER, "Bonemeal"),
    RAURG_BONEMEAL(4854, Skill.PRAYER, "Bonemeal"),
    DAGANNOTH_BONEMEAL(6728, Skill.PRAYER, "Bonemeal"),
    OURG_BONEMEAL(4855, Skill.PRAYER, "Bonemeal"),
    SUPERIOR_DRAGON_BONEMEAL(22116, Skill.PRAYER, "Bonemeal"),
    WYRM_BONEMEAL(22754, Skill.PRAYER, "Bonemeal"),
    DRAKE_BONEMEAL(22756, Skill.PRAYER, "Bonemeal"),
    HYDRA_BONEMEAL(22758, Skill.PRAYER, "Bonemeal"),
    LOAR_REMAINS(3396, Skill.PRAYER, "Shades"),
    PHRIN_REMAINS(3398, Skill.PRAYER, "Shades"),
    RIYL_REMAINS(3400, Skill.PRAYER, "Shades"),
    ASYN_REMAINS(3402, Skill.PRAYER, "Shades"),
    FIYR_REMAINS(3404, Skill.PRAYER, "Shades"),
    ENSOULED_GOBLIN_HEAD(13448, Skill.PRAYER, "Ensouled Heads"),
    ENSOULED_MONKEY_HEAD(13451, Skill.PRAYER, "Ensouled Heads"),
    ENSOULED_IMP_HEAD(13454, Skill.PRAYER, "Ensouled Heads"),
    ENSOULED_MINOTAUR_HEAD(13457, Skill.PRAYER, "Ensouled Heads"),
    ENSOULED_SCORPION_HEAD(13460, Skill.PRAYER, "Ensouled Heads"),
    ENSOULED_BEAR_HEAD(13463, Skill.PRAYER, "Ensouled Heads"),
    ENSOULED_UNICORN_HEAD(13466, Skill.PRAYER, "Ensouled Heads"),
    ENSOULED_DOG_HEAD(13469, Skill.PRAYER, "Ensouled Heads"),
    ENSOULED_CHAOS_DRUID_HEAD(13472, Skill.PRAYER, "Ensouled Heads"),
    ENSOULED_GIANT_HEAD(13475, Skill.PRAYER, "Ensouled Heads"),
    ENSOULED_OGRE_HEAD(13478, Skill.PRAYER, "Ensouled Heads"),
    ENSOULED_ELF_HEAD(13481, Skill.PRAYER, "Ensouled Heads"),
    ENSOULED_TROLL_HEAD(13484, Skill.PRAYER, "Ensouled Heads"),
    ENSOULED_HORROR_HEAD(13487, Skill.PRAYER, "Ensouled Heads"),
    ENSOULED_KALPHITE_HEAD(13490, Skill.PRAYER, "Ensouled Heads"),
    ENSOULED_DAGANNOTH_HEAD(13493, Skill.PRAYER, "Ensouled Heads"),
    ENSOULED_BLOODVELD_HEAD(13496, Skill.PRAYER, "Ensouled Heads"),
    ENSOULED_TZHAAR_HEAD(13499, Skill.PRAYER, "Ensouled Heads"),
    ENSOULED_DEMON_HEAD(13502, Skill.PRAYER, "Ensouled Heads"),
    ENSOULED_HELLHOUND_HEAD(26997, Skill.PRAYER, "Ensouled Heads"),
    ENSOULED_AVIANSIE_HEAD(13505, Skill.PRAYER, "Ensouled Heads"),
    ENSOULED_ABYSSAL_HEAD(13508, Skill.PRAYER, "Ensouled Heads"),
    ENSOULED_DRAGON_HEAD(13511, Skill.PRAYER, "Ensouled Heads"),
    SMALL_LIMBS(21570, Skill.PRAYER, "Fossils"),
    SMALL_SPINE(21572, Skill.PRAYER, "Fossils"),
    SMALL_RIBS(21574, Skill.PRAYER, "Fossils"),
    SMALL_PELVIS(21576, Skill.PRAYER, "Fossils"),
    SMALL_SKULL(21578, Skill.PRAYER, "Fossils"),
    SMALL_FOSSIL(21562, Skill.PRAYER, "Fossils"),
    MEDIUM_LIMBS(21580, Skill.PRAYER, "Fossils"),
    MEDIUM_SPINE(21582, Skill.PRAYER, "Fossils"),
    MEDIUM_RIBS(21584, Skill.PRAYER, "Fossils"),
    MEDIUM_PELVIS(21586, Skill.PRAYER, "Fossils"),
    MEDIUM_SKULL(21588, Skill.PRAYER, "Fossils"),
    MEDIUM_FOSSIL(21564, Skill.PRAYER, "Fossils"),
    LARGE_LIMBS(21600, Skill.PRAYER, "Fossils"),
    LARGE_SPINE(21602, Skill.PRAYER, "Fossils"),
    LARGE_RIBS(21604, Skill.PRAYER, "Fossils"),
    LARGE_PELVIS(21606, Skill.PRAYER, "Fossils"),
    LARGE_SKULL(21608, Skill.PRAYER, "Fossils"),
    LARGE_FOSSIL(21566, Skill.PRAYER, "Fossils"),
    RARE_LIMBS(21610, Skill.PRAYER, "Fossils"),
    RARE_SPINE(21612, Skill.PRAYER, "Fossils"),
    RARE_RIBS(21614, Skill.PRAYER, "Fossils"),
    RARE_PELVIS(21616, Skill.PRAYER, "Fossils"),
    RARE_SKULL(21618, Skill.PRAYER, "Fossils"),
    RARE_TUSK(21620, Skill.PRAYER, "Fossils"),
    RARE_FOSSIL(21568, Skill.PRAYER, "Fossils"),
    FIENDISH_ASHES(25766, Skill.PRAYER, "Ashes"),
    VILE_ASHES(25769, Skill.PRAYER, "Ashes"),
    MALICIOUS_ASHES(25772, Skill.PRAYER, "Ashes"),
    ABYSSAL_ASHES(25775, Skill.PRAYER, "Ashes"),
    INFERNAL_ASHES(25778, Skill.PRAYER, "Ashes"),
    BIRD_EGG_NEST_RED(5070, Skill.PRAYER),
    BIRD_EGG_NEST_BLUE(5072, Skill.PRAYER),
    BIRD_EGG_NEST_GREEN(5071, Skill.PRAYER),
    BIRD_EGG_RED(5076, Skill.PRAYER),
    BIRD_EGG_BLUE(5077, Skill.PRAYER),
    BIRD_EGG_GREEN(5078, Skill.PRAYER),
    RAW_BEEF(2132, Skill.COOKING, "Meat"),
    RAW_RAT_MEAT(2134, Skill.COOKING, "Meat"),
    RAW_BEAR_MEAT(2136, Skill.COOKING, "Meat"),
    RAW_YAK_MEAT(10816, Skill.COOKING, "Meat"),
    RAW_UGTHANKI_MEAT(1859, Skill.COOKING, "Meat"),
    RAW_CHICKEN(2138, Skill.COOKING, "Meat"),
    RAW_RABBIT(3226, Skill.COOKING, "Meat"),
    RAW_SHRIMPS(317, Skill.COOKING, "Fish"),
    RAW_SARDINE(327, Skill.COOKING, "Fish"),
    RAW_ANCHOVIES(321, Skill.COOKING, "Fish"),
    RAW_HERRING(345, Skill.COOKING, "Fish"),
    RAW_MACKEREL(353, Skill.COOKING, "Fish"),
    RAW_BIRD_MEAT(9978, Skill.COOKING, "Meat"),
    THIN_SNAIL(3363, Skill.COOKING, "Meat"),
    RAW_TROUT(335, Skill.COOKING, "Fish"),
    LEAN_SNAIL(3365, Skill.COOKING, "Meat"),
    RAW_COD(341, Skill.COOKING, "Fish"),
    RAW_PIKE(349, Skill.COOKING, "Fish"),
    FAT_SNAIL(3367, Skill.COOKING, "Meat"),
    RAW_BEAST_MEAT(9986, Skill.COOKING, "Meat"),
    RAW_SALMON(331, Skill.COOKING, "Fish"),
    RAW_TUNA(359, Skill.COOKING, "Fish"),
    RAW_RAINBOW_FISH(10138, Skill.COOKING, "Fish"),
    RAW_KARAMBWAN(3142, Skill.COOKING, "Fish"),
    RAW_LOBSTER(377, Skill.COOKING, "Fish"),
    RAW_BASS(363, Skill.COOKING, "Fish"),
    RAW_SWORDFISH(371, Skill.COOKING, "Fish"),
    RAW_MONKFISH(7944, Skill.COOKING, "Fish"),
    RAW_SHARK(383, Skill.COOKING, "Fish"),
    RAW_SEA_TURTLE(395, Skill.COOKING, "Fish"),
    RAW_ANGLERFISH(13439, Skill.COOKING, "Fish"),
    RAW_DARK_CRAB(11934, Skill.COOKING, "Fish"),
    RAW_MANTA_RAY(389, Skill.COOKING, "Fish"),
    GRAPES(1987, Skill.COOKING, "Other"),
    SWEETCORN(5986, Skill.COOKING, "Other"),
    UNCOOKED_STEW(2001, Skill.COOKING, "Other"),
    UNCOOKED_CURRY(2009, Skill.COOKING, "Other"),
    WOOL(1737, Skill.CRAFTING, "Misc"),
    FLAX(1779, Skill.CRAFTING, "Misc"),
    MOLTEN_GLASS(1775, Skill.CRAFTING, "Misc"),
    BATTLESTAFF(1391, Skill.CRAFTING, "Misc"),
    GOLD_BAR(2357, Skill.CRAFTING, "Misc"),
    COW_HIDE(1739, Skill.CRAFTING, "Leather"),
    LEATHER(1741, Skill.CRAFTING, "Leather"),
    HARD_LEATHER(1743, Skill.CRAFTING, "Leather"),
    STEEL_STUDS(2370, Skill.CRAFTING, "Leather"),
    GREEN_DRAGONHIDE(1753, Skill.CRAFTING, "D'hide"),
    GREEN_DRAGON_LEATHER(1745, Skill.CRAFTING, "D'hide"),
    BLUE_DRAGONHIDE(1751, Skill.CRAFTING, "D'hide"),
    BLUE_DRAGON_LEATHER(2505, Skill.CRAFTING, "D'hide"),
    RED_DRAGONHIDE(1749, Skill.CRAFTING, "D'hide"),
    RED_DRAGON_LEATHER(2507, Skill.CRAFTING, "D'hide"),
    BLACK_DRAGONHIDE(1747, Skill.CRAFTING, "D'hide"),
    BLACK_DRAGON_LEATHER(2509, Skill.CRAFTING, "D'hide"),
    UNCUT_OPAL(1625, Skill.CRAFTING, "Gems"),
    UNCUT_JADE(1627, Skill.CRAFTING, "Gems"),
    UNCUT_RED_TOPAZ(1629, Skill.CRAFTING, "Gems"),
    UNCUT_SAPPHIRE(1623, Skill.CRAFTING, "Gems"),
    UNCUT_EMERALD(1621, Skill.CRAFTING, "Gems"),
    UNCUT_RUBY(1619, Skill.CRAFTING, "Gems"),
    UNCUT_DIAMOND(1617, Skill.CRAFTING, "Gems"),
    UNCUT_DRAGONSTONE(1631, Skill.CRAFTING, "Gems"),
    UNCUT_ONYX(6571, Skill.CRAFTING, "Gems"),
    UNCUT_ZENYTE(19496, Skill.CRAFTING, "Gems"),
    OPAL(1609, Skill.CRAFTING, "Gems"),
    JADE(1611, Skill.CRAFTING, "Gems"),
    RED_TOPAZ(1613, Skill.CRAFTING, "Gems"),
    SAPPHIRE(1607, Skill.CRAFTING, "Gems"),
    EMERALD(1605, Skill.CRAFTING, "Gems"),
    RUBY(1603, Skill.CRAFTING, "Gems"),
    DIAMOND(1601, Skill.CRAFTING, "Gems"),
    DRAGONSTONE(1615, Skill.CRAFTING, "Gems"),
    ONYX(6573, Skill.CRAFTING, "Gems"),
    ZENYTE(19493, Skill.CRAFTING, "Gems"),
    SEAWEED(401, Skill.CRAFTING, "Misc"),
    SODA_ASH(1781, Skill.CRAFTING, "Misc"),
    GIANT_SEAWEED(21504, Skill.CRAFTING, "Misc"),
    SILVER_BAR(2355, Skill.CRAFTING, "Other"),
    AMETHYST(21347, Skill.CRAFTING, "Other"),
    SINEW(9436, Skill.CRAFTING),
    UNSTRUNG_SYMBOL(1714, Skill.CRAFTING),
    UNSTRUNG_EMBLEM(1720, Skill.CRAFTING),
    GOLD_AMULET_U(1673, Skill.CRAFTING),
    OPAL_AMULET_U(21099, Skill.CRAFTING),
    JADE_AMULET_U(21102, Skill.CRAFTING),
    TOPAZ_AMULET_U(21105, Skill.CRAFTING),
    SAPPHIRE_AMULET_U(1675, Skill.CRAFTING),
    EMERALD_AMULET_U(1677, Skill.CRAFTING),
    RUBY_AMULET_U(1679, Skill.CRAFTING),
    DIAMOND_AMULET_U(1681, Skill.CRAFTING),
    DRAGONSTONE_AMULET_U(1683, Skill.CRAFTING),
    ONYX_AMULET_U(6579, Skill.CRAFTING),
    ZENYTE_AMULET_U(19501, Skill.CRAFTING),
    IRON_ORE(440, Skill.SMITHING, "Ore"),
    SILVER_ORE(442, Skill.SMITHING, "Ore"),
    GOLD_ORE(444, Skill.SMITHING, "Ore"),
    MITHRIL_ORE(447, Skill.SMITHING, "Ore"),
    ADAMANTITE_ORE(449, Skill.SMITHING, "Ore"),
    RUNITE_ORE(451, Skill.SMITHING, "Ore"),
    BRONZE_BAR(2349, Skill.SMITHING, "Bars"),
    IRON_BAR(2351, Skill.SMITHING, "Bars"),
    STEEL_BAR(2353, Skill.SMITHING, "Bars"),
    MITHRIL_BAR(2359, Skill.SMITHING, "Bars"),
    ADAMANTITE_BAR(2361, Skill.SMITHING, "Bars"),
    RUNITE_BAR(2363, Skill.SMITHING, "Bars"),
    ACORN(5312, Skill.FARMING, "Seeds"),
    WILLOW_SEED(5313, Skill.FARMING, "Seeds"),
    MAPLE_SEED(5314, Skill.FARMING, "Seeds"),
    YEW_SEED(5315, Skill.FARMING, "Seeds"),
    MAGIC_SEED(5316, Skill.FARMING, "Seeds"),
    APPLE_TREE_SEED(5283, Skill.FARMING, "Seeds"),
    BANANA_TREE_SEED(5284, Skill.FARMING, "Seeds"),
    ORANGE_TREE_SEED(5285, Skill.FARMING, "Seeds"),
    CURRY_TREE_SEED(5286, Skill.FARMING, "Seeds"),
    PINEAPPLE_SEED(5287, Skill.FARMING, "Seeds"),
    PAPAYA_TREE_SEED(5288, Skill.FARMING, "Seeds"),
    PALM_TREE_SEED(5289, Skill.FARMING, "Seeds"),
    CALQUAT_TREE_SEED(5290, Skill.FARMING, "Seeds"),
    TEAK_SEED(21486, Skill.FARMING, "Seeds"),
    MAHOGANY_SEED(21488, Skill.FARMING, "Seeds"),
    SPIRIT_SEED(5317, Skill.FARMING, "Seeds"),
    DRAGONFRUIT_TREE_SEED(22877, Skill.FARMING, "Seeds"),
    CELASTRUS_SEED(22869, Skill.FARMING, "Seeds"),
    REDWOOD_TREE_SEED(22871, Skill.FARMING, "Seeds"),
    CRYSTAL_ACORN(23661, Skill.FARMING, "Seeds"),
    HESPORI_SEED(22875, Skill.FARMING, "Seeds"),
    OAK_SAPLING(5370, Skill.FARMING, "Saplings"),
    WILLOW_SAPLING(5371, Skill.FARMING, "Saplings"),
    MAPLE_SAPLING(5372, Skill.FARMING, "Saplings"),
    YEW_SAPLING(5373, Skill.FARMING, "Saplings"),
    MAGIC_SAPLING(5374, Skill.FARMING, "Saplings"),
    APPLE_TREE_SAPLING(5496, Skill.FARMING, "Saplings"),
    BANANA_TREE_SAPLING(5497, Skill.FARMING, "Saplings"),
    ORANGE_TREE_SAPLING(5498, Skill.FARMING, "Saplings"),
    CURRY_TREE_SAPLING(5499, Skill.FARMING, "Saplings"),
    PINEAPPLE_SAPLING(5500, Skill.FARMING, "Saplings"),
    PAPAYA_TREE_SAPLING(5501, Skill.FARMING, "Saplings"),
    PALM_TREE_SAPLING(5502, Skill.FARMING, "Saplings"),
    CALQUAT_TREE_SAPLING(5503, Skill.FARMING, "Saplings"),
    TEAK_SAPLING(21477, Skill.FARMING, "Saplings"),
    MAHOGANY_SAPLING(21480, Skill.FARMING, "Saplings"),
    SPIRIT_SAPLING(5375, Skill.FARMING, "Saplings"),
    DRAGONFRUIT_SAPLING(22866, Skill.FARMING, "Saplings"),
    CELASTRUS_SAPLING(22856, Skill.FARMING, "Saplings"),
    REDWOOD_SAPLING(22859, Skill.FARMING, "Saplings"),
    CRYSTAL_SAPLING(23659, Skill.FARMING, "Saplings"),
    F_ARROW_SHAFT(52, Skill.FLETCHING, "Headless arrow"),
    F_LOGS(1511, Skill.FLETCHING, "Logs"),
    F_OAK_LOGS(1521, Skill.FLETCHING, "Logs"),
    F_WILLOW_LOGS(1519, Skill.FLETCHING, "Logs"),
    F_TEAK_LOGS(6333, Skill.FLETCHING, "Logs"),
    F_MAPLE_LOGS(1517, Skill.FLETCHING, "Logs"),
    F_MAHOGANY_LOGS(6332, Skill.FLETCHING, "Logs"),
    F_YEW_LOGS(1515, Skill.FLETCHING, "Logs"),
    F_MAGIC_LOGS(1513, Skill.FLETCHING, "Logs"),
    F_REDWOOD_LOGS(19669, Skill.FLETCHING, "Logs"),
    F_SHORTBOW_U(50, Skill.FLETCHING, "Unstrung"),
    F_LONGBOW_U(48, Skill.FLETCHING, "Unstrung"),
    F_OAK_SHORTBOW_U(54, Skill.FLETCHING, "Unstrung"),
    F_OAK_LONGBOW_U(56, Skill.FLETCHING, "Unstrung"),
    F_WILLOW_SHORTBOW_U(60, Skill.FLETCHING, "Unstrung"),
    F_WILLOW_LONGBOW_U(58, Skill.FLETCHING, "Unstrung"),
    F_MAPLE_SHORTBOW_U(64, Skill.FLETCHING, "Unstrung"),
    F_MAPLE_LONGBOW_U(62, Skill.FLETCHING, "Unstrung"),
    F_YEW_SHORTBOW_U(68, Skill.FLETCHING, "Unstrung"),
    F_YEW_LONGBOW_U(66, Skill.FLETCHING, "Unstrung"),
    F_MAGIC_SHORTBOW_U(72, Skill.FLETCHING, "Unstrung"),
    F_MAGIC_LONGBOW_U(70, Skill.FLETCHING, "Unstrung"),
    F_BRONZE_DART_TIP(819, Skill.FLETCHING, "Dart tip"),
    F_IRON_DART_TIP(820, Skill.FLETCHING, "Dart tip"),
    F_STEEL_DART_TIP(821, Skill.FLETCHING, "Dart tip"),
    F_MITHRIL_DART_TIP(822, Skill.FLETCHING, "Dart tip"),
    F_ADAMANT_DART_TIP(823, Skill.FLETCHING, "Dart tip"),
    F_RUNE_DART_TIP(824, Skill.FLETCHING, "Dart tip"),
    F_AMETHYST_DART_TIP(25853, Skill.FLETCHING, "Dart tip"),
    F_DRAGON_DART_TIP(11232, Skill.FLETCHING, "Dart tip"),
    F_BRONZE_ARROWTIPS(39, Skill.FLETCHING, "Arrow"),
    F_IRON_ARROWTIPS(40, Skill.FLETCHING, "Arrow"),
    F_STEEL_ARROWTIPS(41, Skill.FLETCHING, "Arrow"),
    F_MITHRIL_ARROWTIPS(42, Skill.FLETCHING, "Arrow"),
    F_BROAD_ARROWHEADS(11874, Skill.FLETCHING, "Arrow"),
    F_ADAMANT_ARROWTIPS(43, Skill.FLETCHING, "Arrow"),
    F_RUNE_ARROWTIPS(44, Skill.FLETCHING, "Arrow"),
    F_AMETHYST_ARROWTIPS(21350, Skill.FLETCHING, "Arrow"),
    F_DRAGON_ARROWTIPS(11237, Skill.FLETCHING, "Arrow"),
    BRONZE_BOLTS(9375, Skill.FLETCHING, "Bolts"),
    BLURITE_BOLTS(9376, Skill.FLETCHING, "Bolts"),
    IRON_BOLTS(9377, Skill.FLETCHING, "Bolts"),
    SILVER_BOLTS(9382, Skill.FLETCHING, "Bolts"),
    STEEL_BOLTS(9378, Skill.FLETCHING, "Bolts"),
    MITHRIL_BOLTS(9379, Skill.FLETCHING, "Bolts"),
    BROAD_BOLTS(11876, Skill.FLETCHING, "Bolts"),
    ADAMANT_BOLTS(9380, Skill.FLETCHING, "Bolts"),
    RUNE_BOLTS(9381, Skill.FLETCHING, "Bolts"),
    DRAGON_BOLTS(21930, Skill.FLETCHING, "Bolts"),
    F_WOODEN_STOCK(9440, Skill.FLETCHING, "Stock"),
    F_OAK_STOCK(9442, Skill.FLETCHING, "Stock"),
    F_WILLOW_STOCK(9444, Skill.FLETCHING, "Stock"),
    F_TEAK_STOCK(9446, Skill.FLETCHING, "Stock"),
    F_MAPLE_STOCK(9448, Skill.FLETCHING, "Stock"),
    F_MAHOGANY_STOCK(9450, Skill.FLETCHING, "Stock"),
    F_YEW_STOCK(9452, Skill.FLETCHING, "Stock"),
    F_MAGIC_STOCK(21952, Skill.FLETCHING, "Stock"),
    F_BRONZE_CROSSBOW_U(9454, Skill.FLETCHING, "Unstrung Crossbow"),
    F_BLURITE_CROSSBOW_U(9456, Skill.FLETCHING, "Unstrung Crossbow"),
    F_IRON_CROSSBOW_U(9457, Skill.FLETCHING, "Unstrung Crossbow"),
    F_STEEL_CROSSBOW_U(9459, Skill.FLETCHING, "Unstrung Crossbow"),
    F_MITHRIL_CROSSBOW_U(9461, Skill.FLETCHING, "Unstrung Crossbow"),
    F_ADAMANTITE_CROSSBOW_U(9463, Skill.FLETCHING, "Unstrung Crossbow"),
    F_RUNITE_CROSSBOW_U(9465, Skill.FLETCHING, "Unstrung Crossbow"),
    F_DRAGON_CROSSBOW_U(21921, Skill.FLETCHING, "Unstrung Crossbow"),
    F_CELASTRUS_BARK(22935, Skill.FLETCHING, "Other"),
    BRONZE_JAVELIN_HEADS(19570, Skill.FLETCHING, "Javelin Heads"),
    IRON_JAVELIN_HEADS(19572, Skill.FLETCHING, "Javelin Heads"),
    STEEL_JAVELIN_HEADS(19574, Skill.FLETCHING, "Javelin Heads"),
    MITHRIL_JAVELIN_HEADS(19576, Skill.FLETCHING, "Javelin Heads"),
    ADAMANT_JAVELIN_HEADS(19578, Skill.FLETCHING, "Javelin Heads"),
    RUNE_JAVELIN_HEADS(19580, Skill.FLETCHING, "Javelin Heads"),
    AMETHYST_JAVELIN_HEADS(21352, Skill.FLETCHING, "Javelin Heads"),
    DRAGON_JAVELIN_HEADS(19582, Skill.FLETCHING, "Javelin Heads"),
    H_LOGS(1511, Skill.HUNTER, "Bird houses"),
    BIRD_HOUSE(21512, Skill.HUNTER, "Bird houses"),
    H_OAK_LOGS(1521, Skill.HUNTER, "Bird houses"),
    OAK_BIRD_HOUSE(21515, Skill.HUNTER, "Bird houses"),
    H_WILLOW_LOGS(1519, Skill.HUNTER, "Bird houses"),
    WILLOW_BIRD_HOUSE(21518, Skill.HUNTER, "Bird houses"),
    H_TEAK_LOGS(6333, Skill.HUNTER, "Bird houses"),
    TEAK_BIRD_HOUSE(21521, Skill.HUNTER, "Bird houses"),
    H_MAPLE_LOGS(1517, Skill.HUNTER, "Bird houses"),
    MAPLE_BIRD_HOUSE(22192, Skill.HUNTER, "Bird houses"),
    H_MAHOGANY_LOGS(6332, Skill.HUNTER, "Bird houses"),
    MAHOGANY_BIRD_HOUSE(22195, Skill.HUNTER, "Bird houses"),
    H_YEW_LOGS(1515, Skill.HUNTER, "Bird houses"),
    YEW_BIRD_HOUSE(22198, Skill.HUNTER, "Bird houses"),
    H_MAGIC_LOGS(1513, Skill.HUNTER, "Bird houses"),
    MAGIC_BIRD_HOUSE(22201, Skill.HUNTER, "Bird houses"),
    H_REDWOOD_LOGS(19669, Skill.HUNTER, "Bird houses"),
    REDWOOD_BIRD_HOUSE(22204, Skill.HUNTER, "Bird houses"),
    FM_LOGS(1511, Skill.FIREMAKING, "logs"),
    FM_ACHEY_TREE_LOGS(2862, Skill.FIREMAKING, "logs"),
    FM_OAK_LOGS(1521, Skill.FIREMAKING, "logs"),
    FM_WILLOW_LOGS(1519, Skill.FIREMAKING, "logs"),
    FM_TEAK_LOGS(6333, Skill.FIREMAKING, "logs"),
    FM_ARCTIC_PINE_LOGS(10810, Skill.FIREMAKING, "logs"),
    FM_MAPLE_LOGS(1517, Skill.FIREMAKING, "logs"),
    FM_MAHOGANY_LOGS(6332, Skill.FIREMAKING, "logs"),
    FM_YEW_LOGS(1515, Skill.FIREMAKING, "logs"),
    FM_BLISTERWOOD_LOGS(24691, Skill.FIREMAKING, "logs"),
    FM_MAGIC_LOGS(1513, Skill.FIREMAKING, "logs"),
    FM_REDWOOD_LOGS(19669, Skill.FIREMAKING, "logs"),
    WINTER_SQIRK(10847, Skill.THIEVING, "Sqirks"),
    WINTER_SQIRKJUICE(10851, Skill.THIEVING, "Sqirks"),
    SPRING_SQIRK(10844, Skill.THIEVING, "Sqirks"),
    SPRING_SQIRKJUICE(10848, Skill.THIEVING, "Sqirks"),
    AUTUMN_SQIRK(10846, Skill.THIEVING, "Sqirks"),
    AUTUMN_SQIRKJUICE(10850, Skill.THIEVING, "Sqirks"),
    SUMMER_SQIRK(10845, Skill.THIEVING, "Sqirks"),
    SUMMER_SQIRKJUICE(10849, Skill.THIEVING, "Sqirks");

    private final int itemID;
    private final Skill skill;
    private final String category;
    private ItemInfo itemInfo = null;
    private Activity selectedActivity;
    private static final Multimap<Skill, ExperienceItem> SKILL_MAP;
    private static final Map<Integer, ExperienceItem> ITEM_ID_MAP;

    private ExperienceItem(int itemID, Skill skill) {
        this.itemID = itemID;
        this.category = "NA";
        this.skill = skill;
    }

    private ExperienceItem(int itemID, Skill skill, String category) {
        this.itemID = itemID;
        this.category = category;
        this.skill = skill;
    }

    public static Collection<ExperienceItem> getBySkill(Skill skill) {
        ArrayList items = SKILL_MAP.get((Object)skill);
        if (items == null) {
            items = new ArrayList();
        }
        return items;
    }

    public static ExperienceItem getByItemId(int id) {
        return ITEM_ID_MAP.get(id);
    }

    public static void prepareItemCompositions(ItemManager m) {
        for (ExperienceItem i : ExperienceItem.values()) {
            if (i.itemInfo != null) {
                return;
            }
            ItemComposition c = m.getItemComposition(i.getItemID());
            i.itemInfo = new ItemInfo(c.getName(), c.isStackable());
        }
    }

    public boolean isStackable() {
        return this.itemInfo != null && this.itemInfo.isStackable();
    }

    public int getItemID() {
        return this.itemID;
    }

    public Skill getSkill() {
        return this.skill;
    }

    public String getCategory() {
        return this.category;
    }

    public ItemInfo getItemInfo() {
        return this.itemInfo;
    }

    public Activity getSelectedActivity() {
        return this.selectedActivity;
    }

    public void setItemInfo(ItemInfo itemInfo) {
        this.itemInfo = itemInfo;
    }

    public void setSelectedActivity(Activity selectedActivity) {
        this.selectedActivity = selectedActivity;
    }

    static {
        SKILL_MAP = ArrayListMultimap.create();
        ITEM_ID_MAP = new HashMap<Integer, ExperienceItem>();
        for (ExperienceItem i : ExperienceItem.values()) {
            Skill s = i.getSkill();
            SKILL_MAP.put((Object)s, (Object)i);
            ITEM_ID_MAP.put(i.getItemID(), i);
        }
    }
}

