/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.bankedexperience.components.textinput;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.text.ParseException;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;

public class BoostInput
extends JPanel {
    private final JSpinner spinner;

    public BoostInput(Consumer<Integer> callback) {
        this.setLayout(new GridLayout(0, 1, 7, 7));
        this.setBorder(new EmptyBorder(0, 0, 5, 0));
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        JLabel uiLabel = new JLabel("Temporary Boost:");
        uiLabel.setForeground(Color.WHITE);
        uiLabel.setToolTipText("Enable activities that are this many levels above your current level");
        container.add((Component)uiLabel, "Center");
        SpinnerNumberModel model = new SpinnerNumberModel(0, 0, 99, 1);
        this.spinner = new JSpinner(model);
        JComponent editor = this.spinner.getEditor();
        JFormattedTextField spinnerTextField = ((JSpinner.DefaultEditor)editor).getTextField();
        spinnerTextField.setColumns(6);
        this.spinner.addChangeListener(ce -> callback.accept(this.getInputValue()));
        container.add((Component)this.spinner, "East");
        this.add(container);
    }

    public int getInputValue() {
        try {
            this.spinner.commitEdit();
            return (Integer)this.spinner.getValue();
        }
        catch (NumberFormatException | ParseException e) {
            return 0;
        }
    }

    public void setInputValue(int value) {
        this.spinner.getModel().setValue(value);
        this.spinner.setValue(value);
    }
}

