/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.bankedexperience.components.combobox;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.Text;
import thestonedturtle.bankedexperience.components.combobox.ComboBoxIconEntry;

public final class ComboBoxIconListRenderer
extends JLabel
implements ListCellRenderer {
    private String defaultText = "Select an option...";

    public Component getListCellRendererComponent(JList list, Object o, int index, boolean isSelected, boolean cellHasFocus) {
        String text;
        if (isSelected) {
            this.setBackground(ColorScheme.DARK_GRAY_COLOR);
            this.setForeground(Color.WHITE);
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        }
        this.setBorder(new EmptyBorder(5, 5, 5, 0));
        this.setIcon(null);
        if (index == -1 && o == null) {
            text = this.defaultText;
        } else if (o instanceof Enum) {
            text = Text.titleCase((Enum)((Enum)o));
        } else if (o instanceof ComboBoxIconEntry) {
            ComboBoxIconEntry e = (ComboBoxIconEntry)o;
            text = e.getText();
            this.setIcon(e.getIcon());
        } else {
            text = o.toString();
        }
        this.setText(text);
        return this;
    }

    public void setDefaultText(String defaultText) {
        this.defaultText = defaultText;
    }
}

