/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.bankedexperience.components;

import java.awt.GridLayout;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import net.runelite.client.game.ItemManager;
import net.runelite.client.util.AsyncBufferedImage;
import thestonedturtle.bankedexperience.BankedCalculator;
import thestonedturtle.bankedexperience.components.GridItem;
import thestonedturtle.bankedexperience.components.SelectionListener;
import thestonedturtle.bankedexperience.data.BankedItem;

public class SelectionGrid
extends JPanel {
    private static final int ITEMS_PER_ROW = 5;
    private final Map<BankedItem, GridItem> panelMap = new LinkedHashMap<BankedItem, GridItem>();
    private BankedItem selectedItem;
    private SelectionListener selectionListener;

    public void recreateGrid(BankedCalculator calc, Collection<BankedItem> items, ItemManager itemManager) {
        this.panelMap.clear();
        for (BankedItem item : items) {
            int qty = calc.getItemQty(item);
            boolean stackable = item.getItem().isStackable() || qty > 1;
            AsyncBufferedImage img = itemManager.getImage(item.getItem().getItemID(), qty, stackable);
            GridItem gridItem = new GridItem(item, img, qty, calc.getEnabledModifiers(), calc.getIgnoredItems().contains(item.getItem().name()), calc::setIgnoreAllItems);
            gridItem.setSelectionListener(new SelectionListener(){

                @Override
                public boolean selected(BankedItem item) {
                    if (SelectionGrid.this.selectionListener != null && !SelectionGrid.this.selectionListener.selected(item)) {
                        return false;
                    }
                    GridItem gridItem = SelectionGrid.this.panelMap.get(SelectionGrid.this.selectedItem);
                    if (gridItem != null) {
                        gridItem.unselect();
                    }
                    SelectionGrid.this.selectedItem = item;
                    return true;
                }

                @Override
                public boolean ignored(BankedItem item) {
                    return SelectionGrid.this.selectionListener != null && SelectionGrid.this.selectionListener.ignored(item);
                }
            });
            this.panelMap.put(item, gridItem);
        }
        this.refreshGridDisplay();
    }

    public void refreshGridDisplay() {
        this.removeAll();
        List items = this.panelMap.values().stream().filter(gi -> gi.getAmount() > 0).collect(Collectors.toList());
        int rowSize = (items.size() % 5 == 0 ? 0 : 1) + items.size() / 5;
        this.setLayout(new GridLayout(rowSize, 5, 1, 1));
        for (GridItem gridItem : items) {
            if (this.selectedItem == null) {
                gridItem.select();
                this.selectedItem = gridItem.getBankedItem();
            } else if (gridItem.getBankedItem().equals(this.selectedItem)) {
                gridItem.select();
            }
            this.add(gridItem);
        }
    }

    public Map<BankedItem, GridItem> getPanelMap() {
        return this.panelMap;
    }

    public BankedItem getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(BankedItem selectedItem) {
        this.selectedItem = selectedItem;
    }

    public void setSelectionListener(SelectionListener selectionListener) {
        this.selectionListener = selectionListener;
    }
}

