/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.bankedexperience.components;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.client.ui.ColorScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thestonedturtle.bankedexperience.BankedCalculator;
import thestonedturtle.bankedexperience.components.GridItem;
import thestonedturtle.bankedexperience.data.Activity;
import thestonedturtle.bankedexperience.data.BankedItem;
import thestonedturtle.bankedexperience.data.ItemInfo;
import thestonedturtle.bankedexperience.data.ItemStack;
import thestonedturtle.bankedexperience.data.Secondaries;

public class SecondaryGrid
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(SecondaryGrid.class);
    private final Multimap<Integer, SecondaryInfo> secMap = LinkedListMultimap.create();
    private final Map<Integer, ItemInfo> infoMap = new HashMap<Integer, ItemInfo>();
    private final Map<Integer, Integer> availableMap = new HashMap<Integer, Integer>();
    private final BankedCalculator calc;

    public SecondaryGrid(BankedCalculator calc, Collection<GridItem> items) {
        this.calc = calc;
        this.setLayout(new GridLayout(0, 5, 1, 1));
        this.updateSecMap(items);
    }

    private void refreshUI() {
        this.removeAll();
        Iterator iterator = this.secMap.keySet().iterator();
        while (iterator.hasNext()) {
            int itemID = (Integer)iterator.next();
            JLabel label = new JLabel();
            label.setOpaque(true);
            label.setMinimumSize(new Dimension(16, 16));
            label.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            label.setBorder(BorderFactory.createEmptyBorder(5, 0, 2, 0));
            label.setVerticalAlignment(0);
            label.setHorizontalAlignment(0);
            double qty = 0.0;
            StringBuilder resources = new StringBuilder();
            for (SecondaryInfo info : this.secMap.get((Object)itemID)) {
                if (info.getQty() == 0.0) continue;
                qty += info.getQty();
                resources.append("<br/>");
                resources.append(BankedCalculator.XP_FORMAT_COMMA.format(info.getQty())).append(" x ").append(info.getBankedItem().getItem().getItemInfo().getName());
            }
            this.calc.getItemManager().getImage(itemID, (int)Math.round(qty), qty > 0.0).addTo(label);
            ItemInfo info = this.infoMap.get(itemID);
            String itemName = info == null ? "" : info.getName();
            int available = this.availableMap.getOrDefault(itemID, 0);
            double result = (double)available - qty;
            String tooltip = "<html>" + itemName + "<br/>Banked: " + BankedCalculator.XP_FORMAT_COMMA.format(available) + "<br/>Result: " + (result > 0.0 ? "+" : "") + BankedCalculator.XP_FORMAT_COMMA.format(result) + "<br/>" + resources.toString() + "</html>";
            label.setToolTipText(tooltip);
            label.setBackground(result >= 0.0 ? GridItem.SELECTED_BACKGROUND : GridItem.IGNORED_BACKGROUND);
            this.add(label);
        }
    }

    /*
     * Could not resolve type clashes
     */
    public void updateSecMap(Collection<GridItem> items) {
        this.secMap.clear();
        this.infoMap.clear();
        this.availableMap.clear();
        for (GridItem item : items) {
            int available;
            int bankedQty;
            BankedItem banked;
            Activity a;
            if (item.isIgnored() || (a = (banked = item.getBankedItem()).getItem().getSelectedActivity()) == null || a.getSecondaries() == null || (bankedQty = this.calc.getItemQty(item.getBankedItem())) == 0) continue;
            Secondaries secondaries = a.getSecondaries();
            HashMap<Integer, Double> qtyMap = new HashMap<Integer, Double>();
            if (secondaries.getCustomHandler() instanceof Secondaries.ByDose) {
                Secondaries.ByDose byDose = (Secondaries.ByDose)secondaries.getCustomHandler();
                int firstId = byDose.getItems()[0];
                available = 0;
                for (int i = 0; i < byDose.getItems().length; ++i) {
                    int id = byDose.getItems()[i];
                    available += this.calc.getItemQtyFromBank(id) * (i + 1);
                }
                this.availableMap.put(firstId, available);
                qtyMap.merge(firstId, Double.valueOf(bankedQty), Double::sum);
                this.infoMap.put(firstId, byDose.getInfoItems()[0].getInfo());
            } else if (secondaries.getCustomHandler() instanceof Secondaries.Degrime) {
                Secondaries.Degrime handler = (Secondaries.Degrime)secondaries.getCustomHandler();
                qtyMap.merge(561, Double.valueOf(handler.getTotalNaturesRequired(bankedQty)), Double::sum);
                this.infoMap.put(561, new ItemInfo("Nature rune", true));
            } else if (secondaries.getCustomHandler() instanceof Secondaries.Crushable) {
                Secondaries.Crushable crushable = (Secondaries.Crushable)secondaries.getCustomHandler();
                int crushedItemId = crushable.getInfoItems()[0].getId();
                available = 0;
                for (int itemId : crushable.getItems()) {
                    available += this.calc.getItemQtyFromBank(itemId);
                }
                this.availableMap.put(crushedItemId, available);
                qtyMap.merge(crushedItemId, Double.valueOf(bankedQty), Double::sum);
                this.infoMap.put(crushedItemId, crushable.getInfoItems()[0].getInfo());
            } else if (secondaries.getCustomHandler() != null) {
                log.warn("Unhandled secondaries custom handler: {}", secondaries.getCustomHandler().getClass());
            } else {
                for (ItemStack stack : secondaries.getItems()) {
                    qtyMap.merge(stack.getId(), stack.getQty() * (double)bankedQty, Double::sum);
                    this.infoMap.put(stack.getId(), stack.getInfo());
                }
            }
            for (Map.Entry entry : qtyMap.entrySet()) {
                if (!this.availableMap.containsKey(entry.getKey())) {
                    this.availableMap.put((Integer)entry.getKey(), this.calc.getItemQtyFromBank((Integer)entry.getKey()));
                }
                this.secMap.put((Object)((Integer)entry.getKey()), (Object)new SecondaryInfo(banked, (Double)entry.getValue()));
            }
        }
        this.refreshUI();
    }

    public Multimap<Integer, SecondaryInfo> getSecMap() {
        return this.secMap;
    }

    private static final class SecondaryInfo {
        private final BankedItem bankedItem;
        private final double qty;

        public SecondaryInfo(BankedItem bankedItem, double qty) {
            this.bankedItem = bankedItem;
            this.qty = qty;
        }

        public BankedItem getBankedItem() {
            return this.bankedItem;
        }

        public double getQty() {
            return this.qty;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SecondaryInfo)) {
                return false;
            }
            SecondaryInfo other = (SecondaryInfo)o;
            BankedItem this$bankedItem = this.getBankedItem();
            BankedItem other$bankedItem = other.getBankedItem();
            if (this$bankedItem == null ? other$bankedItem != null : !((Object)this$bankedItem).equals(other$bankedItem)) {
                return false;
            }
            return Double.compare(this.getQty(), other.getQty()) == 0;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BankedItem $bankedItem = this.getBankedItem();
            result = result * 59 + ($bankedItem == null ? 43 : $bankedItem.hashCode());
            long $qty = Double.doubleToLongBits(this.getQty());
            result = result * 59 + (int)($qty >>> 32 ^ $qty);
            return result;
        }

        public String toString() {
            return "SecondaryGrid.SecondaryInfo(bankedItem=" + this.getBankedItem() + ", qty=" + this.getQty() + ")";
        }
    }
}

