/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.bankedexperience.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.components.shadowlabel.JShadowedLabel;
import net.runelite.client.util.AsyncBufferedImage;
import thestonedturtle.bankedexperience.BankedCalculator;
import thestonedturtle.bankedexperience.components.combobox.ComboBoxIconEntry;
import thestonedturtle.bankedexperience.components.combobox.ComboBoxIconListRenderer;
import thestonedturtle.bankedexperience.data.Activity;
import thestonedturtle.bankedexperience.data.BankedItem;
import thestonedturtle.bankedexperience.data.ExperienceItem;
import thestonedturtle.bankedexperience.data.ItemStack;
import thestonedturtle.bankedexperience.data.Secondaries;

public class ModifyPanel
extends JPanel {
    private static final Dimension ICON_SIZE = new Dimension(40, 32);
    private static final DecimalFormat FORMAT_COMMA = new DecimalFormat("#,###.##");
    private static final Border PANEL_BORDER = new EmptyBorder(3, 0, 3, 0);
    private static final Color BACKGROUND_COLOR = ColorScheme.DARKER_GRAY_COLOR;
    private final BankedCalculator calc;
    private final ItemManager itemManager;
    private BankedItem bankedItem;
    private Map<ExperienceItem, Integer> linkedMap;
    private int amount = 0;
    private double total = 0.0;
    private final JPanel labelContainer;
    private final JLabel image;
    private final JShadowedLabel labelName;
    private final JShadowedLabel labelValue;
    private final JPanel adjustContainer;

    public ModifyPanel(BankedCalculator calc, ItemManager itemManager) {
        this.calc = calc;
        this.itemManager = itemManager;
        this.setLayout(new GridBagLayout());
        this.setBorder(PANEL_BORDER);
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.labelContainer = new JPanel();
        this.labelContainer.setLayout(new BorderLayout());
        this.labelContainer.setBackground(BACKGROUND_COLOR);
        this.labelContainer.setBorder(new EmptyBorder(5, 0, 5, 0));
        this.image = new JLabel();
        this.image.setMinimumSize(ICON_SIZE);
        this.image.setMaximumSize(ICON_SIZE);
        this.image.setPreferredSize(ICON_SIZE);
        this.image.setHorizontalAlignment(0);
        this.image.setBorder(new EmptyBorder(0, 8, 0, 0));
        JPanel uiInfo = new JPanel(new GridLayout(2, 1));
        uiInfo.setBorder(new EmptyBorder(0, 5, 0, 0));
        uiInfo.setBackground(BACKGROUND_COLOR);
        this.labelName = new JShadowedLabel();
        this.labelName.setForeground(Color.WHITE);
        this.labelName.setVerticalAlignment(3);
        this.labelValue = new JShadowedLabel();
        this.labelValue.setFont(FontManager.getRunescapeSmallFont());
        this.labelValue.setVerticalAlignment(1);
        uiInfo.add((Component)this.labelName);
        uiInfo.add((Component)this.labelValue);
        this.labelContainer.add((Component)this.image, "Before");
        this.labelContainer.add((Component)uiInfo, "Center");
        this.adjustContainer = new JPanel();
        this.adjustContainer.setLayout(new GridBagLayout());
        this.adjustContainer.setBackground(BACKGROUND_COLOR);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.ipady = 0;
        this.add((Component)this.labelContainer, c);
        ++c.gridy;
        this.add((Component)this.adjustContainer, c);
    }

    public void setBankedItem(BankedItem bankedItem) {
        if (bankedItem == null) {
            return;
        }
        this.bankedItem = bankedItem;
        this.amount = this.calc.getItemQty(bankedItem);
        this.linkedMap = this.calc.getConfig().cascadeBankedXp() ? this.calc.createLinksMap(bankedItem) : new HashMap();
        this.updateImageTooltip();
        this.updateLabelContainer();
        this.updateAdjustContainer();
    }

    private void updateImageTooltip() {
        StringBuilder b = new StringBuilder("<html>");
        b.append(this.bankedItem.getQty()).append(" x ").append(this.bankedItem.getItem().getItemInfo().getName());
        for (Map.Entry<ExperienceItem, Integer> e : this.linkedMap.entrySet()) {
            b.append("<br/>").append(e.getValue()).append(" x ").append(e.getKey().getItemInfo().getName());
            ItemStack output = e.getKey().getSelectedActivity().getOutput();
            if (output == null || !(output.getQty() > 1.0)) continue;
            b.append(" x ").append(output.getQty());
        }
        b.append("</html>");
        this.image.setToolTipText(b.toString());
    }

    private void updateLabelContainer() {
        ExperienceItem item = this.bankedItem.getItem();
        boolean stackable = item.getItemInfo().isStackable() || this.amount > 1;
        AsyncBufferedImage icon = this.itemManager.getImage(item.getItemID(), this.amount, stackable);
        Runnable resize = () -> this.image.setIcon(new ImageIcon(icon.getScaledInstance(36, ModifyPanel.ICON_SIZE.height, 4)));
        icon.onLoaded(resize);
        resize.run();
        String itemName = item.getItemInfo().getName();
        this.labelName.setText(itemName);
        double xp = this.calc.getItemXpRate(this.bankedItem);
        this.total = BigDecimal.valueOf((double)this.amount * xp).setScale(2, RoundingMode.HALF_UP).doubleValue();
        String value = FORMAT_COMMA.format(this.total) + "xp";
        this.labelValue.setText(value);
        this.labelContainer.setToolTipText("<html>" + itemName + "<br/>xp: " + xp + "<br/>Total: " + this.total + "</html");
        this.labelContainer.revalidate();
        this.labelContainer.repaint();
    }

    private void updateAdjustContainer() {
        Secondaries secondaries;
        Activity a;
        this.adjustContainer.removeAll();
        JLabel label = new JLabel("Activity:");
        label.setVerticalAlignment(0);
        label.setHorizontalAlignment(0);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.ipady = 4;
        this.adjustContainer.add((Component)label, c);
        ++c.gridy;
        int level = this.calc.getConfig().limitToCurrentLevel() ? this.calc.getSkillLevel() + this.calc.getBoostInput().getInputValue() : -1;
        List<Activity> activities = Activity.getByExperienceItem(this.bankedItem.getItem(), level);
        if (activities == null || activities.size() == 0) {
            JLabel unusable = new JLabel("Unusable at current level");
            unusable.setVerticalAlignment(0);
            unusable.setHorizontalAlignment(0);
            this.adjustContainer.removeAll();
            this.adjustContainer.add((Component)unusable, c);
            return;
        }
        if (activities.size() == 1) {
            int qty;
            a = activities.get(0);
            int n = qty = a.getOutput() == null ? 1 : (int)a.getOutput().getQty();
            boolean stackable = a.getOutputItemInfo() == null ? qty > 1 : a.getOutputItemInfo().isStackable();
            AsyncBufferedImage img = this.itemManager.getImage(a.getIcon(), qty, stackable);
            ImageIcon icon = new ImageIcon((Image)img);
            double xp = a.getXpRate(this.calc.getEnabledModifiers());
            JPanel container = this.createShadowedLabel(icon, a.getName(), FORMAT_COMMA.format(xp) + "xp");
            img.onLoaded(() -> {
                icon.setImage((Image)img);
                container.repaint();
            });
            this.adjustContainer.add((Component)container, c);
            ++c.gridy;
        } else {
            JComboBox<ComboBoxIconEntry> dropdown = new JComboBox<ComboBoxIconEntry>();
            dropdown.setPreferredSize(new Dimension(200, 40));
            dropdown.setFocusable(false);
            dropdown.setForeground(Color.WHITE);
            dropdown.setBorder(new EmptyBorder(2, 0, 0, 0));
            ComboBoxIconListRenderer renderer = new ComboBoxIconListRenderer();
            dropdown.setRenderer(renderer);
            for (Activity option : activities) {
                double xp = option.getXpRate(this.calc.getEnabledModifiers());
                Object name = option.getName();
                if (xp > 0.0) {
                    name = (String)name + " (" + FORMAT_COMMA.format(xp) + "xp)";
                }
                AsyncBufferedImage img = this.itemManager.getImage(option.getIcon());
                ImageIcon icon = new ImageIcon((Image)img);
                ComboBoxIconEntry entry = new ComboBoxIconEntry(icon, (String)name, (Object)option);
                dropdown.addItem(entry);
                img.onLoaded(() -> {
                    icon.setImage((Image)img);
                    dropdown.revalidate();
                    dropdown.repaint();
                });
                Activity selected = this.bankedItem.getItem().getSelectedActivity();
                if (!option.equals((Object)selected)) continue;
                dropdown.setSelectedItem(entry);
            }
            dropdown.addItemListener(e -> {
                ComboBoxIconEntry source;
                if (e.getStateChange() == 1 && e.getItem() instanceof ComboBoxIconEntry && (source = (ComboBoxIconEntry)e.getItem()).getData() instanceof Activity) {
                    Activity selectedActivity = (Activity)((Object)((Object)source.getData()));
                    this.calc.activitySelected(this.bankedItem, selectedActivity);
                    this.updateLabelContainer();
                }
            });
            this.adjustContainer.add(dropdown, c);
            ++c.gridy;
        }
        a = this.bankedItem.getItem().getSelectedActivity();
        if (a == null) {
            return;
        }
        if (a.getOutput() != null && a.getOutput().getQty() != 1.0) {
            JLabel secondaryLabel = new JLabel("Outputs:");
            secondaryLabel.setVerticalAlignment(0);
            secondaryLabel.setHorizontalAlignment(0);
            this.adjustContainer.add((Component)secondaryLabel, c);
            ++c.gridy;
            double qty = (double)this.amount * a.getOutput().getQty();
            boolean stackable = qty > 1.0 || a.getOutputItemInfo() != null && a.getOutputItemInfo().isStackable();
            AsyncBufferedImage img = this.itemManager.getImage(a.getIcon(), (int)qty, stackable);
            ImageIcon icon = new ImageIcon((Image)img);
            JLabel iconLabel = this.createImageLabel(icon);
            iconLabel.setToolTipText(FORMAT_COMMA.format((int)qty) + " x " + a.getOutputItemInfo().getName());
            JPanel container = this.createShadowedLabel(iconLabel, a.getOutputItemInfo().getName(), null);
            img.onLoaded(() -> {
                icon.setImage((Image)img);
                container.repaint();
            });
            this.adjustContainer.add((Component)container, c);
            ++c.gridy;
        }
        if ((secondaries = a.getSecondaries()) != null && this.calc.getConfig().showSecondaries()) {
            int available;
            JLabel secondaryLabel = new JLabel("Secondaries:");
            secondaryLabel.setVerticalAlignment(0);
            secondaryLabel.setHorizontalAlignment(0);
            this.adjustContainer.add((Component)secondaryLabel, c);
            ++c.gridy;
            JPanel container = new JPanel();
            container.setLayout(new GridLayout(1, 6, 1, 1));
            container.setBackground(BACKGROUND_COLOR);
            for (ItemStack s : secondaries.getItems()) {
                int required = (int)(s.getQty() * (double)this.amount);
                int available2 = this.calc.getItemQtyFromBank(s.getId());
                container.add(this.createSecondaryItemLabel(s, available2, required));
            }
            if (secondaries.getCustomHandler() instanceof Secondaries.ByDose) {
                Secondaries.ByDose byDose = (Secondaries.ByDose)secondaries.getCustomHandler();
                int required = this.amount;
                int available3 = 0;
                for (int i = 0; i < byDose.getItems().length; ++i) {
                    int id = byDose.getItems()[i];
                    available3 += this.calc.getItemQtyFromBank(id) * (i + 1);
                }
                assert (byDose.getInfoItems().length > 0);
                container.add(this.createSecondaryItemLabel(byDose.getInfoItems()[0], available3, required));
            }
            if (secondaries.getCustomHandler() instanceof Secondaries.Degrime) {
                Secondaries.Degrime handler = (Secondaries.Degrime)secondaries.getCustomHandler();
                available = this.calc.getItemQtyFromBank(561);
                int required = handler.getTotalNaturesRequired(this.amount);
                container.add(this.createSecondaryItemLabel(new ItemStack(561, 0.0), available, required));
            }
            if (secondaries.getCustomHandler() instanceof Secondaries.Crushable) {
                Secondaries.Crushable crushable = (Secondaries.Crushable)secondaries.getCustomHandler();
                available = 0;
                for (int itemId : crushable.getItems()) {
                    available += this.calc.getItemQtyFromBank(itemId);
                }
                container.add(this.createSecondaryItemLabel(crushable.getInfoItems()[0], available, this.amount));
            }
            this.adjustContainer.add((Component)container, c);
            ++c.gridy;
        }
    }

    private JLabel createSecondaryItemLabel(ItemStack stack, int available, int required) {
        JLabel l = new JLabel();
        AsyncBufferedImage img = this.itemManager.getImage(stack.getId(), required, required > 1);
        ImageIcon icon = new ImageIcon((Image)img);
        img.onLoaded(() -> {
            icon.setImage((Image)img);
            l.repaint();
        });
        l.setIcon(icon);
        l.setHorizontalAlignment(0);
        int result = available - required;
        String itemName = stack.getInfo() == null ? "" : stack.getInfo().getName();
        String tooltip = "<html>" + itemName + "<br/>Banked: " + FORMAT_COMMA.format(available) + "<br/>Needed: " + FORMAT_COMMA.format(required) + "<br/>Result: " + (result > 0 ? "+" : "") + FORMAT_COMMA.format(result) + "</html>";
        l.setToolTipText(tooltip);
        return l;
    }

    private JLabel createImageLabel(ImageIcon icon) {
        JLabel image = new JLabel();
        image.setMinimumSize(ICON_SIZE);
        image.setMaximumSize(ICON_SIZE);
        image.setPreferredSize(ICON_SIZE);
        image.setHorizontalAlignment(0);
        image.setBorder(new EmptyBorder(0, 8, 0, 0));
        image.setIcon(icon);
        return image;
    }

    private JPanel createShadowedLabel(ImageIcon icon, String name, String value) {
        JLabel imageLabel = this.createImageLabel(icon);
        return this.createShadowedLabel(imageLabel, name, value);
    }

    private JPanel createShadowedLabel(JLabel icon, String name, String value) {
        JPanel wrapper = new JPanel(new GridLayout(value == null ? 1 : 2, 1));
        wrapper.setBorder(new EmptyBorder(0, 5, 0, 0));
        wrapper.setBackground(BACKGROUND_COLOR);
        JShadowedLabel nameLabel = new JShadowedLabel(name);
        nameLabel.setForeground(Color.WHITE);
        wrapper.add((Component)nameLabel);
        if (value != null) {
            nameLabel.setVerticalAlignment(3);
            JShadowedLabel valueLabel = new JShadowedLabel(value);
            valueLabel.setFont(FontManager.getRunescapeSmallFont());
            valueLabel.setVerticalAlignment(1);
            wrapper.add((Component)valueLabel);
        }
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        container.setBackground(BACKGROUND_COLOR);
        container.setBorder(new EmptyBorder(5, 0, 5, 0));
        container.add((Component)icon, "Before");
        container.add((Component)wrapper, "Center");
        return container;
    }

    public BankedItem getBankedItem() {
        return this.bankedItem;
    }

    public int getAmount() {
        return this.amount;
    }

    public double getTotal() {
        return this.total;
    }
}

