/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.bankedexperience.components;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.AsyncBufferedImage;
import thestonedturtle.bankedexperience.BankedCalculator;
import thestonedturtle.bankedexperience.components.SelectionListener;
import thestonedturtle.bankedexperience.data.Activity;
import thestonedturtle.bankedexperience.data.BankedItem;
import thestonedturtle.bankedexperience.data.modifiers.Modifier;

public class GridItem
extends JLabel {
    private static final String IGNORE = "Ignore Item";
    private static final String IGNORE_ALL = "Ignore All Items";
    private static final String INCLUDE = "Include Item";
    private static final String INCLUDE_ALL = "Include All Items";
    private static final Color UNSELECTED_BACKGROUND = ColorScheme.DARKER_GRAY_COLOR;
    private static final Color UNSELECTED_HOVER_BACKGROUND = ColorScheme.DARKER_GRAY_HOVER_COLOR;
    public static final Color SELECTED_BACKGROUND = new Color(0, 70, 0);
    private static final Color SELECTED_HOVER_BACKGROUND = new Color(0, 100, 0);
    public static final Color IGNORED_BACKGROUND = new Color(90, 0, 0);
    private static final Color IGNORED_HOVER_BACKGROUND = new Color(120, 0, 0);
    private static final Color RNG_BACKGROUND = new Color(140, 90, 0);
    private static final Color RNG_HOVER_BACKGROUND = new Color(186, 120, 0);
    private SelectionListener selectionListener;
    private final BankedItem bankedItem;
    private int amount;
    private boolean selected = false;
    private boolean ignored;
    private boolean rng;
    private final JMenuItem IGNORE_OPTION = new JMenuItem("Ignore Item");
    private final JMenuItem IGNORE_ALL_OPTION = new JMenuItem("Ignore All Items");
    private final JMenuItem INCLUDE_ALL_OPTION = new JMenuItem("Include All Items");

    GridItem(final BankedItem item, AsyncBufferedImage icon, int amount, Collection<Modifier> modifiers, boolean ignore, Consumer<Boolean> bulkIgnoreCallback) {
        super("");
        this.setIgnore(ignore);
        this.bankedItem = item;
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(5, 0, 2, 0));
        this.setVerticalAlignment(0);
        this.setHorizontalAlignment(0);
        this.updateIcon(icon, amount);
        this.updateToolTip(modifiers);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    if (GridItem.this.selectionListener != null && !GridItem.this.selectionListener.selected(item)) {
                        return;
                    }
                    GridItem.this.select();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                GridItem item2 = (GridItem)e.getSource();
                item2.setBackground(GridItem.this.getHoverBackgroundColor());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                GridItem item2 = (GridItem)e.getSource();
                item2.setBackground(GridItem.this.getBackgroundColor());
            }
        });
        this.IGNORE_OPTION.addActionListener(e -> {
            boolean bl = this.ignored = !this.ignored;
            if (this.selectionListener != null && !this.selectionListener.ignored(item)) {
                this.ignored = !this.ignored;
                return;
            }
            this.setIgnore(this.ignored);
        });
        this.IGNORE_ALL_OPTION.addActionListener(e -> bulkIgnoreCallback.accept(true));
        this.INCLUDE_ALL_OPTION.addActionListener(e -> bulkIgnoreCallback.accept(false));
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
        popupMenu.add(this.IGNORE_OPTION);
        popupMenu.add(this.INCLUDE_ALL_OPTION);
        popupMenu.add(this.IGNORE_ALL_OPTION);
        this.setComponentPopupMenu(popupMenu);
    }

    private Color getBackgroundColor() {
        return this.ignored ? IGNORED_BACKGROUND : (this.rng ? RNG_BACKGROUND : (this.selected ? SELECTED_BACKGROUND : UNSELECTED_BACKGROUND));
    }

    private Color getHoverBackgroundColor() {
        return this.ignored ? IGNORED_HOVER_BACKGROUND : (this.rng ? RNG_HOVER_BACKGROUND : (this.selected ? SELECTED_HOVER_BACKGROUND : UNSELECTED_HOVER_BACKGROUND));
    }

    void select() {
        this.selected = true;
        this.setBackground(this.getBackgroundColor());
    }

    void unselect() {
        this.selected = false;
        this.setBackground(this.getBackgroundColor());
    }

    public void updateIcon(AsyncBufferedImage icon, int amount) {
        icon.addTo((JLabel)this);
        this.amount = amount;
    }

    public void updateToolTip(Collection<Modifier> modifiers) {
        this.setToolTipText(this.buildToolTip(modifiers));
        Activity selectedActivity = this.bankedItem.getItem().getSelectedActivity();
        if (selectedActivity != null) {
            this.rng = selectedActivity.isRngActivity();
            this.setBackground(this.getBackgroundColor());
        }
    }

    private String buildToolTip(Collection<Modifier> modifiers) {
        String tip = "<html>" + this.bankedItem.getItem().getItemInfo().getName();
        Activity a = this.bankedItem.getItem().getSelectedActivity();
        if (a != null) {
            double xp = a.getXpRate(modifiers);
            tip = tip + "<br/>Activity: " + a.getName();
            tip = tip + "<br/>Xp/Action: " + BankedCalculator.XP_FORMAT_COMMA.format(xp);
            tip = tip + "<br/>Total Xp: " + BankedCalculator.XP_FORMAT_COMMA.format(xp * (double)this.amount);
        } else {
            tip = tip + "<br/>Unusable at current level";
        }
        return tip + "</html>";
    }

    public void setIgnore(Boolean ignored) {
        this.ignored = ignored;
        this.IGNORE_OPTION.setText(ignored != false ? INCLUDE : IGNORE);
        this.setBackground(this.getBackgroundColor());
    }

    public SelectionListener getSelectionListener() {
        return this.selectionListener;
    }

    public BankedItem getBankedItem() {
        return this.bankedItem;
    }

    public int getAmount() {
        return this.amount;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public boolean isRng() {
        return this.rng;
    }

    public JMenuItem getIGNORE_OPTION() {
        return this.IGNORE_OPTION;
    }

    public JMenuItem getIGNORE_ALL_OPTION() {
        return this.IGNORE_ALL_OPTION;
    }

    public JMenuItem getINCLUDE_ALL_OPTION() {
        return this.INCLUDE_ALL_OPTION;
    }

    public void setSelectionListener(SelectionListener selectionListener) {
        this.selectionListener = selectionListener;
    }
}

