/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.bankedexperience.components;

import com.google.common.collect.ImmutableList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import net.runelite.client.plugins.config.ConfigPlugin;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.SwingUtil;

public class ExpandableSection
extends JPanel {
    private static final ImageIcon SECTION_EXPAND_ICON;
    private static final ImageIcon SECTION_EXPAND_ICON_HOVER;
    private static final ImageIcon SECTION_RETRACT_ICON;
    private static final ImageIcon SECTION_RETRACT_ICON_HOVER;
    private final JButton sectionToggle;
    private final JPanel sectionContents;
    private boolean isOpen = true;

    public ExpandableSection(String header, String description, JComponent ... components) {
        this(header, description, (Collection<JComponent>)ImmutableList.copyOf((Object[])components));
    }

    public ExpandableSection(String header, String description, Collection<JComponent> components) {
        this.setLayout(new BoxLayout(this, 1));
        this.setMinimumSize(new Dimension(225, 0));
        JPanel sectionHeader = new JPanel();
        sectionHeader.setLayout(new BorderLayout());
        sectionHeader.setMinimumSize(new Dimension(225, 0));
        sectionHeader.setBorder(new CompoundBorder(new MatteBorder(0, 0, 1, 0, ColorScheme.MEDIUM_GRAY_COLOR), new EmptyBorder(0, 0, 3, 1)));
        this.add((Component)sectionHeader, "North");
        this.sectionToggle = new JButton();
        this.sectionToggle.setIcon(this.isOpen ? SECTION_RETRACT_ICON : SECTION_EXPAND_ICON);
        this.sectionToggle.setRolloverIcon(this.isOpen ? SECTION_RETRACT_ICON_HOVER : SECTION_EXPAND_ICON_HOVER);
        this.sectionToggle.setPreferredSize(new Dimension(18, 0));
        this.sectionToggle.setBorder(new EmptyBorder(0, 0, 0, 5));
        this.sectionToggle.setToolTipText(this.isOpen ? "Retract" : "Expand");
        SwingUtil.removeButtonDecorations((AbstractButton)this.sectionToggle);
        sectionHeader.add((Component)this.sectionToggle, "West");
        JLabel sectionName = new JLabel(header);
        sectionName.setForeground(ColorScheme.BRAND_ORANGE);
        sectionName.setFont(FontManager.getRunescapeBoldFont());
        if (description != null) {
            sectionName.setToolTipText("<html>" + header + ":<br>" + description + "</html>");
        }
        sectionHeader.add((Component)sectionName, "Center");
        this.sectionContents = new JPanel();
        this.sectionContents.setLayout((LayoutManager)new DynamicGridLayout(0, 1, 0, 5));
        this.sectionContents.setMinimumSize(new Dimension(225, 0));
        this.sectionContents.setBorder(new CompoundBorder(new MatteBorder(0, 0, 1, 0, ColorScheme.MEDIUM_GRAY_COLOR), new EmptyBorder(6, 0, 6, 0)));
        this.sectionContents.setVisible(this.isOpen);
        for (JComponent c : components) {
            this.sectionContents.add(c);
        }
        this.add((Component)this.sectionContents, "South");
        MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ExpandableSection.this.toggle();
            }
        };
        this.sectionToggle.addActionListener(actionEvent -> this.toggle());
        sectionName.addMouseListener(adapter);
        sectionHeader.addMouseListener(adapter);
    }

    private void toggle() {
        this.isOpen = !this.isOpen;
        this.sectionToggle.setIcon(this.isOpen ? SECTION_RETRACT_ICON : SECTION_EXPAND_ICON);
        this.sectionToggle.setRolloverIcon(this.isOpen ? SECTION_RETRACT_ICON_HOVER : SECTION_EXPAND_ICON_HOVER);
        this.sectionToggle.setToolTipText(this.isOpen ? "Retract" : "Expand");
        this.sectionContents.setVisible(this.isOpen);
    }

    public void setOpen(boolean open) {
        if (this.isOpen == open) {
            return;
        }
        this.toggle();
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    static {
        BufferedImage sectionRetractIcon = ImageUtil.loadImageResource(ConfigPlugin.class, (String)"/util/arrow_right.png");
        sectionRetractIcon = ImageUtil.luminanceOffset((Image)sectionRetractIcon, (int)-121);
        SECTION_EXPAND_ICON = new ImageIcon(sectionRetractIcon);
        SECTION_EXPAND_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset((Image)sectionRetractIcon, (int)-100));
        BufferedImage sectionExpandIcon = ImageUtil.rotateImage((BufferedImage)sectionRetractIcon, (double)1.5707963267948966);
        SECTION_RETRACT_ICON = new ImageIcon(sectionExpandIcon);
        SECTION_RETRACT_ICON_HOVER = new ImageIcon(ImageUtil.alphaOffset((Image)sectionExpandIcon, (int)-100));
    }
}

