/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.bankedexperience;

import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.AccountHashChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thestonedturtle.bankedexperience.BankedCalculatorPanel;
import thestonedturtle.bankedexperience.BankedExperienceConfig;
import thestonedturtle.bankedexperience.data.Activity;
import thestonedturtle.bankedexperience.data.ExperienceItem;
import thestonedturtle.bankedexperience.data.WidgetInventoryInfo;
import thestonedturtle.bankedexperience.data.modifiers.Modifiers;

@PluginDescriptor(name="Banked Experience")
public class BankedExperiencePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(BankedExperiencePlugin.class);
    private static final BufferedImage ICON = ImageUtil.loadImageResource(BankedExperiencePlugin.class, (String)"banked.png");
    private static final Map<Integer, Integer> EMPTY_MAP = new HashMap<Integer, Integer>();
    public static final String CONFIG_GROUP = "bankedexperience";
    private static final String VAULT_CONFIG_KEY = "grabFromSeedVault";
    private static final String INVENTORY_CONFIG_KEY = "grabFromInventory";
    private static final String LOOTING_BAG_CONFIG_KEY = "grabFromLootingBag";
    private static final String FOSSIL_CHEST_CONFIG_KEY = "grabFromFossilChest";
    public static final String ACTIVITY_CONFIG_KEY = "ITEM_";
    private static final int LOOTING_BAG_ID = 516;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private SkillIconManager skillIconManager;
    @Inject
    private BankedExperienceConfig config;
    private final Map<Integer, Integer> inventoryHashMap = new HashMap<Integer, Integer>();
    private NavigationButton navButton;
    private BankedCalculatorPanel panel;
    private boolean prepared = false;
    private long accountHash = -1L;

    @Provides
    BankedExperienceConfig provideConfig(ConfigManager configManager) {
        return (BankedExperienceConfig)configManager.getConfig(BankedExperienceConfig.class);
    }

    protected void startUp() throws Exception {
        this.panel = new BankedCalculatorPanel(this.client, this.config, this.skillIconManager, this.itemManager, this.configManager);
        this.navButton = NavigationButton.builder().tooltip("Banked XP").icon(ICON).priority(6).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
        this.accountHash = this.client.getAccountHash();
        if (!this.prepared) {
            this.clientThread.invoke(() -> {
                switch (this.client.getGameState()) {
                    case LOGIN_SCREEN: 
                    case LOGIN_SCREEN_AUTHENTICATOR: 
                    case LOGGING_IN: 
                    case LOADING: 
                    case LOGGED_IN: 
                    case CONNECTION_LOST: 
                    case HOPPING: {
                        ExperienceItem.prepareItemCompositions(this.itemManager);
                        Activity.prepareItemCompositions(this.itemManager);
                        Modifiers.prepare(this.itemManager);
                        this.loadSavedActivities();
                        this.prepared = true;
                        return true;
                    }
                }
                return false;
            });
        }
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.navButton);
        this.panel = null;
        this.navButton = null;
        this.inventoryHashMap.clear();
        this.accountHash = -1L;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        int inventoryId;
        if (!event.getGroup().equals(CONFIG_GROUP)) {
            return;
        }
        switch (event.getKey()) {
            case "grabFromSeedVault": {
                inventoryId = InventoryID.SEED_VAULT.getId();
                break;
            }
            case "grabFromInventory": {
                inventoryId = InventoryID.INVENTORY.getId();
                break;
            }
            case "grabFromLootingBag": {
                inventoryId = 516;
                break;
            }
            case "grabFromFossilChest": {
                inventoryId = WidgetInventoryInfo.FOSSIL_CHEST.getId();
                break;
            }
            default: {
                return;
            }
        }
        SwingUtilities.invokeLater(() -> this.panel.setInventoryMap(inventoryId, EMPTY_MAP));
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged ev) {
        if (ev.getContainerId() == InventoryID.BANK.getId() || ev.getContainerId() == InventoryID.SEED_VAULT.getId() && this.config.grabFromSeedVault() || ev.getContainerId() == InventoryID.INVENTORY.getId() && this.config.grabFromInventory() || ev.getContainerId() == 516 && this.config.grabFromLootingBag()) {
            this.updateItemsFromItemContainer(ev.getContainerId(), ev.getItemContainer());
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded e) {
        if (!this.config.grabFromFossilChest()) {
            return;
        }
        WidgetInventoryInfo widgetInfo = WidgetInventoryInfo.getByGroupId(e.getGroupId());
        if (widgetInfo == null) {
            return;
        }
        Widget w = this.client.getWidget(widgetInfo.getGroupId(), widgetInfo.getChildId());
        if (w == null || w.getChildren() == null) {
            return;
        }
        HashMap<Integer, Integer> m = new HashMap<Integer, Integer>();
        for (int i = 0; i < w.getChildren().length; ++i) {
            Widget childWidget = w.getChild(i);
            if (childWidget.getItemId() <= 0 || childWidget.getItemQuantity() <= 0) continue;
            m.merge(childWidget.getItemId(), childWidget.getItemQuantity(), Integer::sum);
        }
        this.updateInventoryMap(widgetInfo.getId(), m);
    }

    @Subscribe
    public void onAccountHashChanged(AccountHashChanged e) {
        if (this.accountHash == this.client.getAccountHash()) {
            return;
        }
        this.accountHash = this.client.getAccountHash();
        this.inventoryHashMap.clear();
        SwingUtilities.invokeLater(this.panel::resetInventoryMaps);
    }

    private void updateItemsFromItemContainer(int inventoryId, ItemContainer c) {
        if (c == null) {
            return;
        }
        HashMap<Integer, Integer> m = new HashMap<Integer, Integer>();
        for (Item item : c.getItems()) {
            int itemID;
            ItemComposition itemComposition;
            if (item.getId() == -1 || (itemComposition = this.itemManager.getItemComposition(itemID = item.getId())).getPlaceholderTemplateId() != -1) continue;
            if (itemComposition.getNote() != -1) {
                itemID = itemComposition.getLinkedNoteId();
            }
            int qty = m.getOrDefault(itemID, 0) + item.getQuantity();
            m.put(itemID, qty);
        }
        this.updateInventoryMap(inventoryId, m);
    }

    private void updateInventoryMap(int inventoryId, Map<Integer, Integer> m) {
        int curHash = m.hashCode();
        if (curHash != this.inventoryHashMap.getOrDefault(inventoryId, -1)) {
            this.inventoryHashMap.put(inventoryId, curHash);
            SwingUtilities.invokeLater(() -> this.panel.setInventoryMap(inventoryId, m));
        }
    }

    private void loadSavedActivities() {
        block0: for (ExperienceItem item : ExperienceItem.values()) {
            String activityName = this.configManager.getConfiguration(CONFIG_GROUP, ACTIVITY_CONFIG_KEY + item.name());
            if (activityName == null || activityName.equals("")) continue;
            for (Activity activity : Activity.values()) {
                if (!activityName.equals(activity.name())) continue;
                item.setSelectedActivity(activity);
                continue block0;
            }
        }
    }
}

