/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.bankedexperience;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Client;
import net.runelite.api.Skill;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thestonedturtle.bankedexperience.BankedCalculator;
import thestonedturtle.bankedexperience.BankedExperienceConfig;
import thestonedturtle.bankedexperience.components.combobox.ComboBoxIconEntry;
import thestonedturtle.bankedexperience.components.combobox.ComboBoxIconListRenderer;
import thestonedturtle.bankedexperience.components.textinput.UICalculatorInputArea;
import thestonedturtle.bankedexperience.data.Activity;

public class BankedCalculatorPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(BankedCalculatorPanel.class);
    private final BankedCalculator calculator;

    public BankedCalculatorPanel(Client client, BankedExperienceConfig config, SkillIconManager skillIconManager, ItemManager itemManager, ConfigManager configManager) {
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setLayout(new GridBagLayout());
        UICalculatorInputArea inputs = new UICalculatorInputArea();
        inputs.setBorder(new EmptyBorder(15, 0, 15, 0));
        inputs.setBackground(ColorScheme.DARK_GRAY_COLOR);
        inputs.getUiFieldTargetXP().setEditable(false);
        inputs.getUiFieldTargetLevel().setEditable(false);
        this.calculator = new BankedCalculator(inputs, client, config, itemManager, configManager);
        JComboBox<ComboBoxIconEntry> dropdown = new JComboBox<ComboBoxIconEntry>();
        dropdown.setFocusable(false);
        dropdown.setForeground(Color.WHITE);
        dropdown.setMaximumRowCount(Activity.BANKABLE_SKILLS.size());
        ComboBoxIconListRenderer renderer = new ComboBoxIconListRenderer();
        renderer.setDefaultText("Select a Skill...");
        dropdown.setRenderer(renderer);
        for (Skill skill : Activity.BANKABLE_SKILLS) {
            BufferedImage img = skillIconManager.getSkillImage(skill, true);
            ComboBoxIconEntry entry = new ComboBoxIconEntry(new ImageIcon(img), skill.getName(), skill);
            dropdown.addItem(entry);
        }
        dropdown.addItemListener(e -> {
            ComboBoxIconEntry source;
            if (e.getStateChange() == 1 && (source = (ComboBoxIconEntry)e.getItem()).getData() instanceof Skill) {
                Skill skill = (Skill)source.getData();
                this.calculator.open(skill);
            }
        });
        dropdown.setSelectedIndex(-1);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.add(dropdown, c);
        ++c.gridy;
        this.add(inputs, c);
        ++c.gridy;
        this.add(this.calculator, c);
    }

    void setInventoryMap(int inventoryId, Map<Integer, Integer> map) {
        this.calculator.setInventoryMap(inventoryId, map);
    }

    void resetInventoryMaps() {
        this.calculator.resetInventoryMaps();
    }
}

