/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.bankedexperience;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.api.Client;
import net.runelite.api.Experience;
import net.runelite.api.Skill;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thestonedturtle.bankedexperience.BankedExperienceConfig;
import thestonedturtle.bankedexperience.components.ExpandableSection;
import thestonedturtle.bankedexperience.components.GridItem;
import thestonedturtle.bankedexperience.components.ModifyPanel;
import thestonedturtle.bankedexperience.components.SecondaryGrid;
import thestonedturtle.bankedexperience.components.SelectionGrid;
import thestonedturtle.bankedexperience.components.SelectionListener;
import thestonedturtle.bankedexperience.components.textinput.BoostInput;
import thestonedturtle.bankedexperience.components.textinput.UICalculatorInputArea;
import thestonedturtle.bankedexperience.data.Activity;
import thestonedturtle.bankedexperience.data.BankedItem;
import thestonedturtle.bankedexperience.data.ExperienceItem;
import thestonedturtle.bankedexperience.data.ItemStack;
import thestonedturtle.bankedexperience.data.modifiers.Modifier;
import thestonedturtle.bankedexperience.data.modifiers.ModifierComponent;
import thestonedturtle.bankedexperience.data.modifiers.Modifiers;

public class BankedCalculator
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(BankedCalculator.class);
    public static final DecimalFormat XP_FORMAT_COMMA = new DecimalFormat("#,###.#");
    private final Client client;
    private final BankedExperienceConfig config;
    private final UICalculatorInputArea uiInput;
    private final ItemManager itemManager;
    private final ConfigManager configManager;
    private final Multimap<ExperienceItem, BankedItem> linkedMap = ArrayListMultimap.create();
    private final Map<ExperienceItem, BankedItem> bankedItemMap = new LinkedHashMap<ExperienceItem, BankedItem>();
    private final JLabel totalXpLabel = new JLabel();
    private final JLabel xpToNextLevelLabel = new JLabel();
    private final ModifyPanel modifyPanel;
    private SelectionGrid itemGrid = new SelectionGrid();
    private SecondaryGrid secondaryGrid;
    private ExpandableSection modifierSection;
    private ExpandableSection secondarySection;
    private final JButton refreshBtn;
    private final Map<Integer, Integer> currentMap = new HashMap<Integer, Integer>();
    private final Map<Integer, Map<Integer, Integer>> inventoryMap = new HashMap<Integer, Map<Integer, Integer>>();
    private final Set<Modifier> enabledModifiers = new HashSet<Modifier>();
    private final List<ModifierComponent> modifierComponents = new ArrayList<ModifierComponent>();
    private final Set<String> ignoredItems;
    private Skill currentSkill;
    private int skillLevel;
    private int skillExp;
    private int endLevel;
    private int endExp;
    private final BoostInput boostInput = new BoostInput(this::updateBoost);

    BankedCalculator(UICalculatorInputArea uiInput, Client client, final BankedExperienceConfig config, ItemManager itemManager, ConfigManager configManager) {
        this.uiInput = uiInput;
        this.client = client;
        this.config = config;
        this.itemManager = itemManager;
        this.configManager = configManager;
        this.ignoredItems = new HashSet<String>(Text.fromCSV((String)config.ignoredItems()));
        this.setLayout((LayoutManager)new DynamicGridLayout(0, 1, 0, 5));
        this.modifyPanel = new ModifyPanel(this, itemManager);
        this.refreshBtn = new JButton("Refresh Calculator");
        this.refreshBtn.setFocusable(false);
        this.refreshBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    BankedCalculator.this.open(BankedCalculator.this.currentSkill, true);
                }
            }
        });
        this.itemGrid.setSelectionListener(new SelectionListener(){

            @Override
            public boolean selected(BankedItem item) {
                BankedCalculator.this.modifyPanel.setBankedItem(item);
                return true;
            }

            @Override
            public boolean ignored(BankedItem item) {
                BankedCalculator.this.toggleIgnoreBankedItem(item);
                config.ignoredItems(Text.toCSV(BankedCalculator.this.ignoredItems));
                BankedCalculator.this.calculateBankedXpTotal();
                return true;
            }
        });
    }

    void open(Skill newSkill) {
        this.open(newSkill, false);
    }

    void open(Skill newSkill, boolean refresh) {
        if (!refresh && newSkill.equals((Object)this.currentSkill)) {
            return;
        }
        if (!newSkill.equals((Object)this.currentSkill)) {
            this.boostInput.setInputValue(0);
            this.itemGrid.setSelectedItem(null);
        }
        this.currentSkill = newSkill;
        this.removeAll();
        this.modifierComponents.clear();
        this.enabledModifiers.clear();
        this.refreshBtn.setVisible(false);
        this.secondaryGrid = null;
        if (this.currentMap.size() <= 0) {
            this.add(new JLabel("Please visit a bank!", 0));
            this.add(this.refreshBtn);
            this.revalidate();
            this.repaint();
            return;
        }
        this.skillLevel = this.client.getRealSkillLevel(this.currentSkill);
        this.skillExp = this.client.getSkillExperience(this.currentSkill);
        this.endLevel = this.skillLevel;
        this.endExp = this.skillExp;
        this.uiInput.setCurrentLevelInput(this.skillLevel);
        this.uiInput.setCurrentXPInput(this.skillExp);
        this.uiInput.setTargetLevelInput(this.endLevel);
        this.uiInput.setTargetXPInput(this.endExp);
        this.recreateBankedItemMap();
        for (Modifier modifier : Modifiers.getBySkill(this.currentSkill)) {
            ModifierComponent c = modifier.generateModifierComponent();
            c.setModifierConsumer((mod, newState) -> {
                if (newState.booleanValue()) {
                    this.modifierComponents.forEach(component -> {
                        if (!component.isModifierEnabled().booleanValue() || component.getModifier().compatibleWith((Modifier)mod) && mod.compatibleWith(component.getModifier())) {
                            return;
                        }
                        component.setModifierEnabled(false);
                    });
                }
                this.modifierUpdated();
            });
            this.modifierComponents.add(c);
        }
        if (this.modifierComponents.size() > 0) {
            boolean wasClosed = this.modifierSection != null && !this.modifierSection.isOpen();
            this.modifierSection = new ExpandableSection("Modifiers", "Toggles the different ways activity/experience gains can be modified", this.modifierComponents.stream().map(ModifierComponent::getComponent).collect(Collectors.toList()));
            this.modifierSection.setOpen(!wasClosed);
            this.add(this.modifierSection);
        }
        this.recreateItemGrid();
        if (this.itemGrid.getSelectedItem() == null) {
            this.add(new JLabel("Couldn't find any items for this skill.", 0));
        } else {
            if (this.config.limitToCurrentLevel()) {
                this.add(this.boostInput);
            }
            this.add(this.totalXpLabel);
            this.add(this.xpToNextLevelLabel);
            this.add(this.modifyPanel);
            this.add(this.itemGrid);
            if (this.config.showSecondaries()) {
                this.secondaryGrid = new SecondaryGrid(this, this.itemGrid.getPanelMap().values());
                boolean wasClosed = this.secondarySection != null && !this.secondarySection.isOpen();
                this.secondarySection = new ExpandableSection("Secondaries", "Shows a breakdown of how many secondaries are required for all enabled activities", this.secondaryGrid);
                this.secondarySection.setOpen(!wasClosed);
                if (this.secondaryGrid.getSecMap().size() > 0) {
                    this.add(this.secondarySection);
                }
            }
        }
        this.add(this.refreshBtn);
        this.revalidate();
        this.repaint();
    }

    private void recreateBankedItemMap() {
        this.bankedItemMap.clear();
        this.linkedMap.clear();
        Collection<ExperienceItem> items = ExperienceItem.getBySkill(this.currentSkill);
        log.debug("Experience items for the {} Skill: {}", (Object)this.currentSkill.getName(), items);
        for (ExperienceItem item : items) {
            BankedItem banked = new BankedItem(item, this.currentMap.getOrDefault(item.getItemID(), 0));
            this.bankedItemMap.put(item, banked);
            Activity a = item.getSelectedActivity();
            if (a == null || this.config.limitToCurrentLevel() && this.skillLevel + this.boostInput.getInputValue() < a.getLevel()) {
                List<Activity> activities = Activity.getByExperienceItem(item, this.config.limitToCurrentLevel() ? this.skillLevel + this.boostInput.getInputValue() : -1);
                if (activities.size() == 0) {
                    item.setSelectedActivity(null);
                    continue;
                }
                item.setSelectedActivity(activities.get(0));
                a = activities.get(0);
            }
            if (a.getLinkedItem() == null) continue;
            this.linkedMap.put((Object)a.getLinkedItem(), (Object)banked);
        }
        log.debug("Banked Item Map: {}", this.bankedItemMap);
        log.debug("Linked Map: {}", this.linkedMap);
    }

    private void recreateItemGrid() {
        this.itemGrid.recreateGrid(this, this.bankedItemMap.values(), this.itemManager);
        this.modifyPanel.setBankedItem(this.itemGrid.getSelectedItem());
        this.calculateBankedXpTotal();
    }

    public double getItemXpRate(BankedItem bankedItem) {
        Activity selected = bankedItem.getItem().getSelectedActivity();
        if (selected == null) {
            return 0.0;
        }
        return selected.getXpRate(this.enabledModifiers);
    }

    public int getItemQty(BankedItem item) {
        int qty = item.getQty();
        if (!this.config.cascadeBankedXp()) {
            return qty;
        }
        Map<ExperienceItem, Integer> linked = this.createLinksMap(item);
        int linkedQty = linked.entrySet().stream().mapToInt(entry -> {
            ItemStack output = ((ExperienceItem)((Object)((Object)entry.getKey()))).getSelectedActivity().getOutput();
            return (int)((double)((Integer)entry.getValue()).intValue() * (output != null ? output.getQty() : 1.0));
        }).sum();
        return qty + linkedQty;
    }

    private void calculateBankedXpTotal() {
        double total = 0.0;
        for (GridItem i : this.itemGrid.getPanelMap().values()) {
            if (i.isIgnored()) continue;
            BankedItem bi = i.getBankedItem();
            total += (double)this.getItemQty(bi) * this.getItemXpRate(bi);
        }
        this.endExp = Math.min(200000000, (int)((double)this.skillExp + total));
        this.endLevel = Experience.getLevelForXp((int)this.endExp);
        this.totalXpLabel.setText("Total Banked: " + XP_FORMAT_COMMA.format(total) + "xp");
        this.uiInput.setTargetLevelInput(this.endLevel);
        this.uiInput.setTargetXPInput(this.endExp);
        int nextLevel = Math.min(this.endLevel + 1, 126);
        int nextLevelXp = Experience.getXpForLevel((int)nextLevel) - this.endExp;
        this.xpToNextLevelLabel.setText("Level " + nextLevel + " requires: " + XP_FORMAT_COMMA.format(nextLevelXp) + "xp");
        this.refreshSecondaries();
        this.revalidate();
        this.repaint();
    }

    public void activitySelected(BankedItem i, Activity a) {
        ExperienceItem item = i.getItem();
        Activity old = item.getSelectedActivity();
        if (a.equals((Object)old)) {
            return;
        }
        item.setSelectedActivity(a);
        this.saveActivity(i.getItem());
        if (this.config.cascadeBankedXp() && a.shouldUpdateLinked(old)) {
            this.linkedMap.remove((Object)old.getLinkedItem(), (Object)i);
            this.linkedMap.put((Object)a.getLinkedItem(), (Object)i);
            this.updateLinkedItems(old);
            this.updateLinkedItems(a);
        }
        this.modifyPanel.setBankedItem(i);
        this.itemGrid.getPanelMap().get(i).updateToolTip(this.enabledModifiers);
        this.calculateBankedXpTotal();
    }

    private void updateLinkedItems(Activity activity) {
        BankedItem bi;
        if (activity == null) {
            return;
        }
        boolean foundSelected = false;
        boolean gridCountChanged = false;
        ExperienceItem i = activity.getLinkedItem();
        while (i != null && (bi = this.bankedItemMap.get((Object)i)) != null) {
            int qty = this.getItemQty(bi);
            boolean stackable = qty > 1 || bi.getItem().getItemInfo().isStackable();
            AsyncBufferedImage img = this.itemManager.getImage(bi.getItem().getItemID(), qty, stackable);
            GridItem gridItem = this.itemGrid.getPanelMap().get(bi);
            int oldQty = gridItem.getAmount();
            gridCountChanged |= oldQty == 0 && qty > 0 || oldQty > 0 && qty == 0;
            gridItem.updateIcon(img, qty);
            gridItem.updateToolTip(this.enabledModifiers);
            foundSelected |= this.itemGrid.getSelectedItem().equals(bi);
            Activity a = bi.getItem().getSelectedActivity();
            if (a == null) break;
            i = a.getLinkedItem();
        }
        if (gridCountChanged) {
            this.itemGrid.refreshGridDisplay();
        }
        if (foundSelected) {
            this.modifyPanel.setBankedItem(this.itemGrid.getSelectedItem());
        }
    }

    public Map<ExperienceItem, Integer> createLinksMap(BankedItem item) {
        HashMap<ExperienceItem, Integer> qtyMap = new HashMap<ExperienceItem, Integer>();
        Activity a = item.getItem().getSelectedActivity();
        if (a == null) {
            return qtyMap;
        }
        Collection linkedBank = this.linkedMap.get((Object)item.getItem());
        if (linkedBank == null || linkedBank.size() == 0) {
            return qtyMap;
        }
        for (BankedItem linked : linkedBank) {
            if (this.ignoredItems.contains(linked.getItem().name())) continue;
            int qty = linked.getQty();
            if (qty > 0) {
                qtyMap.put(linked.getItem(), qty);
            }
            qtyMap.putAll(this.createLinksMap(linked));
        }
        return qtyMap;
    }

    private void modifierUpdated() {
        this.enabledModifiers.clear();
        this.enabledModifiers.addAll(this.modifierComponents.stream().filter(ModifierComponent::isModifierEnabled).map(ModifierComponent::getModifier).collect(Collectors.toSet()));
        this.itemGrid.getPanelMap().values().forEach(item -> item.updateToolTip(this.enabledModifiers));
        this.modifyPanel.setBankedItem(this.modifyPanel.getBankedItem());
        this.calculateBankedXpTotal();
    }

    public int getItemQtyFromBank(int id) {
        return this.currentMap.getOrDefault(id, 0);
    }

    public void resetInventoryMaps() {
        this.inventoryMap.clear();
        this.updateCurrentMap();
        if (this.currentSkill == null) {
            return;
        }
        this.open(this.currentSkill, true);
        this.uiInput.setCurrentLevelInput(1);
        this.uiInput.setCurrentXPInput(0);
        this.uiInput.setTargetLevelInput(1);
        this.uiInput.setTargetXPInput(0);
    }

    void setInventoryMap(int inventoryId, Map<Integer, Integer> map) {
        this.inventoryMap.put(inventoryId, map);
        this.updateCurrentMap();
        this.refreshBtn.setVisible(true);
    }

    private void updateCurrentMap() {
        this.currentMap.clear();
        for (Map<Integer, Integer> map : this.inventoryMap.values()) {
            for (int id : map.keySet()) {
                int qty = map.get(id) + this.currentMap.getOrDefault(id, 0);
                this.currentMap.put(id, qty);
            }
        }
    }

    private void refreshSecondaries() {
        boolean shouldBeVisible;
        if (this.secondarySection == null || this.secondaryGrid == null) {
            return;
        }
        boolean wasVisible = this.secondaryGrid.getSecMap().size() > 0;
        this.secondaryGrid.updateSecMap(this.itemGrid.getPanelMap().values());
        boolean bl = shouldBeVisible = this.secondaryGrid.getSecMap().size() > 0;
        if (shouldBeVisible != wasVisible) {
            if (shouldBeVisible) {
                this.add((Component)this.secondarySection, this.getComponentCount() - 1);
            } else {
                this.remove(this.secondarySection);
            }
        }
    }

    private void saveActivity(ExperienceItem item) {
        this.configManager.setConfiguration("bankedexperience", "ITEM_" + item.name(), item.getSelectedActivity().name());
    }

    private void updateBoost(Integer value) {
        this.recreateBankedItemMap();
        this.recreateItemGrid();
    }

    private void ignoreBankedItem(BankedItem item, boolean ignored) {
        String name = item.getItem().name();
        if (ignored) {
            this.ignoredItems.add(name);
        } else {
            this.ignoredItems.remove(name);
        }
        this.updateLinkedItems(item.getItem().getSelectedActivity());
    }

    private void toggleIgnoreBankedItem(BankedItem item) {
        boolean ignore = !this.ignoredItems.contains(item.getItem().name());
        this.ignoreBankedItem(item, ignore);
    }

    public void setIgnoreAllItems(boolean ignored) {
        this.itemGrid.getPanelMap().values().forEach(i -> {
            this.ignoreBankedItem(i.getBankedItem(), ignored);
            i.setIgnore(ignored);
        });
        this.config.ignoredItems(Text.toCSV(this.ignoredItems));
        this.calculateBankedXpTotal();
    }

    public BankedExperienceConfig getConfig() {
        return this.config;
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }

    public Set<Modifier> getEnabledModifiers() {
        return this.enabledModifiers;
    }

    public Set<String> getIgnoredItems() {
        return this.ignoredItems;
    }

    public Skill getCurrentSkill() {
        return this.currentSkill;
    }

    public int getSkillLevel() {
        return this.skillLevel;
    }

    public int getSkillExp() {
        return this.skillExp;
    }

    public int getEndLevel() {
        return this.endLevel;
    }

    public int getEndExp() {
        return this.endExp;
    }

    public BoostInput getBoostInput() {
        return this.boostInput;
    }
}

