/*
 * Decompiled with CFR 0.152.
 */
package com.naturerunechest;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import com.naturerunechest.NatureRuneChestConfig;
import com.naturerunechest.NatureRuneChestOverlay;
import java.time.Instant;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Nature Rune Chest", description="Show when nature rune chest is ready to be looted again", tags={"overlay", "skilling", "timers"}, enabledByDefault=false)
public class NatureRuneChestPlugin
extends Plugin {
    private static final Set<Integer> NRC_REGIONS = ImmutableSet.of((Object)10547, (Object)10291, (Object)10553, (Object)12093);
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private NatureRuneChestOverlay overlay;
    @Inject
    private NatureRuneChestConfig config;
    private GameObject chest;
    private Instant start;
    private int state;

    @Provides
    NatureRuneChestConfig provideConfig(ConfigManager configManager) {
        return (NatureRuneChestConfig)configManager.getConfig(NatureRuneChestConfig.class);
    }

    protected void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
        this.overlay.updateConfig();
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        switch (event.getGameState()) {
            case LOGIN_SCREEN: 
            case HOPPING: 
            case LOADING: {
                this.chest = null;
            }
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        GameObject object = event.getGameObject();
        if (object.getId() == 11740 && NRC_REGIONS.contains(this.client.getLocalPlayer().getWorldLocation().getRegionID())) {
            this.chest = object;
            this.state = 2;
            this.start = Instant.now();
        }
        if (object.getId() == 11743 && NRC_REGIONS.contains(this.client.getLocalPlayer().getWorldLocation().getRegionID())) {
            this.chest = object;
            this.state = 1;
        }
        if (object.getId() == 11736 && NRC_REGIONS.contains(this.client.getLocalPlayer().getWorldLocation().getRegionID())) {
            this.chest = object;
            this.state = 0;
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("naturerunechestplugin")) {
            this.overlay.updateConfig();
        }
    }

    GameObject getChest() {
        return this.chest;
    }

    Instant getStart() {
        return this.start;
    }

    int getState() {
        return this.state;
    }
}

