/*
 * Decompiled with CFR 0.152.
 */
package com.naturerunechest;

import com.naturerunechest.NatureRuneChestConfig;
import com.naturerunechest.NatureRuneChestPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.time.Duration;
import java.time.Instant;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.ProgressPieComponent;

class NatureRuneChestOverlay
extends Overlay {
    private static final Duration DOWN_TIME = Duration.ofSeconds(8L);
    private final Client client;
    private final NatureRuneChestPlugin plugin;
    private final NatureRuneChestConfig config;
    private Color colorFull;
    private Color colorFullBorder;
    private Color colorEmpty;
    private Color colorEmptyBorder;

    @Inject
    private NatureRuneChestOverlay(NatureRuneChestPlugin plugin, Client client, NatureRuneChestConfig config) {
        this.plugin = plugin;
        this.client = client;
        this.config = config;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public void updateConfig() {
        this.colorEmptyBorder = this.config.getEmptyChestColor();
        this.colorEmpty = new Color(this.colorEmptyBorder.getRed(), this.colorEmptyBorder.getGreen(), this.colorEmptyBorder.getBlue(), 100);
        this.colorFullBorder = this.config.getFullChestColor();
        this.colorFull = new Color(this.colorFullBorder.getRed(), this.colorFullBorder.getGreen(), this.colorFullBorder.getBlue(), 100);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.getChest() == null) {
            return null;
        }
        LocalPoint localLoc = LocalPoint.fromWorld((Client)this.client, (WorldPoint)this.plugin.getChest().getWorldLocation());
        if (localLoc == null) {
            return null;
        }
        Point loc = Perspective.localToCanvas((Client)this.client, (LocalPoint)localLoc, (int)this.client.getPlane());
        if (loc == null) {
            return null;
        }
        ProgressPieComponent progressPie = new ProgressPieComponent();
        int empty = this.plugin.getState();
        this.updateConfig();
        if (empty == 2) {
            progressPie.setDiameter(60);
            progressPie.setFill(this.colorEmpty);
            progressPie.setBorderColor(this.colorEmptyBorder);
            progressPie.setPosition(loc);
            Duration duration = Duration.between(this.plugin.getStart(), Instant.now());
            progressPie.setProgress(1.0 - (duration.compareTo(DOWN_TIME) < 0 ? (double)duration.toMillis() / (double)DOWN_TIME.toMillis() : 1.0));
            progressPie.render(graphics);
        }
        if (empty == 1) {
            progressPie.setDiameter(0);
            progressPie.render(graphics);
        }
        if (empty == 0) {
            progressPie.setDiameter(60);
            progressPie.setFill(this.colorFull);
            progressPie.setBorderColor(this.colorFullBorder);
            progressPie.setPosition(loc);
            progressPie.setProgress(100.0);
            progressPie.render(graphics);
        }
        return null;
    }
}

