/*
 * Decompiled with CFR 0.152.
 */
package equipmentinspector;

import equipmentinspector.EquipmentInspectorPanel;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.ItemComposition;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.Player;
import net.runelite.api.PlayerComposition;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.kit.KitType;
import net.runelite.client.Notifier;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.menus.MenuManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Equipment Inspector")
@Singleton
public class EquipmentInspectorPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(EquipmentInspectorPlugin.class);
    private static final String INSPECT_EQUIPMENT = "Equipment";
    private static final String KICK_OPTION = "Kick";
    @Inject
    @Nullable
    private Client client;
    @Inject
    private Provider<MenuManager> menuManager;
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    private ClientToolbar pluginToolbar;
    private NavigationButton navButton;
    private EquipmentInspectorPanel equipmentInspectorPanel;
    @Inject
    private Notifier notifier;
    @Inject
    private ItemManager itemManager;
    private final Map<Integer, PlayerInfo> storedPlayers = new HashMap<Integer, PlayerInfo>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startUp() throws Exception {
        this.equipmentInspectorPanel = (EquipmentInspectorPanel)((Object)this.injector.getInstance(EquipmentInspectorPanel.class));
        ((MenuManager)this.menuManager.get()).addPlayerMenuItem(INSPECT_EQUIPMENT);
        Class<ImageIO> clazz = ImageIO.class;
        synchronized (ImageIO.class) {
            BufferedImage icon = ImageIO.read(((Object)((Object)this)).getClass().getResourceAsStream("normal.png"));
            // ** MonitorExit[var2_1] (shouldn't be in output)
            this.navButton = NavigationButton.builder().tooltip("Equipment Inspector").icon(icon).priority(5).panel((PluginPanel)this.equipmentInspectorPanel).build();
            this.pluginToolbar.addNavigation(this.navButton);
            return;
        }
    }

    protected void shutDown() throws Exception {
        ((MenuManager)this.menuManager.get()).removePlayerMenuItem(INSPECT_EQUIPMENT);
        this.pluginToolbar.removeNavigation(this.navButton);
    }

    @Subscribe
    public void onMenuOpened(MenuOpened event) {
        Stream.of(event.getMenuEntries()).map(MenuEntry::getActor).filter(a -> a instanceof Player).map(Player.class::cast).distinct().map(p -> new PlayerInfo(p.getId(), p.getName(), p.getPlayerComposition())).forEach(playerInfo -> this.storedPlayers.put(playerInfo.getId(), (PlayerInfo)playerInfo));
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuAction() == MenuAction.RUNELITE_PLAYER && event.getMenuOption().equals(INSPECT_EQUIPMENT)) {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    if (!this.navButton.isSelected()) {
                        this.navButton.getOnSelect().run();
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            PlayerInfo p = this.getPlayerInfo(event.getId());
            if (p == null) {
                return;
            }
            HashMap<KitType, ItemComposition> playerEquipment = new HashMap<KitType, ItemComposition>();
            HashMap<KitType, Integer> equipmentPrices = new HashMap<KitType, Integer>();
            for (KitType kitType : KitType.values()) {
                int itemId = p.getPlayerComposition().getEquipmentId(kitType);
                if (itemId == -1) continue;
                ItemComposition itemComposition = this.client.getItemDefinition(itemId);
                playerEquipment.put(kitType, itemComposition);
                equipmentPrices.put(kitType, this.itemManager.getItemPrice(itemId));
            }
            this.equipmentInspectorPanel.update(playerEquipment, equipmentPrices, p.getName());
        }
        this.storedPlayers.clear();
    }

    private PlayerInfo getPlayerInfo(int id) {
        Player p = this.client.getCachedPlayers()[id];
        if (p != null) {
            return new PlayerInfo(p.getId(), p.getName(), p.getPlayerComposition());
        }
        return this.storedPlayers.getOrDefault(id, null);
    }

    private static final class PlayerInfo {
        private final int id;
        private final String name;
        private final PlayerComposition playerComposition;

        public PlayerInfo(int id, String name, PlayerComposition playerComposition) {
            this.id = id;
            this.name = name;
            this.playerComposition = playerComposition;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public PlayerComposition getPlayerComposition() {
            return this.playerComposition;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PlayerInfo)) {
                return false;
            }
            PlayerInfo other = (PlayerInfo)o;
            if (this.getId() != other.getId()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            PlayerComposition this$playerComposition = this.getPlayerComposition();
            PlayerComposition other$playerComposition = other.getPlayerComposition();
            return !(this$playerComposition == null ? other$playerComposition != null : !this$playerComposition.equals(other$playerComposition));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getId();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            PlayerComposition $playerComposition = this.getPlayerComposition();
            result = result * 59 + ($playerComposition == null ? 43 : $playerComposition.hashCode());
            return result;
        }

        public String toString() {
            return "EquipmentInspectorPlugin.PlayerInfo(id=" + this.getId() + ", name=" + this.getName() + ", playerComposition=" + this.getPlayerComposition() + ")";
        }
    }
}

