/*
 * Decompiled with CFR 0.152.
 */
package equipmentinspector;

import equipmentinspector.ItemPanel;
import equipmentinspector.TotalPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Client;
import net.runelite.api.ItemComposition;
import net.runelite.api.kit.KitType;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.AsyncBufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EquipmentInspectorPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(EquipmentInspectorPanel.class);
    private static final String NO_PLAYER_SELECTED = "No player selected";
    private GridBagConstraints c;
    private JPanel equipmentPanels;
    private JPanel header;
    public JLabel nameLabel;
    @Inject
    private Client client;
    @Inject
    private ItemManager itemManager;

    public EquipmentInspectorPanel() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.equipmentPanels = new JPanel(new GridBagLayout());
        this.c = new GridBagConstraints();
        this.c.fill = 2;
        this.c.weightx = 1.0;
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.header = new JPanel();
        this.header.setLayout(new BorderLayout());
        this.header.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(58, 58, 58)), BorderFactory.createEmptyBorder(0, 0, 10, 0)));
        this.nameLabel = new JLabel(NO_PLAYER_SELECTED);
        this.nameLabel.setForeground(Color.WHITE);
        this.header.add((Component)this.nameLabel, "Center");
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.equipmentPanels).addComponent(this.header));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.header).addGap(10).addComponent(this.equipmentPanels));
        this.update(new HashMap<KitType, ItemComposition>(), new HashMap<KitType, Integer>(), "");
    }

    public void update(Map<KitType, ItemComposition> playerEquipment, Map<KitType, Integer> equipmentPrices, String playerName) {
        if (playerName.isEmpty() || playerName == null) {
            this.nameLabel.setText(NO_PLAYER_SELECTED);
        } else {
            this.nameLabel.setText("Player: " + playerName);
        }
        SwingUtilities.invokeLater(() -> {
            this.equipmentPanels.removeAll();
            AtomicLong totalItemPrice = new AtomicLong();
            playerEquipment.forEach((kitType, itemComposition) -> {
                AsyncBufferedImage itemImage = this.itemManager.getImage(itemComposition.getId());
                int GetitemPrice = (Integer)equipmentPrices.get(kitType);
                totalItemPrice.addAndGet(GetitemPrice);
                String itemPrice = NumberFormat.getNumberInstance(Locale.US).format(GetitemPrice);
                this.equipmentPanels.add((Component)new ItemPanel((ItemComposition)itemComposition, (KitType)kitType, itemImage, itemPrice), this.c);
                ++this.c.gridy;
            });
            if (!this.nameLabel.getText().equals(NO_PLAYER_SELECTED)) {
                this.equipmentPanels.add((Component)new TotalPanel(totalItemPrice), this.c);
                ++this.c.gridy;
            }
            this.header.revalidate();
            this.header.repaint();
        });
    }
}

