/*
 * Decompiled with CFR 0.152.
 */
package callmemaple.aerialfishingtimers;

import callmemaple.aerialfishingtimers.AerialFishingSpot;
import callmemaple.aerialfishingtimers.AerialFishingTimersConfig;
import callmemaple.aerialfishingtimers.AerialFishingTimersOverlay;
import com.google.inject.Provides;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalUnit;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.FishingSpot;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.RSTimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Aerial Fishing Timers", description="Adds timers to indicate when aerial fishing spots will expire", tags={"fishing", "aerial", "timer", "despawn"})
public class AerialFishingTimersPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(AerialFishingTimersPlugin.class);
    public static final int SPOT_MAX_SPAWN_TICKS = 19;
    public static final int SPOT_MIN_SPAWN_TICKS = 10;
    public static final Duration SPOT_MAX_SPAWN_DURATION = Duration.of(19L, (TemporalUnit)RSTimeUnit.GAME_TICKS);
    public static final float SPOT_RANDOM_PERCENT_THRESHOLD = 0.5263158f;
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private AerialFishingTimersConfig config;
    @Inject
    private AerialFishingTimersOverlay overlay;
    private final Map<NPC, AerialFishingSpot> activeFishingSpots = new HashMap<NPC, AerialFishingSpot>();

    protected void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() {
        this.activeFishingSpots.clear();
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        NPC npc = event.getNpc();
        if (FishingSpot.findSpot((int)npc.getId()) == null) {
            return;
        }
        this.activeFishingSpots.put(npc, new AerialFishingSpot(npc, Instant.now()));
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        NPC spot = npcDespawned.getNpc();
        if (!this.activeFishingSpots.containsKey(spot)) {
            return;
        }
        this.activeFishingSpots.remove(spot);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        Instant now = Instant.now();
        this.activeFishingSpots.values().removeIf(spot -> Duration.between(now, spot.getSpawnTime()).compareTo(SPOT_MAX_SPAWN_DURATION) > 0);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        switch (event.getGameState()) {
            case HOPPING: 
            case LOGGING_IN: {
                this.activeFishingSpots.clear();
                break;
            }
        }
    }

    @Provides
    AerialFishingTimersConfig provideConfig(ConfigManager configManager) {
        return (AerialFishingTimersConfig)configManager.getConfig(AerialFishingTimersConfig.class);
    }

    Map<NPC, AerialFishingSpot> getActiveFishingSpots() {
        return this.activeFishingSpots;
    }
}

