/*
 * Decompiled with CFR 0.152.
 */
package callmemaple.aerialfishingtimers;

import callmemaple.aerialfishingtimers.AerialFishingSpot;
import callmemaple.aerialfishingtimers.AerialFishingTimersConfig;
import callmemaple.aerialfishingtimers.AerialFishingTimersPlugin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.time.Instant;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.NPC;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.ProgressPieComponent;

public class AerialFishingTimersOverlay
extends Overlay {
    private final Client client;
    private final AerialFishingTimersPlugin plugin;
    private final AerialFishingTimersConfig config;

    @Inject
    private AerialFishingTimersOverlay(Client client, AerialFishingTimersPlugin plugin, AerialFishingTimersConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.plugin = plugin;
        this.client = client;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.isWearingGlove()) {
            return null;
        }
        Map<NPC, AerialFishingSpot> spots = this.plugin.getActiveFishingSpots();
        Instant now = Instant.now();
        float warningThreshold = (float)(10 - this.config.getWarningThreshold()) / 19.0f;
        for (AerialFishingSpot spot : spots.values()) {
            Point point;
            LocalPoint location = spot.getNpc().getLocalLocation();
            if (location == null) continue;
            Instant spawnTime = spot.getSpawnTime();
            long maxRespawn = AerialFishingTimersPlugin.SPOT_MAX_SPAWN_DURATION.toMillis();
            long sinceSpawn = now.toEpochMilli() - spawnTime.toEpochMilli();
            float percentProgress = (float)sinceSpawn / (float)maxRespawn;
            if (this.config.getTickIncrement()) {
                float millisPerTick = (float)AerialFishingTimersPlugin.SPOT_MAX_SPAWN_DURATION.toMillis() / 19.0f;
                percentProgress = (float)(Math.floor((float)sinceSpawn / millisPerTick) / 19.0);
            }
            if ((point = Perspective.localToCanvas((Client)this.client, (LocalPoint)location, (int)this.client.getPlane())) == null || percentProgress > 1.0f) continue;
            if (this.config.getDrawExpirationLine() && percentProgress < 0.5263158f) {
                this.drawExpirationLine(graphics, point);
            }
            Color pieFillColor = this.config.getAvailableColor();
            if (percentProgress >= 0.5263158f) {
                pieFillColor = this.config.getExpiringColor();
            } else if (percentProgress >= warningThreshold) {
                pieFillColor = this.config.getWarningColor();
            }
            ProgressPieComponent ppc = new ProgressPieComponent();
            ppc.setDiameter(this.config.getCircleSize());
            ppc.setBorderColor(pieFillColor.darker());
            ppc.setFill(pieFillColor);
            ppc.setPosition(point);
            ppc.setProgress((double)percentProgress);
            ppc.render(graphics);
        }
        return null;
    }

    private void drawExpirationLine(Graphics2D graphics, Point point) {
        double theta = 4.877736130352222;
        double xOffset = (double)((float)this.config.getCircleSize() / 2.0f) * Math.cos(theta);
        double yOffset = (double)(-1.0f * ((float)this.config.getCircleSize() / 2.0f)) * Math.sin(theta);
        BasicStroke dashedStroke = new BasicStroke(1.5f, 0, 0, 1.0f, new float[]{2.0f, 2.0f}, 1.0f);
        graphics.setStroke(dashedStroke);
        graphics.setColor(this.config.getExpiringColor());
        graphics.draw(new Line2D.Double(point.getX(), point.getY(), (double)point.getX() + xOffset, (double)point.getY() + yOffset));
    }

    private boolean isWearingGlove() {
        ItemContainer equipment = this.client.getItemContainer(InventoryID.EQUIPMENT);
        if (equipment == null) {
            return false;
        }
        int weaponIndex = EquipmentInventorySlot.WEAPON.getSlotIdx();
        Item weapon = equipment.getItem(weaponIndex);
        if (weapon == null) {
            return false;
        }
        switch (weapon.getId()) {
            case 22816: 
            case 22817: {
                return true;
            }
        }
        return false;
    }
}

