/*
 * Decompiled with CFR 0.152.
 */
package com.brastasauce.wildernessslayer;

import com.brastasauce.wildernessslayer.Task;
import com.brastasauce.wildernessslayer.TaskWorldMapPoint;
import com.brastasauce.wildernessslayer.WildernessSlayerConfig;
import com.brastasauce.wildernessslayer.WildernessSlayerOverlay;
import com.google.inject.Provides;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.worldmap.WorldMapPoint;
import net.runelite.client.ui.overlay.worldmap.WorldMapPointManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Wilderness Slayer")
public class WildernessSlayerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(WildernessSlayerPlugin.class);
    private static final String KRYSTILIA = "Krystilia";
    private static final Pattern KRYSTILIA_ASSIGN_MESSAGE = Pattern.compile(".*(?:Your new task is to kill \\d+) (?<name>.+)(?:.)");
    private static final Pattern KRYSTILIA_CURRENT_MESSAGE = Pattern.compile(".*(?:You're still meant to be slaying) (?<name>.+)(?: in the Wilderness.+)");
    private Task task;
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private WorldMapPointManager worldMapPointManager;
    @Inject
    private WildernessSlayerOverlay overlay;
    @Inject
    private WildernessSlayerConfig config;

    private void setTask(String taskName) {
        this.task = Task.getTask(taskName);
        this.createWorldPoints();
    }

    private void completeTask() {
        this.task = null;
        this.removeWorldPoints();
    }

    private void createWorldPoints() {
        this.removeWorldPoints();
        if (this.task != null && this.config.displayMapIcon()) {
            for (WorldPoint worldPoint : this.task.getWorldPoints()) {
                this.worldMapPointManager.add((WorldMapPoint)new TaskWorldMapPoint(worldPoint));
            }
        }
    }

    private void removeWorldPoints() {
        this.worldMapPointManager.removeIf(TaskWorldMapPoint.class::isInstance);
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        Widget npcName = this.client.getWidget(15138820);
        Widget npcDialog = this.client.getWidget(15138822);
        if (npcDialog != null && npcName.getText().equals(KRYSTILIA)) {
            String name;
            String npcText = Text.sanitizeMultilineText((String)npcDialog.getText());
            Matcher mAssign = KRYSTILIA_ASSIGN_MESSAGE.matcher(npcText);
            Matcher mCurrent = KRYSTILIA_CURRENT_MESSAGE.matcher(npcText);
            if (mAssign.find()) {
                name = mAssign.group("name");
                this.setTask(name);
            }
            if (mCurrent.find()) {
                name = mCurrent.group("name");
                this.setTask(name);
            }
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.GAMEMESSAGE && event.getType() != ChatMessageType.SPAM) {
            return;
        }
        String chatMessage = Text.removeTags((String)event.getMessage());
        if (chatMessage.startsWith("You've completed") && (chatMessage.contains("Slayer master") || chatMessage.contains("Slayer Master"))) {
            this.completeTask();
        }
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.task = null;
        this.removeWorldPoints();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("wildernessslayer")) {
            this.createWorldPoints();
        }
    }

    @Provides
    WildernessSlayerConfig provideConfig(ConfigManager configManager) {
        return (WildernessSlayerConfig)configManager.getConfig(WildernessSlayerConfig.class);
    }

    public Task getTask() {
        return this.task;
    }
}

