/*
 * Decompiled with CFR 0.152.
 */
package chopchopstop;

import chopchopstop.ChopChopStopConfig;
import com.google.inject.Provides;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.ChatLineBuffer;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.OverheadTextChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Chop Chop Stop")
public class ChopChopStopPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ChopChopStopPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ChopChopStopConfig config;
    static final String CONFIG_GROUP = "chopchopstop";
    private static final String AXE_SPECIAL_TEXT = "Chop chop!";
    private static final String PICKAXE_SPECIAL_TEXT = "Smashing!";
    private static final String HARPOON_SPECIAL_TEXT = "Here fishy fishies!";
    private Set<String> activeMutes;

    protected void startUp() throws Exception {
        this.activeMutes = new HashSet<String>();
        this.readConfig();
    }

    private void readConfig() {
        this.activeMutes.clear();
        if (this.config.muteAxes()) {
            this.activeMutes.add(AXE_SPECIAL_TEXT);
        }
        if (this.config.mutePickaxes()) {
            this.activeMutes.add(PICKAXE_SPECIAL_TEXT);
        }
        if (this.config.muteHarpoons()) {
            this.activeMutes.add(HARPOON_SPECIAL_TEXT);
        }
    }

    protected void shutDown() throws Exception {
        this.activeMutes.clear();
    }

    @Subscribe(priority=-2.0f)
    public void onOverheadTextChanged(OverheadTextChanged event) {
        if (!(event.getActor() instanceof Player)) {
            return;
        }
        Player localPlayer = this.client.getLocalPlayer();
        if (localPlayer == null || localPlayer.getName() == null || localPlayer.getName().equals(event.getActor().getName())) {
            return;
        }
        if (this.activeMutes.contains(event.getOverheadText())) {
            event.getActor().setOverheadText(" ");
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        Player localPlayer = this.client.getLocalPlayer();
        if (chatMessage.getType() != ChatMessageType.PUBLICCHAT) {
            return;
        }
        if (localPlayer == null || localPlayer.getName() == null || !localPlayer.getName().equals(chatMessage.getName())) {
            return;
        }
        ChatLineBuffer lineBuffer = (ChatLineBuffer)this.client.getChatLineMap().get(ChatMessageType.PUBLICCHAT.getType());
        if (lineBuffer == null) {
            return;
        }
        if (this.activeMutes.contains(chatMessage.getMessage())) {
            lineBuffer.removeMessageNode(chatMessage.getMessageNode());
            this.clientThread.invoke(() -> this.client.runScript(new Object[]{216}));
            localPlayer.setOverheadText(" ");
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals(CONFIG_GROUP)) {
            this.readConfig();
        }
    }

    @Provides
    ChopChopStopConfig provideConfig(ConfigManager configManager) {
        return (ChopChopStopConfig)configManager.getConfig(ChopChopStopConfig.class);
    }
}

