/*
 * Decompiled with CFR 0.152.
 */
package es.weedl;

import com.google.inject.Provides;
import es.weedl.AccountChatFilterConfig;
import es.weedl.AccountIconID;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.FriendsChatManager;
import net.runelite.api.MessageNode;
import net.runelite.api.Player;
import net.runelite.api.Renderable;
import net.runelite.api.clan.ClanChannel;
import net.runelite.api.events.OverheadTextChanged;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.client.callback.Hooks;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Account Chat Filter")
public class AccountChatFilterPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(AccountChatFilterPlugin.class);
    @Inject
    private Client client;
    @Inject
    private AccountChatFilterConfig config;
    @Inject
    private Hooks hooks;
    private final Set<AccountIconID> filteredAccountTypes = new HashSet<AccountIconID>();
    private final Map<Integer, String> originalNames = new HashMap<Integer, String>();
    private final Set<String> filteredAccountNames = new HashSet<String>();
    private final Hooks.RenderableDrawListener drawListener = this::shouldDraw;

    @Provides
    final AccountChatFilterConfig provideConfig(ConfigManager configManager) {
        return (AccountChatFilterConfig)configManager.getConfig(AccountChatFilterConfig.class);
    }

    private void addOrRemove(AccountIconID accountIconID, boolean isAdd) {
        if (isAdd) {
            this.filteredAccountTypes.add(accountIconID);
        } else {
            this.filteredAccountTypes.remove((Object)accountIconID);
        }
    }

    protected void updateFilteredAccounts() {
        this.addOrRemove(AccountIconID.IRONMAN, this.config.filterIronmen());
        this.addOrRemove(AccountIconID.HARDCORE_IRONMAN, this.config.filterHardcoreIronmen());
        this.addOrRemove(AccountIconID.ULTIMATE_IRONMAN, this.config.filterUltimateIronmen());
        this.addOrRemove(AccountIconID.GROUP_IRONMAN, this.config.filterGroupIronmen());
        this.addOrRemove(AccountIconID.HARDCORE_GROUP_IRONMAN, this.config.filterHardcoreGroupIronmen());
        this.addOrRemove(AccountIconID.UNRANKED_GROUP_IRONMAN, this.config.filterUnrankedGroupIronmen());
        this.addOrRemove(AccountIconID.LEAGUE, this.config.filterLeague());
    }

    private void resetNames() {
        for (Integer messageId : this.originalNames.keySet()) {
            String originalName = this.originalNames.get(messageId);
            MessageNode messageNode = (MessageNode)this.client.getMessages().get((long)messageId.intValue());
            messageNode.setName(originalName);
        }
    }

    protected void startUp() throws Exception {
        this.handleChange();
        this.hooks.registerRenderableDrawListener(this.drawListener);
    }

    protected void shutDown() {
        this.hooks.unregisterRenderableDrawListener(this.drawListener);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!"accountChatFilter".equals(event.getGroup())) {
            return;
        }
        this.handleChange();
    }

    private void handleChange() {
        this.updateFilteredAccounts();
        if (!this.config.onlyFilterIcons()) {
            this.resetNames();
        }
        this.filteredAccountNames.clear();
        this.client.refreshChat();
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent event) {
        if (!"chatFilterCheck".equals(event.getEventName())) {
            return;
        }
        int[] intStack = this.client.getIntStack();
        int intStackSize = this.client.getIntStackSize();
        int messageType = intStack[intStackSize - 2];
        int messageId = intStack[intStackSize - 1];
        ChatMessageType chatMessageType = ChatMessageType.of((int)messageType);
        MessageNode messageNode = (MessageNode)this.client.getMessages().get((long)messageId);
        String name = this.originalNames.getOrDefault(messageId, messageNode.getName());
        boolean shouldFilter = this.shouldFilter(name);
        if (shouldFilter) {
            this.filteredAccountNames.add(Text.standardize((String)name));
            if (this.config.onlyFilterIcons()) {
                this.originalNames.put(messageId, name);
                messageNode.setName(this.filterIcons(name));
                this.client.refreshChat();
            } else {
                boolean blockMessage = this.isBlockableMessageType(chatMessageType);
                if (blockMessage) {
                    intStack[intStackSize - 3] = 0;
                }
            }
        } else if (this.originalNames.containsKey(messageId)) {
            messageNode.setName(this.originalNames.remove(messageId));
            this.client.refreshChat();
        }
    }

    private boolean isBlockableMessageType(ChatMessageType chatMessageType) {
        switch (chatMessageType) {
            case PUBLICCHAT: 
            case MODCHAT: 
            case AUTOTYPER: 
            case PRIVATECHAT: 
            case MODPRIVATECHAT: 
            case FRIENDSCHAT: 
            case CLAN_CHAT: 
            case CLAN_GUEST_CHAT: {
                return true;
            }
        }
        return false;
    }

    @Subscribe
    public void onOverheadTextChanged(OverheadTextChanged event) {
        if (!(event.getActor() instanceof Player)) {
            return;
        }
        String message = event.getOverheadText();
        if (this.shouldFilter(event.getActor().getName())) {
            message = " ";
        }
        event.getActor().setOverheadText(message);
    }

    protected String filterIcons(String name) {
        String filteredName = name;
        for (AccountIconID accountIconID : this.filteredAccountTypes) {
            filteredName = filteredName.replace(accountIconID.toString(), "");
        }
        return filteredName;
    }

    private boolean isSelf(String name) {
        return Text.standardize((String)name).equals(Text.standardize((String)this.client.getLocalPlayer().getName()));
    }

    private boolean isFriend(String name) {
        return this.client.isFriended(name, false);
    }

    private boolean isFriendsChatMember(String name) {
        FriendsChatManager friendsChatManager = this.client.getFriendsChatManager();
        return friendsChatManager != null && friendsChatManager.findByName(name) != null;
    }

    private boolean isClanChatMember(String name) {
        ClanChannel clanChannel = this.client.getClanChannel();
        if (clanChannel != null && clanChannel.findMember(name) != null) {
            return true;
        }
        clanChannel = this.client.getGuestClanChannel();
        return clanChannel != null && clanChannel.findMember(name) != null;
    }

    private boolean shouldSkipFilters(String name) {
        if (!this.config.filterSelf() && this.isSelf(name)) {
            return true;
        }
        if (!this.config.filterFriends() && this.isFriend(name)) {
            return true;
        }
        if (!this.config.filterFriendsChat() && this.isFriendsChatMember(name)) {
            return true;
        }
        return !this.config.filterClanChat() && this.isClanChatMember(name);
    }

    private boolean isFilteredAccountType(String name) {
        return this.filteredAccountTypes.stream().anyMatch(accountIconID -> name.contains(accountIconID.toString()));
    }

    private boolean isNormalAccount(String name) {
        return Arrays.stream(AccountIconID.values()).noneMatch(accountIconID -> name.contains(accountIconID.toString()));
    }

    protected boolean shouldFilter(String name) {
        if (this.shouldSkipFilters(Text.removeTags((String)name))) {
            return false;
        }
        if (this.isFilteredAccountType(name)) {
            return true;
        }
        Player player = this.getPlayerFromName(name);
        if (player != null && player.getCombatLevel() <= this.config.filteredCombatLevel()) {
            return true;
        }
        return this.config.filterNormalAccounts() && this.isNormalAccount(name);
    }

    boolean shouldDraw(Renderable renderable, boolean drawingUI) {
        if (!this.config.hideCharacterModels()) {
            return true;
        }
        if (renderable instanceof Player) {
            Player player = (Player)renderable;
            String name = player.getName();
            return name != null && !this.filteredAccountNames.contains(Text.standardize((String)name));
        }
        return true;
    }

    private Player getPlayerFromName(String playerName) {
        String sanitizedName = Text.standardize((String)playerName);
        Player player = null;
        for (Player p : this.client.getPlayers()) {
            if (!p.getName().toLowerCase().equals(sanitizedName)) continue;
            player = p;
            break;
        }
        return player;
    }
}

