/*
 * Decompiled with CFR 0.152.
 */
package com.breakreminder;

import java.time.Duration;
import java.time.Instant;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class Timer {
    private final Instant endTime;

    public Timer(Instant endTime) {
        this.endTime = endTime;
        if (endTime == null) {
            throw new NullPointerException("End time cannot be null");
        }
    }

    public Duration getDurationBetweenSystemClockAndEndTime() {
        Instant now = Instant.now();
        return Duration.between(now, this.endTime);
    }

    public String formatDuration(Duration duration, boolean showSeconds) {
        long hours = duration.toHours();
        String format = hours > 0L ? (showSeconds ? "H:mm:ss" : "H:mm") : (showSeconds ? "mm:ss" : "mm");
        long milliseconds = duration.abs().toMillis();
        return DurationFormatUtils.formatDuration((long)milliseconds, (String)format, (boolean)false);
    }

    public Duration roundMinutes(Duration duration) {
        if (duration.isNegative()) {
            return duration;
        }
        return duration.plusMinutes(1L);
    }
}

