/*
 * Decompiled with CFR 0.152.
 */
package com.breakreminder;

import com.breakreminder.BreakConfig;
import com.breakreminder.BreakOverlay;
import com.breakreminder.Timer;
import com.google.inject.Provides;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Break Reminder", description="Reminder to take regular breaks")
public class BreakReminderPlugin
extends Plugin {
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private BreakOverlay breakOverlay;
    @Inject
    private BreakConfig config;
    private Timer timer;
    private int currentBreakIntervalLength;
    private final List<GameState> previousGameStates = new ArrayList<GameState>();
    private final int hoppingStatesQuantity = 3;

    @Provides
    BreakConfig provideConfig(ConfigManager configManager) {
        return (BreakConfig)configManager.getConfig(BreakConfig.class);
    }

    protected void startUp() {
        this.currentBreakIntervalLength = this.config.nextBreakInterval();
        long intervalInSeconds = (long)this.currentBreakIntervalLength * 60L;
        Instant intervalEndTime = Instant.now().plusSeconds(intervalInSeconds);
        this.timer = new Timer(intervalEndTime);
        this.overlayManager.add((Overlay)this.breakOverlay);
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.breakOverlay);
        this.previousGameStates.clear();
        this.timer = null;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        this.previousGameStates.add(event.getGameState());
        if (this.previousGameStates.size() < 3) {
            return;
        }
        if (event.getGameState() == GameState.LOGGED_IN && !this.isWorldHopping()) {
            this.currentBreakIntervalLength = this.config.nextBreakInterval();
            int intervalInSeconds = this.config.nextBreakInterval() * 60;
            Instant intervalEndTime = Instant.now().plusSeconds(intervalInSeconds);
            this.timer = new Timer(intervalEndTime);
        }
    }

    private boolean isWorldHopping() {
        int size = this.previousGameStates.size();
        List<GameState> states = this.previousGameStates.subList(size - 3, size);
        return states.get(0) == GameState.HOPPING && states.get(1) == GameState.LOADING && states.get(2) == GameState.LOGGED_IN;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public int getCurrentBreakIntervalLength() {
        return this.currentBreakIntervalLength;
    }
}

