/*
 * Decompiled with CFR 0.152.
 */
package com.breakreminder;

import com.breakreminder.BreakConfig;
import com.breakreminder.BreakReminderPlugin;
import com.breakreminder.Timer;
import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.time.Duration;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class BreakOverlay
extends Overlay {
    private final PanelComponent panelComponent = new PanelComponent();
    private final BreakReminderPlugin plugin;
    private final BreakConfig config;

    @Inject
    private BreakOverlay(BreakReminderPlugin plugin, BreakConfig config) {
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        Timer timer = this.plugin.getTimer();
        Duration timeRemaining = timer.getDurationBetweenSystemClockAndEndTime();
        this.panelComponent.getChildren().clear();
        this.panelComponent.getChildren().add(this.createTitle(timeRemaining));
        this.panelComponent.getChildren().add(this.createTimeDisplay(timeRemaining, timer));
        if (this.plugin.getCurrentBreakIntervalLength() != this.config.nextBreakInterval()) {
            LayoutableRenderableEntity nextInterval = this.createNextInterval(timer);
            this.panelComponent.getChildren().add(nextInterval);
        }
        this.panelComponent.setPreferredSize(new Dimension(105, 0));
        this.panelComponent.setBorder(new Rectangle(5, 5, 5, 5));
        this.setPosition(this.config.overlayPosition());
        return this.panelComponent.render(graphics);
    }

    private LayoutableRenderableEntity createTitle(Duration timeRemaining) {
        return timeRemaining.isNegative() ? this.buildTitle("Take a break", Color.red) : this.buildTitle("Break due", Color.green);
    }

    private LayoutableRenderableEntity createTimeDisplay(Duration timeRemaining, Timer timer) {
        String formattedTime = timer.formatDuration(this.config.DisplaySeconds() ? timeRemaining : timer.roundMinutes(timeRemaining), this.config.DisplaySeconds());
        return timeRemaining.isNegative() ? this.buildLine("Overdue:", Color.orange, formattedTime, Color.orange) : this.buildLine("Time:", Color.white, formattedTime, Color.white);
    }

    private LayoutableRenderableEntity createNextInterval(Timer timer) {
        SystemColor color = SystemColor.info;
        Duration minutes = Duration.ofMinutes(this.config.nextBreakInterval());
        String duration = timer.formatDuration(minutes, this.config.DisplaySeconds());
        return this.buildLine("Next:", color, duration, color);
    }

    private TitleComponent buildTitle(String text, Color color) {
        return TitleComponent.builder().text(text).color(color).build();
    }

    private LineComponent buildLine(String left, Color leftColor, String right, Color rightColor) {
        return LineComponent.builder().left(left).leftColor(leftColor).right(right).rightColor(rightColor).build();
    }
}

