/*
 * Decompiled with CFR 0.152.
 */
package com.larsvansoest.runelite.clueitems.ui.stashes;

import com.larsvansoest.runelite.clueitems.EmoteClueItemsImages;
import com.larsvansoest.runelite.clueitems.data.EmoteClue;
import com.larsvansoest.runelite.clueitems.data.EmoteClueAssociations;
import com.larsvansoest.runelite.clueitems.data.EmoteClueDifficulty;
import com.larsvansoest.runelite.clueitems.data.StashUnit;
import com.larsvansoest.runelite.clueitems.ui.EmoteClueItemsPalette;
import com.larsvansoest.runelite.clueitems.ui.components.CycleButton;
import com.larsvansoest.runelite.clueitems.ui.components.DataGrid;
import com.larsvansoest.runelite.clueitems.ui.components.DescriptionPanel;
import com.larsvansoest.runelite.clueitems.ui.components.FoldablePanel;
import com.larsvansoest.runelite.clueitems.ui.components.ItemCollectionPanel;
import com.larsvansoest.runelite.clueitems.ui.components.MapLinkButton;
import com.larsvansoest.runelite.clueitems.ui.components.PropertyPanel;
import com.larsvansoest.runelite.clueitems.ui.components.RequirementPanel;
import com.larsvansoest.runelite.clueitems.ui.components.StatusPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StashUnitPanel
extends RequirementPanel {
    private CycleButton filledButton;
    private final int filledButtonComplete;
    private final int filledButtonInComplete;
    private final EmoteClueItemsPalette palette;
    private final EmoteClueDifficulty[] difficulties;
    private final int quantity;
    private final ImageIcon stashBuiltIcon;
    private final ImageIcon stashNotBuiltIcon;
    private final MapLinkButton mapLinkButton;
    private final JLabel stashUnitImage;
    private boolean filled;
    private boolean built;
    private ItemCollectionPanel itemCollectionPanel;
    private final int requiredConstructionLevel;
    private final PropertyPanel constructionLevelPanel;

    public StashUnitPanel(EmoteClueItemsPalette palette, StashUnit stash, BiConsumer<StashUnit, Boolean> onStashFillStatusChanged, BiConsumer<StashUnitPanel, Boolean> onAddStashUnitToMap, Runnable onRemoveStashUnitFromMap) {
        super(palette, stash.getName(), 160, 20);
        this.palette = palette;
        this.stashBuiltIcon = new ImageIcon(EmoteClueItemsImages.Icons.RuneScape.StashUnit.get(stash.getType(), true, false));
        this.stashNotBuiltIcon = new ImageIcon(EmoteClueItemsImages.Icons.RuneScape.StashUnit.get(stash.getType(), false, false));
        this.stashUnitImage = new JLabel(this.stashNotBuiltIcon);
        this.filled = true;
        String toolTipTextFormat = "Set stash unit as %s.";
        this.filledButton = new CycleButton(palette, new ImageIcon(EmoteClueItemsImages.Icons.CheckSquare.INCOMPLETE_EMPTY), () -> {
            if (Objects.nonNull(this.filledButton) && this.filledButton.isTurnedOn()) {
                onStashFillStatusChanged.accept(stash, false);
                super.setStatus(StatusPanel.Status.InComplete);
                super.setHeaderColor(null);
                this.filled = false;
            }
        }, DataGrid.getToolTipText("Set stash unit as %s.", "filled"));
        this.filledButtonInComplete = 0;
        this.filledButtonComplete = this.filledButton.addOption(new ImageIcon(EmoteClueItemsImages.Icons.CheckSquare.COMPLETE), () -> {
            if (this.filledButton.isTurnedOn()) {
                onStashFillStatusChanged.accept(stash, true);
                super.setStatus(StatusPanel.Status.Complete);
                this.filled = true;
            }
        }, DataGrid.getToolTipText("Set stash unit as %s.", "empty"));
        this.filledButton.setOpaque(false);
        this.mapLinkButton = new MapLinkButton(this.palette, () -> onAddStashUnitToMap.accept(this, this.built), onRemoveStashUnitFromMap);
        super.addLeft(this.filledButton, new Insets(0, 1, 0, 0), 10, 10, FoldablePanel.DisplayMode.All);
        EmoteClue[] emoteClues = EmoteClueAssociations.STASHUnitToEmoteClues.get((Object)stash);
        this.quantity = emoteClues.length;
        this.difficulties = (EmoteClueDifficulty[])Arrays.stream(emoteClues).map(EmoteClue::getEmoteClueDifficulty).distinct().toArray(EmoteClueDifficulty[]::new);
        Insets insets = new Insets(2, 0, 2, 5);
        Arrays.stream(this.difficulties).map(EmoteClueItemsImages.Icons.RuneScape.EmoteClue.Ribbon::get).map(ImageIcon::new).map(JLabel::new).forEach(label -> super.addRight((JLabel)label, insets, 0, 0, FoldablePanel.DisplayMode.Default));
        EmoteClueDifficulty difficulty = this.difficulties[0];
        this.requiredConstructionLevel = StashUnit.DifficultyRequirements.valueOf(difficulty.name()).getConstructionLvl();
        this.constructionLevelPanel = new PropertyPanel(this.palette, "Construction lvl", Integer.toString(this.requiredConstructionLevel));
        super.addRight(new JLabel(String.valueOf(this.quantity)), insets, 0, 0, FoldablePanel.DisplayMode.Default);
        super.addChild(this.getDetailsPanel(difficulty), FoldablePanel.DisplayMode.All);
    }

    public void setItemCollectionPanel(ItemCollectionPanel itemCollectionPanel, FoldablePanel.DisplayMode ... displayModes) {
        if (Objects.nonNull(this.itemCollectionPanel)) {
            super.removeChild(itemCollectionPanel, new FoldablePanel.DisplayMode[0]);
        }
        this.itemCollectionPanel = itemCollectionPanel;
        super.addChild(itemCollectionPanel, displayModes);
    }

    private JPanel getDetailsPanel(EmoteClueDifficulty difficulty) {
        JPanel detailsPanel = new JPanel(new GridBagLayout());
        Color backgroundColor = this.palette.getFoldContentColor();
        detailsPanel.setBackground(backgroundColor);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.insets.top = 5;
        c.insets.right = 5;
        StashUnit.DifficultyRequirements difficultyRequirements = StashUnit.DifficultyRequirements.valueOf(difficulty.name());
        ++c.gridy;
        detailsPanel.add((Component)new PropertyPanel(this.palette, "Difficulty", difficulty.name()), c);
        ++c.gridy;
        detailsPanel.add((Component)this.constructionLevelPanel, c);
        ++c.gridy;
        c.insets.top = 5;
        detailsPanel.add((Component)new DescriptionPanel(this.palette, "Build materials", difficultyRequirements.getConstructionItems()), c);
        c.gridy = 0;
        c.gridx = 1;
        c.gridheight = 4;
        detailsPanel.add((Component)this.getDetailsImagePanel(backgroundColor), c);
        return detailsPanel;
    }

    private JPanel getDetailsImagePanel(Color backgroundColor) {
        JPanel rightPanel = new JPanel(new GridBagLayout());
        rightPanel.setBackground(backgroundColor);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 1;
        rightPanel.add((Component)this.stashUnitImage, c);
        ++c.gridy;
        c.insets.left = 4;
        rightPanel.add((Component)this.mapLinkButton, c);
        return rightPanel;
    }

    public void turnOffFilledButton(Icon icon, String toolTip) {
        if (this.filledButton.isTurnedOn()) {
            this.filledButton.turnOff(icon, toolTip);
            super.setHeaderColor(this.palette.getFoldHeaderTextColor());
        }
    }

    public void turnOnFilledButton() {
        if (!this.filledButton.isTurnedOn()) {
            this.filledButton.turnOn();
            super.setHeaderColor(this.filled ? null : super.getStatus().colour);
        }
    }

    public void setBuilt(boolean built) {
        if (built) {
            this.turnOnFilledButton();
            this.stashUnitImage.setIcon(this.stashBuiltIcon);
        } else {
            this.turnOffFilledButton(new ImageIcon(EmoteClueItemsImages.Icons.CheckSquare.UNBUILT), "Please build the STASH unit in-game first.");
            this.stashUnitImage.setIcon(this.stashNotBuiltIcon);
        }
        this.built = built;
    }

    public void setFilled(boolean filled) {
        if (this.built) {
            this.filledButton.cycleToStage(filled ? this.filledButtonComplete : this.filledButtonInComplete);
            this.filled = filled;
        }
    }

    public void setMapLinkShowDelete(boolean showDelete) {
        this.mapLinkButton.setShowDelete(showDelete);
    }

    public void setPlayerConstructionLevel(Integer level) {
        StatusPanel.Status status = Objects.isNull(level) ? StatusPanel.Status.InComplete : (level < this.requiredConstructionLevel ? StatusPanel.Status.InProgress : StatusPanel.Status.Complete);
        this.constructionLevelPanel.setStatus(status);
    }

    public void turnOffMapLinkButton() {
        this.mapLinkButton.turnOff();
    }

    public void turnOnMapLinkButton() {
        this.mapLinkButton.turnOn();
    }

    public EmoteClueDifficulty[] getDifficulties() {
        return this.difficulties;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public boolean isFilled() {
        return this.filled;
    }

    public boolean isBuilt() {
        return this.built;
    }

    public ItemCollectionPanel getItemCollectionPanel() {
        return this.itemCollectionPanel;
    }
}

