/*
 * Decompiled with CFR 0.152.
 */
package com.larsvansoest.runelite.clueitems.ui.stashes;

import com.larsvansoest.runelite.clueitems.EmoteClueItemsImages;
import com.larsvansoest.runelite.clueitems.data.EmoteClueDifficulty;
import com.larsvansoest.runelite.clueitems.ui.EmoteClueItemsPalette;
import com.larsvansoest.runelite.clueitems.ui.components.DataGrid;
import com.larsvansoest.runelite.clueitems.ui.components.FoldablePanelGrid;
import com.larsvansoest.runelite.clueitems.ui.stashes.StashUnitPanel;
import java.awt.Component;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.ImageIcon;

public class StashUnitGrid
extends FoldablePanelGrid<StashUnitPanel> {
    public StashUnitGrid(EmoteClueItemsPalette palette) {
        super(palette, 25);
        this.createFilledFilterButton();
        this.createSortFilterButton();
        this.createDifficultyFilterButton(palette);
    }

    private void createFilledFilterButton() {
        String toolTipTextFormat = "Toggle show %s stashes.";
        super.addFilter("filled", new ImageIcon(EmoteClueItemsImages.Icons.CheckSquare.UNKNOWN), DataGrid.getToolTipText("Toggle show %s stashes.", "all"), $ -> true);
        super.addFilter("filled", new ImageIcon(EmoteClueItemsImages.Icons.CheckSquare.UNBUILT), DataGrid.getToolTipText("Toggle show %s stashes.", "not built"), stashUnitPanel -> !stashUnitPanel.isBuilt());
        super.addFilter("filled", new ImageIcon(EmoteClueItemsImages.Icons.CheckSquare.INCOMPLETE_EMPTY), DataGrid.getToolTipText("Toggle show %s stashes.", "empty"), stashUnitPanel -> stashUnitPanel.isBuilt() && !stashUnitPanel.isFilled());
        super.addFilter("filled", new ImageIcon(EmoteClueItemsImages.Icons.CheckSquare.COMPLETE), DataGrid.getToolTipText("Toggle show %s stashes.", "filled"), stashUnitPanel -> stashUnitPanel.isBuilt() && stashUnitPanel.isFilled());
    }

    private void createSortFilterButton() {
        super.addSort(new ImageIcon(EmoteClueItemsImages.Icons.SortType.QUANTITY_ASCENDING), DataGrid.getToolTipText("Toggle order by %s (descending).", "quantity"), Comparator.comparingInt(StashUnitPanel::getQuantity));
        super.addSort(new ImageIcon(EmoteClueItemsImages.Icons.SortType.QUANTITY_DESCENDING), DataGrid.getToolTipText("Toggle order by %s (ascending).", "quantity"), Comparator.comparingInt(StashUnitPanel::getQuantity).reversed());
        super.addSort(new ImageIcon(EmoteClueItemsImages.Icons.SortType.NAME_ASCENDING), DataGrid.getToolTipText("Toggle order by %s (ascending).", "name"), Comparator.comparing(Component::getName));
        super.addSort(new ImageIcon(EmoteClueItemsImages.Icons.SortType.NAME_DESCENDING), DataGrid.getToolTipText("Toggle order by %s (ascending).", "name"), Comparator.comparing(Component::getName).reversed());
    }

    private void createDifficultyFilterButton(EmoteClueItemsPalette palette) {
        String filterKey = "difficulty";
        String toolTipTextFormat = "Toggle show %s difficulties.";
        super.addFilter("difficulty", new ImageIcon(EmoteClueItemsImages.Icons.RuneScape.EmoteClue.Ribbon.ALL), DataGrid.getToolTipText("Toggle show %s difficulties.", "all"), $ -> true, palette.getBrandingColor());
        super.addFilter("difficulty", new ImageIcon(EmoteClueItemsImages.Icons.RuneScape.EmoteClue.Ribbon.BEGINNER), DataGrid.getToolTipText("Toggle show %s difficulties.", "beginner"), itemPanel -> Arrays.stream(itemPanel.getDifficulties()).anyMatch(difficulty -> difficulty == EmoteClueDifficulty.Beginner), EmoteClueDifficulty.Beginner.getColor());
        super.addFilter("difficulty", new ImageIcon(EmoteClueItemsImages.Icons.RuneScape.EmoteClue.Ribbon.EASY), DataGrid.getToolTipText("Toggle show %s difficulties.", "easy"), itemPanel -> Arrays.stream(itemPanel.getDifficulties()).anyMatch(difficulty -> difficulty == EmoteClueDifficulty.Easy), EmoteClueDifficulty.Easy.getColor());
        super.addFilter("difficulty", new ImageIcon(EmoteClueItemsImages.Icons.RuneScape.EmoteClue.Ribbon.MEDIUM), DataGrid.getToolTipText("Toggle show %s difficulties.", "medium"), itemPanel -> Arrays.stream(itemPanel.getDifficulties()).anyMatch(difficulty -> difficulty == EmoteClueDifficulty.Medium), EmoteClueDifficulty.Medium.getColor());
        super.addFilter("difficulty", new ImageIcon(EmoteClueItemsImages.Icons.RuneScape.EmoteClue.Ribbon.HARD), DataGrid.getToolTipText("Toggle show %s difficulties.", "hard"), itemPanel -> Arrays.stream(itemPanel.getDifficulties()).anyMatch(difficulty -> difficulty == EmoteClueDifficulty.Hard), EmoteClueDifficulty.Hard.getColor());
        super.addFilter("difficulty", new ImageIcon(EmoteClueItemsImages.Icons.RuneScape.EmoteClue.Ribbon.ELITE), DataGrid.getToolTipText("Toggle show %s difficulties.", "elite"), itemPanel -> Arrays.stream(itemPanel.getDifficulties()).anyMatch(difficulty -> difficulty == EmoteClueDifficulty.Elite), EmoteClueDifficulty.Elite.getColor());
        super.addFilter("difficulty", new ImageIcon(EmoteClueItemsImages.Icons.RuneScape.EmoteClue.Ribbon.MASTER), DataGrid.getToolTipText("Toggle show %s difficulties.", "master"), itemPanel -> Arrays.stream(itemPanel.getDifficulties()).anyMatch(difficulty -> difficulty == EmoteClueDifficulty.Master), EmoteClueDifficulty.Master.getColor());
    }
}

