/*
 * Decompiled with CFR 0.152.
 */
package com.larsvansoest.runelite.clueitems.ui.components;

import com.larsvansoest.runelite.clueitems.ui.EmoteClueItemsPalette;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.client.ui.components.shadowlabel.JShadowedLabel;

public class TabMenu
extends JPanel {
    private final GridBagConstraints c;
    private final EmoteClueItemsPalette palette;
    private JPanel activeButton;
    private JPanel activeContent;

    public TabMenu(EmoteClueItemsPalette palette, JPanel defaultContent, String defaultText, String defaultToolTipText) {
        this(palette, (JLabel)new JShadowedLabel(defaultText), defaultContent, defaultToolTipText);
    }

    public TabMenu(EmoteClueItemsPalette palette, JPanel defaultContent, Icon defaultIcon, String defaultToolTipText) {
        this(palette, new JLabel(defaultIcon), defaultContent, defaultToolTipText);
    }

    private TabMenu(EmoteClueItemsPalette palette, JLabel label, JPanel defaultContent, String defaultToolTipText) {
        super(new GridBagLayout());
        this.palette = palette;
        this.c = new GridBagConstraints();
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.weightx = 1.0;
        this.c.fill = 1;
        this.addTab(label, defaultContent, defaultToolTipText, true, 0);
    }

    public void addTab(JPanel content, String text, String toolTipText, boolean setActive, int ipadX) {
        JShadowedLabel label = new JShadowedLabel(text);
        this.addTab((JLabel)label, content, toolTipText, setActive, ipadX);
    }

    public void addTab(JPanel content, Icon icon, String toolTipText, boolean setActive, int ipadX) {
        JLabel label = new JLabel(icon);
        this.addTab(label, content, toolTipText, setActive, ipadX);
    }

    private void addTab(JLabel label, final JPanel content, String toolTipText, boolean setActive, int ipadX) {
        label.setHorizontalAlignment(0);
        final JPanel tab = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        tab.add((Component)label, c);
        tab.setToolTipText(toolTipText);
        tab.setBackground(this.palette.getDefaultColor());
        tab.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TabMenu.this.setActive(tab, content);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                tab.setBackground(TabMenu.this.palette.getHoverColor());
                if (tab != TabMenu.this.activeButton) {
                    TabMenu.this.activeButton.setBackground(TabMenu.this.palette.getDefaultColor());
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                tab.setBackground(TabMenu.this.activeButton == tab ? TabMenu.this.palette.getSelectColor() : TabMenu.this.palette.getDefaultColor());
                if (tab != TabMenu.this.activeButton) {
                    TabMenu.this.activeButton.setBackground(TabMenu.this.palette.getSelectColor());
                }
            }
        });
        this.c.ipadx = ipadX;
        super.add((Component)tab, this.c);
        ++this.c.gridx;
        if (setActive) {
            this.setActive(tab, content);
        } else {
            content.setVisible(false);
        }
        super.revalidate();
        super.repaint();
    }

    private void setActive(JPanel tabButton, JPanel tabContent) {
        if (tabButton != this.activeButton) {
            if (Objects.nonNull(this.activeButton)) {
                this.activeButton.setBackground(this.palette.getDefaultColor());
            }
            tabButton.setBackground(this.palette.getSelectColor());
            this.activeButton = tabButton;
        }
        if (tabContent != this.activeContent) {
            if (Objects.nonNull(this.activeContent)) {
                this.activeContent.setVisible(false);
            }
            tabContent.setVisible(true);
            this.activeContent = tabContent;
        }
    }
}

