/*
 * Decompiled with CFR 0.152.
 */
package com.larsvansoest.runelite.clueitems.ui.components;

import com.larsvansoest.runelite.clueitems.ui.EmoteClueItemsPalette;
import com.larsvansoest.runelite.clueitems.ui.components.StatusPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.components.shadowlabel.JShadowedLabel;

public class PropertyPanel
extends JPanel
implements StatusPanel {
    private final JLabel nameLabel;
    private final JLabel valueLabel;

    public PropertyPanel(EmoteClueItemsPalette palette, String name, String value) {
        super(new GridBagLayout());
        super.setBackground(palette.getFoldContentColor());
        this.nameLabel = new JShadowedLabel();
        this.setName(name);
        this.nameLabel.setFont(FontManager.getRunescapeSmallFont());
        this.nameLabel.setForeground(palette.getPropertyNameColor());
        this.nameLabel.setHorizontalAlignment(0);
        this.valueLabel = new JLabel();
        this.setValue(value);
        this.valueLabel.setFont(FontManager.getRunescapeSmallFont());
        this.valueLabel.setHorizontalAlignment(0);
        this.setStatus(StatusPanel.Status.InComplete);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets.left = 5;
        c.weightx = 0.0;
        c.fill = 1;
        super.add((Component)this.nameLabel, c);
        ++c.gridx;
        super.add((Component)this.valueLabel, c);
    }

    @Override
    public void setName(String name) {
        this.nameLabel.setText(String.format("%s:", name));
    }

    public void setValue(String value) {
        this.valueLabel.setText(value.toLowerCase());
    }

    @Override
    public void setStatus(StatusPanel.Status status) {
        this.valueLabel.setForeground(status.colour);
    }
}

