/*
 * Decompiled with CFR 0.152.
 */
package com.larsvansoest.runelite.clueitems.ui.components;

import com.larsvansoest.runelite.clueitems.EmoteClueItemsImages;
import com.larsvansoest.runelite.clueitems.ui.EmoteClueItemsPalette;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.ImageUtil;

public class MapLinkButton
extends JPanel {
    private static final String LABEL_TEXT = "mark map";
    private static final String LABEL_TEXT_DISABLE = "un-mark";
    private static final Icon PIN_ICON = new ImageIcon(EmoteClueItemsImages.Icons.Location.PIN);
    private static final Icon PIN_ICON_DISABLED = new ImageIcon(ImageUtil.grayscaleImage((BufferedImage)EmoteClueItemsImages.Icons.Location.PIN));
    private static final Icon PIN_DELETE_ICON = new ImageIcon(EmoteClueItemsImages.Icons.Location.PIN_DELETE);
    private static final Font LABEL_FONT = FontManager.getRunescapeSmallFont();
    private static final Font LABEL_FONT_UNDERLINED = MapLinkButton.getUnderLinedFont(LABEL_FONT);
    private final JLabel label;
    private final JLabel pinLabel;
    private boolean showDelete;
    private boolean disabled;

    public MapLinkButton(EmoteClueItemsPalette palette, final Runnable onClick, final Runnable onClickDelete) {
        super(new GridBagLayout());
        super.setBackground(palette.getFoldContentColor());
        final Color labelColor = palette.getPropertyValueColor();
        final Color labelHoverColor = palette.getPropertyNameColor();
        this.label = this.getMapLinkLabel(labelColor);
        this.pinLabel = new JLabel();
        this.setShowDelete(false);
        this.disabled = false;
        super.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!MapLinkButton.this.disabled) {
                    if (MapLinkButton.this.showDelete) {
                        onClickDelete.run();
                    } else {
                        onClick.run();
                    }
                    MapLinkButton.this.setShowDelete(!MapLinkButton.this.showDelete);
                }
                super.mousePressed(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!MapLinkButton.this.disabled) {
                    MapLinkButton.this.label.setForeground(labelHoverColor);
                    MapLinkButton.this.label.setFont(LABEL_FONT_UNDERLINED);
                }
                super.mouseEntered(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MapLinkButton.this.label.setForeground(labelColor);
                MapLinkButton.this.label.setFont(LABEL_FONT);
                super.mouseExited(e);
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.fill = 1;
        super.add((Component)this.pinLabel, c);
        c.weightx = 1.0;
        ++c.gridx;
        super.add((Component)this.label, c);
    }

    private static Font getUnderLinedFont(Font font) {
        Map<TextAttribute, ?> attributes = font.getAttributes();
        attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        return font.deriveFont(attributes);
    }

    private JLabel getMapLinkLabel(Color textColor) {
        JLabel label = new JLabel();
        label.setText(LABEL_TEXT);
        label.setHorizontalAlignment(0);
        label.setVerticalAlignment(0);
        label.setFont(LABEL_FONT);
        label.setForeground(textColor);
        return label;
    }

    public void setShowDelete(boolean show) {
        this.showDelete = show;
        this.pinLabel.setIcon(show ? PIN_DELETE_ICON : PIN_ICON);
        this.label.setText(show ? LABEL_TEXT_DISABLE : LABEL_TEXT);
    }

    public void turnOff() {
        if (!this.disabled) {
            this.disabled = true;
            this.pinLabel.setIcon(PIN_ICON_DISABLED);
        }
    }

    public void turnOn() {
        if (this.disabled) {
            this.disabled = false;
            this.setShowDelete(this.showDelete);
        }
    }
}

