/*
 * Decompiled with CFR 0.152.
 */
package com.larsvansoest.runelite.clueitems.ui.components;

import java.awt.Font;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import net.runelite.client.ui.components.shadowlabel.JShadowedLabel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;

public class LinkButton
extends JShadowedLabel {
    public LinkButton(Image image, String url, String tooltip) {
        this(image, url, tooltip, 2.0f);
    }

    public LinkButton(Image image, final String url, String tooltip, float luminancePercentage) {
        final ImageIcon icon = new ImageIcon(image);
        final ImageIcon illuminatedIcon = new ImageIcon(ImageUtil.luminanceScale((Image)image, (float)luminancePercentage));
        super.setToolTipText(tooltip);
        super.setIcon((Icon)icon);
        super.setHorizontalAlignment(0);
        super.setVerticalAlignment(0);
        super.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                LinkBrowser.browse((String)url);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                LinkButton.super.setIcon(illuminatedIcon);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LinkButton.super.setIcon(icon);
            }
        });
    }

    public LinkButton(String text, final String url, String tooltip, final Font font) {
        super.setText(text);
        super.setToolTipText(tooltip);
        Map<TextAttribute, ?> attributes = LinkButton.super.getFont().getAttributes();
        attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        final Font underlinedFont = font.deriveFont(attributes);
        super.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                LinkBrowser.browse((String)url);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                LinkButton.super.setFont(underlinedFont);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LinkButton.super.setFont(font);
            }
        });
    }
}

