/*
 * Decompiled with CFR 0.152.
 */
package com.larsvansoest.runelite.clueitems.ui.components;

import com.larsvansoest.runelite.clueitems.ui.components.StatusPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.client.game.ItemManager;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ImageUtil;

public class ItemSlotPanel
extends JPanel
implements StatusPanel {
    private final ItemManager itemManager;
    private final int itemId;
    private final JLabel itemIcon;
    private StatusPanel.Status status;
    private ImageIcon transparentIcon;
    private int quantity;

    public ItemSlotPanel(ItemManager itemManager, int itemId, String name) {
        super.setLayout(new GridBagLayout());
        super.setToolTipText(name);
        this.itemManager = itemManager;
        this.itemId = itemId;
        this.itemIcon = new JLabel();
        this.itemIcon.setOpaque(false);
        this.transparentIcon = new ImageIcon();
        AsyncBufferedImage itemImage = itemManager.getImage(this.itemId, 0, true);
        itemImage.onLoaded(() -> {
            this.transparentIcon = new ImageIcon(ImageUtil.alphaOffset((Image)itemImage, (float)0.38f));
            this.itemIcon.setIcon(this.transparentIcon);
        });
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        super.add((Component)this.itemIcon, c);
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
        this.setStatus(quantity > 0 ? StatusPanel.Status.Complete : StatusPanel.Status.InComplete);
    }

    @Override
    public void setStatus(StatusPanel.Status status) {
        this.itemIcon.setIcon(status == StatusPanel.Status.Complete ? new ImageIcon((Image)this.itemManager.getImage(this.itemId, this.quantity, true)) : this.transparentIcon);
        this.status = status;
    }

    public StatusPanel.Status getStatus() {
        return this.status;
    }
}

