/*
 * Decompiled with CFR 0.152.
 */
package com.larsvansoest.runelite.clueitems.ui.components;

import com.larsvansoest.runelite.clueitems.EmoteClueItemsImages;
import com.larsvansoest.runelite.clueitems.ui.EmoteClueItemsPalette;
import com.larsvansoest.runelite.clueitems.ui.components.FoldablePanel;
import com.larsvansoest.runelite.clueitems.ui.components.ItemSlotPanel;
import com.larsvansoest.runelite.clueitems.ui.components.RequirementPanel;
import com.larsvansoest.runelite.clueitems.ui.components.StatusPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ItemCollectionPanel
extends RequirementPanel {
    private final int slotRowSize;
    private final ArrayList<ItemSlotPanel> itemSlots;
    private final JPanel itemsPanel;
    private final Color itemSlotBackGround;

    public ItemCollectionPanel(EmoteClueItemsPalette palette, String name, int slotRowSize) {
        super(palette, name, 160, 20);
        super.setStatus(StatusPanel.Status.InComplete);
        super.addLeft(new JLabel(new ImageIcon(EmoteClueItemsImages.Icons.RuneScape.INVENTORY)), new Insets(2, 4, 2, 0), 0, 0, FoldablePanel.DisplayMode.All);
        this.itemSlotBackGround = palette.getFoldContentColor();
        this.itemsPanel = new JPanel(new GridBagLayout());
        this.itemsPanel.setBackground(this.itemSlotBackGround);
        super.setFoldContentLeftInset(0);
        super.setFoldContentRightInset(0);
        super.setFixedFoldContentTopInset(1);
        super.addChild(this.itemsPanel, FoldablePanel.DisplayMode.All);
        this.slotRowSize = slotRowSize;
        this.itemSlots = new ArrayList();
    }

    @Override
    public void fold() {
        this.itemSlots.forEach(this.itemsPanel::remove);
        super.fold();
    }

    @Override
    public void unfold() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        int i = 0;
        while (i < this.itemSlots.size()) {
            this.itemsPanel.add((Component)this.itemSlots.get(i), c);
            int x = ++i % this.slotRowSize;
            if (x == 0) {
                ++c.gridy;
            }
            c.gridx = x;
        }
        super.unfold();
    }

    public void addItem(ItemSlotPanel itemSlotPanel) {
        if (!this.itemSlots.contains(itemSlotPanel)) {
            itemSlotPanel.setBackground(this.itemSlotBackGround);
            this.itemSlots.add(itemSlotPanel);
        }
    }
}

