/*
 * Decompiled with CFR 0.152.
 */
package com.larsvansoest.runelite.clueitems.ui.components;

import com.larsvansoest.runelite.clueitems.ui.EmoteClueItemsPalette;
import com.larsvansoest.runelite.clueitems.ui.components.DataGrid;
import com.larsvansoest.runelite.clueitems.ui.components.FoldablePanel;
import java.util.Collection;
import java.util.Objects;

public class FoldablePanelGrid<T extends FoldablePanel>
extends DataGrid<T> {
    private FoldablePanel unfoldedPanel;

    public FoldablePanelGrid(EmoteClueItemsPalette palette, int minSearchBarHeight) {
        super(palette, minSearchBarHeight);
    }

    @Override
    public void load(Collection<T> entries) {
        this.unfoldedPanel = null;
        for (FoldablePanel entry : entries) {
            entry.setDisplayMode(FoldablePanel.DisplayMode.Default);
            entry.setOnHeaderMousePressed(() -> {
                if (entry.getExpanded().booleanValue()) {
                    entry.fold();
                    this.unfoldedPanel = null;
                } else {
                    if (Objects.nonNull(this.unfoldedPanel)) {
                        this.unfoldedPanel.fold();
                    }
                    entry.unfold();
                    this.unfoldedPanel = entry;
                }
            });
        }
        super.load(entries);
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible) {
            for (FoldablePanel entry : this.entries) {
                entry.fold();
            }
        } else {
            for (FoldablePanel entry : this.entries) {
                entry.setDisplayMode(FoldablePanel.DisplayMode.Default);
            }
        }
        super.setVisible(visible);
    }

    @Override
    public void reset() {
        for (FoldablePanel entry : this.entries) {
            entry.fold();
        }
        super.reset();
    }
}

