/*
 * Decompiled with CFR 0.152.
 */
package com.larsvansoest.runelite.clueitems.ui.components;

import com.larsvansoest.runelite.clueitems.EmoteClueItemsImages;
import com.larsvansoest.runelite.clueitems.ui.EmoteClueItemsPalette;
import com.larsvansoest.runelite.clueitems.ui.components.CycleButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.stream.Stream;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.components.shadowlabel.JShadowedLabel;

public class FoldablePanel
extends JPanel {
    private final EmoteClueItemsPalette emoteClueItemsPalette;
    private final JLabel foldIcon;
    private final JShadowedLabel statusHeaderName;
    private final JPanel foldContentDisplay;
    private final JPanel header;
    private final HashMap<DisplayMode, ArrayList<HeaderElement>> leftHeaderElements;
    private final HashMap<DisplayMode, ArrayList<HeaderElement>> rightHeaderElements;
    private final HashMap<DisplayMode, ArrayList<FoldablePanel>> foldContentPanels;
    private final HashMap<DisplayMode, ArrayList<JComponent>> foldContent;
    private DisplayMode displayMode;
    private int foldContentLeftInset;
    private int foldContentRightInset;
    private int foldContentBottomInset;
    private Integer fixedFoldContentTopInset;
    private Runnable onHeaderMousePressed;
    private Boolean expanded;

    public FoldablePanel(EmoteClueItemsPalette emoteClueItemsPalette, String name, int headerNameWidth, int headerMinHeight) {
        super.setLayout(new GridBagLayout());
        super.setBackground(emoteClueItemsPalette.getDefaultColor());
        super.setName(name);
        this.expanded = false;
        this.displayMode = DisplayMode.Default;
        this.emoteClueItemsPalette = emoteClueItemsPalette;
        this.foldContentDisplay = new JPanel(new GridBagLayout());
        this.foldContentDisplay.setBackground(emoteClueItemsPalette.getFoldContentColor());
        this.leftHeaderElements = this.newDisplayModeMap();
        this.rightHeaderElements = this.newDisplayModeMap();
        this.foldContentPanels = this.newDisplayModeMap();
        this.foldContent = this.newDisplayModeMap();
        this.foldIcon = new JLabel(FOLD_ICONS.LEFT);
        this.statusHeaderName = this.getHeaderText(name, headerNameWidth, headerMinHeight);
        this.header = this.getHeader();
        this.paintHeaderLabels();
        this.onHeaderMousePressed = () -> {
            if (this.expanded.booleanValue()) {
                this.fold();
            } else {
                this.unfold();
            }
        };
        this.foldContentLeftInset = 5;
        this.foldContentRightInset = 5;
        this.foldContentBottomInset = 5;
        this.fixedFoldContentTopInset = null;
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        super.add((Component)this.header, c);
        ++c.gridy;
        super.add((Component)this.foldContentDisplay, c);
    }

    private JPanel getHeader() {
        final JPanel header = new JPanel(new GridBagLayout());
        header.setBackground(this.emoteClueItemsPalette.getDefaultColor());
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                FoldablePanel.this.onHeaderMousePressed.run();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                header.setBackground(FoldablePanel.this.emoteClueItemsPalette.getHoverColor());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                header.setBackground(FoldablePanel.this.expanded != false ? FoldablePanel.this.emoteClueItemsPalette.getSelectColor() : FoldablePanel.this.emoteClueItemsPalette.getDefaultColor());
            }
        });
        return header;
    }

    public void addChild(FoldablePanel child, DisplayMode ... displayModes) {
        this.addDisplayModeComponents(this.foldContentPanels, child, displayModes);
    }

    public void addChild(JComponent child, DisplayMode ... displayModes) {
        this.addDisplayModeComponents(this.foldContent, child, displayModes);
    }

    public void removeChild(FoldablePanel child, DisplayMode ... displayModes) {
        this.removeDisplayModeComponents(this.foldContentPanels, child, displayModes);
    }

    public void removeChild(JComponent child, DisplayMode ... displayModes) {
        this.removeDisplayModeComponents(this.foldContent, child, displayModes);
    }

    public void fold() {
        this.getDisplayModeComponents(this.foldContentPanels).forEach(FoldablePanel::fold);
        this.foldContentDisplay.removeAll();
        this.foldContentDisplay.setVisible(false);
        this.foldContentDisplay.revalidate();
        this.foldContentDisplay.repaint();
        this.header.setBackground(this.emoteClueItemsPalette.getDefaultColor());
        this.expanded = false;
        this.foldIcon.setIcon(FOLD_ICONS.LEFT);
    }

    public void unfold() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.insets = new Insets(0, this.foldContentLeftInset, this.foldContentBottomInset, this.foldContentRightInset);
        c.gridx = 0;
        c.gridy = 0;
        this.getDisplayModeComponents(this.foldContent).forEach(foldContentElement -> {
            c.insets.top = Objects.nonNull(this.fixedFoldContentTopInset) ? this.fixedFoldContentTopInset : (c.gridy == 0 ? 5 : 0);
            this.foldContentDisplay.add((Component)foldContentElement, c);
            ++c.gridy;
        });
        this.getDisplayModeComponents(this.foldContentPanels).forEach(foldablePanel -> {
            c.insets.top = Objects.nonNull(this.fixedFoldContentTopInset) ? this.fixedFoldContentTopInset : (c.gridy == 0 ? 5 : 0);
            foldablePanel.setDisplayMode(DisplayMode.Nested);
            this.foldContentDisplay.add((Component)foldablePanel, c);
            ++c.gridy;
        });
        this.header.setBackground(this.emoteClueItemsPalette.getSelectColor());
        this.foldContentDisplay.setVisible(true);
        this.foldIcon.setIcon(FOLD_ICONS.DOWN);
        this.expanded = true;
        this.foldContentDisplay.revalidate();
        this.foldContentDisplay.repaint();
    }

    public Color getHeaderColor() {
        return this.statusHeaderName.getForeground();
    }

    public void setHeaderColor(Color colour) {
        this.statusHeaderName.setForeground(colour);
    }

    public void setDisplayMode(DisplayMode displayMode) {
        this.displayMode = displayMode;
        this.paintHeaderLabels();
    }

    private <T> HashMap<DisplayMode, ArrayList<T>> newDisplayModeMap() {
        HashMap<DisplayMode, ArrayList<T>> displayModeMap = new HashMap<DisplayMode, ArrayList<T>>();
        for (DisplayMode displayMode : DisplayMode.values()) {
            if (displayMode.equals((Object)DisplayMode.All)) continue;
            displayModeMap.put(displayMode, new ArrayList());
        }
        return displayModeMap;
    }

    private <T> void addDisplayModeComponents(HashMap<DisplayMode, ArrayList<T>> map, T component, DisplayMode ... displayModes) {
        if (displayModes.length == 0) {
            this.addDisplayModeComponent(map, component, DisplayMode.Default);
        } else if (Arrays.asList(displayModes).contains((Object)DisplayMode.All)) {
            for (DisplayMode displayMode : DisplayMode.values()) {
                if (displayMode.equals((Object)DisplayMode.All)) continue;
                this.addDisplayModeComponent(map, component, displayMode);
            }
        } else {
            for (DisplayMode displayMode : displayModes) {
                this.addDisplayModeComponent(map, component, displayMode);
            }
        }
    }

    private <T> void removeDisplayModeComponents(HashMap<DisplayMode, ArrayList<T>> map, T component, DisplayMode ... displayModes) {
        if (displayModes.length == 0 || Arrays.asList(displayModes).contains((Object)DisplayMode.All)) {
            for (DisplayMode displayMode : DisplayMode.values()) {
                if (displayMode.equals((Object)DisplayMode.All)) continue;
                this.removeDisplayModeComponent(map, component, displayMode);
            }
        } else {
            for (DisplayMode displayMode : displayModes) {
                this.removeDisplayModeComponent(map, component, displayMode);
            }
        }
    }

    private <T> void removeDisplayModeComponent(HashMap<DisplayMode, ArrayList<T>> map, T component, DisplayMode displayMode) {
        ArrayList<T> list = map.get((Object)displayMode);
        list.remove(component);
        map.put(displayMode, list);
    }

    private <T> void addDisplayModeComponent(HashMap<DisplayMode, ArrayList<T>> map, T component, DisplayMode displayMode) {
        ArrayList<T> list = map.get((Object)displayMode);
        list.add(component);
        map.put(displayMode, list);
    }

    private <T> Stream<T> getDisplayModeComponents(HashMap<DisplayMode, ArrayList<T>> map) {
        if (this.displayMode.equals((Object)DisplayMode.All)) {
            return Arrays.stream(DisplayMode.values()).filter(displayMode -> !displayMode.equals((Object)DisplayMode.All)).map(map::get).flatMap(Collection::stream).distinct();
        }
        return map.get((Object)this.displayMode).stream();
    }

    public final void addRight(CycleButton cycleButton, Insets insets, int ipadX, int ipadY, DisplayMode ... displayModes) {
        this.addDisplayModeComponents(this.rightHeaderElements, new HeaderElement(cycleButton, insets, ipadX, ipadY), displayModes);
        this.paintHeaderLabels();
    }

    public final void addRight(JLabel iconLabel, Insets insets, int ipadX, int ipadY, DisplayMode ... displayModes) {
        this.addDisplayModeComponents(this.rightHeaderElements, new HeaderElement(iconLabel, insets, ipadX, ipadY), displayModes);
        this.paintHeaderLabels();
    }

    public final void addLeft(CycleButton cycleButton, Insets insets, int ipadX, int ipadY, DisplayMode ... displayModes) {
        this.addDisplayModeComponents(this.leftHeaderElements, new HeaderElement(cycleButton, insets, ipadX, ipadY), displayModes);
        this.paintHeaderLabels();
    }

    public final void addLeft(JLabel iconLabel, Insets insets, int ipadX, int ipadY, DisplayMode ... displayModes) {
        this.addDisplayModeComponents(this.leftHeaderElements, new HeaderElement(iconLabel, insets, ipadX, ipadY), displayModes);
        this.paintHeaderLabels();
    }

    private void paintHeaderLabels() {
        this.header.removeAll();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        this.addHeaderElements(this.getDisplayModeComponents(this.leftHeaderElements), c);
        this.header.add((Component)this.statusHeaderName, c);
        c.weightx = 1.0;
        ++c.gridx;
        this.header.add((Component)new JLabel(), c);
        c.weightx = 0.0;
        ++c.gridx;
        this.addHeaderElements(this.getDisplayModeComponents(this.rightHeaderElements), c);
        c.insets.right = 4;
        this.header.add((Component)this.foldIcon, c);
        super.revalidate();
        super.repaint();
    }

    private void addHeaderElements(Stream<HeaderElement> headerElements, GridBagConstraints c) {
        Insets previousInsets = c.insets;
        int previousIpadX = c.ipadx;
        int previousIpadY = c.ipady;
        headerElements.forEach(headerElement -> {
            c.insets = headerElement.getInsets();
            c.ipadx = headerElement.getIpadX();
            c.ipady = headerElement.getIpadY();
            this.header.add((Component)headerElement.getElement(), c);
            ++c.gridx;
        });
        c.insets = previousInsets;
        c.ipadx = previousIpadX;
        c.ipady = previousIpadY;
    }

    private JShadowedLabel getHeaderText(String text, int fixedNameWidth, int fixedHeight) {
        JShadowedLabel label = new JShadowedLabel(text);
        Dimension size = new Dimension(fixedNameWidth, fixedHeight);
        label.setMinimumSize(size);
        label.setPreferredSize(size);
        label.setMaximumSize(size);
        label.setFont(FontManager.getRunescapeSmallFont());
        label.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        label.setHorizontalAlignment(0);
        return label;
    }

    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public void setFoldContentLeftInset(int foldContentLeftInset) {
        this.foldContentLeftInset = foldContentLeftInset;
    }

    public int getFoldContentLeftInset() {
        return this.foldContentLeftInset;
    }

    public void setFoldContentRightInset(int foldContentRightInset) {
        this.foldContentRightInset = foldContentRightInset;
    }

    public int getFoldContentRightInset() {
        return this.foldContentRightInset;
    }

    public void setFoldContentBottomInset(int foldContentBottomInset) {
        this.foldContentBottomInset = foldContentBottomInset;
    }

    public int getFoldContentBottomInset() {
        return this.foldContentBottomInset;
    }

    public void setFixedFoldContentTopInset(Integer fixedFoldContentTopInset) {
        this.fixedFoldContentTopInset = fixedFoldContentTopInset;
    }

    public Integer getFixedFoldContentTopInset() {
        return this.fixedFoldContentTopInset;
    }

    public void setOnHeaderMousePressed(Runnable onHeaderMousePressed) {
        this.onHeaderMousePressed = onHeaderMousePressed;
    }

    public Runnable getOnHeaderMousePressed() {
        return this.onHeaderMousePressed;
    }

    public Boolean getExpanded() {
        return this.expanded;
    }

    private static class HeaderElement {
        private final JComponent element;
        private final Insets insets;
        private final int ipadX;
        private final int ipadY;

        public JComponent getElement() {
            return this.element;
        }

        public Insets getInsets() {
            return this.insets;
        }

        public int getIpadX() {
            return this.ipadX;
        }

        public int getIpadY() {
            return this.ipadY;
        }

        public HeaderElement(JComponent element, Insets insets, int ipadX, int ipadY) {
            this.element = element;
            this.insets = insets;
            this.ipadX = ipadX;
            this.ipadY = ipadY;
        }
    }

    private static final class FOLD_ICONS {
        static final ImageIcon DOWN = new ImageIcon(EmoteClueItemsImages.Icons.Chevron.DOWN);
        static final ImageIcon LEFT = new ImageIcon(EmoteClueItemsImages.Icons.Chevron.LEFT);

        private FOLD_ICONS() {
        }
    }

    public static enum DisplayMode {
        All,
        Default,
        Nested;

    }
}

