/*
 * Decompiled with CFR 0.152.
 */
package com.larsvansoest.runelite.clueitems.ui.components;

import com.larsvansoest.runelite.clueitems.EmoteClueItemsImages;
import com.larsvansoest.runelite.clueitems.ui.EmoteClueItemsPalette;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.components.shadowlabel.JShadowedLabel;
import net.runelite.client.util.ImageUtil;

public class DisclaimerPanel
extends JPanel {
    private final JLabel textLabel;
    private Runnable onClose;

    public DisclaimerPanel(EmoteClueItemsPalette emoteClueItemsPalette, Runnable onClose) {
        super(new GridBagLayout());
        super.setBackground(emoteClueItemsPalette.getDisclaimerColor());
        JLabel questionCircleIconLabel = new JLabel(new ImageIcon(EmoteClueItemsImages.Icons.QUESTION));
        this.textLabel = new JShadowedLabel();
        this.textLabel.setHorizontalAlignment(2);
        this.textLabel.setVerticalAlignment(0);
        this.textLabel.setFont(FontManager.getRunescapeSmallFont());
        this.onClose = onClose;
        final ImageIcon closeIllumatedIcon = new ImageIcon(ImageUtil.luminanceScale((Image)EmoteClueItemsImages.Icons.CLOSE, (float)150.0f));
        final ImageIcon closeIcon = new ImageIcon(EmoteClueItemsImages.Icons.CLOSE);
        final JLabel closeIconLabel = new JLabel(closeIcon);
        closeIconLabel.setToolTipText("Close");
        closeIconLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DisclaimerPanel.this.onClose.run();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                closeIconLabel.setIcon(closeIllumatedIcon);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                closeIconLabel.setIcon(closeIcon);
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.anchor = 17;
        c.insets = new Insets(5, 10, 5, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        super.add((Component)questionCircleIconLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.weighty = 1.0;
        super.add((Component)this.textLabel, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets.right = 10;
        super.add((Component)closeIconLabel, c);
    }

    public void setText(String text) {
        this.textLabel.setText(String.format("<html><p style=\"width:100%%\">%s</p></html>", text));
    }

    public void setOnClose(Runnable onClose) {
        this.onClose = onClose;
    }
}

