/*
 * Decompiled with CFR 0.152.
 */
package com.larsvansoest.runelite.clueitems.ui.components;

import com.larsvansoest.runelite.clueitems.ui.EmoteClueItemsPalette;
import com.larsvansoest.runelite.clueitems.ui.components.CycleButton;
import com.larsvansoest.runelite.clueitems.ui.components.DisclaimerPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.runelite.client.input.KeyListener;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.components.IconTextField;

public class DataGrid<T extends JPanel>
extends JPanel {
    protected final List<T> entries = new ArrayList<T>();
    private final IconTextField searchBar;
    private final Map<String, CycleButton> filterButtons;
    private final Map<String, Predicate<T>> filters;
    private final EmoteClueItemsPalette palette;
    private final DisclaimerPanel disclaimerPanel;
    private final JSeparator separator;
    private final JPanel entryList;
    private Comparator<T> sort;
    private CycleButton sortButton;

    public DataGrid(EmoteClueItemsPalette palette, int minSearchBarHeight) {
        super(new GridBagLayout());
        this.palette = palette;
        this.searchBar = this.getSearchBar(minSearchBarHeight);
        this.filterButtons = new HashMap<String, CycleButton>();
        this.filters = new HashMap<String, Predicate<T>>();
        this.sort = Comparator.comparing(Object::hashCode);
        this.sortButton = null;
        this.filters.put("_searchBar", panel -> panel.getName().toLowerCase().contains(this.searchBar.getText().toLowerCase()));
        this.separator = new JSeparator(0);
        Dimension separatorSize = new Dimension(this.separator.getWidth(), 1);
        this.separator.setMinimumSize(separatorSize);
        this.separator.setPreferredSize(separatorSize);
        this.separator.setMaximumSize(separatorSize);
        this.setSeparatorColor(palette.getBrandingColor());
        this.disclaimerPanel = new DisclaimerPanel(palette, this::removeDisclaimer);
        this.disclaimerPanel.setVisible(false);
        this.entryList = new JPanel(new GridBagLayout());
        this.reset();
    }

    public static String getToolTipText(String format, String keyword) {
        return String.format("<html>%s</html>", String.format(format, String.format("<b>%s</b>", keyword)));
    }

    public void reset() {
        this.filterButtons.values().forEach(CycleButton::reset);
        if (Objects.nonNull(this.sortButton)) {
            this.sortButton.reset();
        }
        this.paint();
    }

    private void paint() {
        super.removeAll();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        super.add((Component)this.searchBar, c);
        c.weightx = 0.0;
        c.ipadx = 10;
        c.ipady = 10;
        if (Objects.nonNull(this.sortButton)) {
            ++c.gridx;
            super.add((Component)this.sortButton, c);
        }
        for (CycleButton filterButton : this.filterButtons.values()) {
            ++c.gridx;
            super.add((Component)filterButton, c);
        }
        c.ipadx = 0;
        c.ipady = 0;
        c.gridwidth = this.filterButtons.size() + 1 + (Objects.nonNull(this.sortButton) ? 1 : 0);
        c.gridx = 0;
        c.weightx = 1.0;
        ++c.gridy;
        super.add((Component)this.separator, c);
        ++c.gridy;
        super.add((Component)this.disclaimerPanel, c);
        ++c.gridy;
        super.add((Component)this.entryList, c);
        this.query();
    }

    public final void query() {
        this.entryList.removeAll();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.gridy = 0;
        c.gridx = 0;
        this.entries.stream().sorted(this.sort).filter(e -> this.filters.values().stream().allMatch(p -> p.test(e))).forEach(entry -> {
            this.entryList.add((Component)entry, c);
            ++c.gridy;
        });
        super.revalidate();
        super.repaint();
    }

    public void addSort(Icon icon, String toolTip, Comparator<T> sort) {
        Runnable onSelect = () -> {
            this.sort = sort;
            this.query();
        };
        if (Objects.isNull(this.sortButton)) {
            this.sortButton = new CycleButton(this.palette, icon, onSelect, toolTip);
        } else {
            this.sortButton.addOption(icon, onSelect, toolTip);
        }
        this.paint();
    }

    public void addFilter(String key, Icon icon, String toolTip, Predicate<T> predicate, Color separatorColor) {
        Runnable onSelect = () -> {
            this.filters.put(key, predicate);
            if (Objects.nonNull(separatorColor)) {
                this.setSeparatorColor(separatorColor);
            }
            this.query();
        };
        if (this.filters.containsKey(key)) {
            CycleButton filterButton = this.filterButtons.get(key);
            filterButton.addOption(icon, onSelect, toolTip);
        } else {
            CycleButton filterButton = new CycleButton(this.palette, icon, onSelect, toolTip);
            this.filterButtons.put(key, filterButton);
        }
        this.paint();
    }

    public void addFilter(String key, Icon icon, String toolTip, Predicate<T> predicate) {
        this.addFilter(key, icon, toolTip, predicate, null);
    }

    private IconTextField getSearchBar(int minSearchBarHeight) {
        IconTextField searchBar = new IconTextField();
        searchBar.setIcon(IconTextField.Icon.SEARCH);
        searchBar.setBackground(this.palette.getDefaultColor());
        searchBar.setHoverBackgroundColor(this.palette.getHoverColor());
        searchBar.setFont(FontManager.getRunescapeSmallFont());
        Dimension size = new Dimension(searchBar.getWidth(), minSearchBarHeight);
        searchBar.setMinimumSize(size);
        searchBar.setPreferredSize(size);
        searchBar.addKeyListener((java.awt.event.KeyListener)new KeyListener(){

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                DataGrid.this.query();
            }
        });
        searchBar.addClearListener(this::query);
        return searchBar;
    }

    public void load(Collection<T> entries) {
        this.entries.clear();
        this.entries.addAll(entries);
        this.query();
    }

    public void setDisclaimer(String text, Runnable onClose) {
        this.disclaimerPanel.setText(text);
        this.disclaimerPanel.setVisible(true);
        this.disclaimerPanel.setOnClose(() -> {
            if (Objects.nonNull(onClose)) {
                onClose.run();
            }
            this.removeDisclaimer();
        });
    }

    public void setSeparatorColor(Color color) {
        this.separator.setBackground(color);
    }

    public void removeDisclaimer() {
        this.disclaimerPanel.setVisible(false);
    }
}

