/*
 * Decompiled with CFR 0.152.
 */
package com.larsvansoest.runelite.clueitems.ui.components;

import com.larsvansoest.runelite.clueitems.ui.EmoteClueItemsPalette;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Queue;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import lombok.NonNull;

public class CycleButton
extends JPanel {
    private final JLabel optionLabel;
    private final Queue<Stage> stageQueue;
    private final String defaultToolTip;
    private Stage currentStage;
    private Icon currentValue;
    private int minWidth;
    private int minHeight;
    private boolean turnedOn;
    private String toolTipBeforeDisabled;
    private Icon iconBeforeDisabled;
    private int stageCount;

    public CycleButton(EmoteClueItemsPalette emoteClueItemsPalette, Icon primary, Runnable onSelectPrimary, String defaultToolTip) {
        this(emoteClueItemsPalette, primary, onSelectPrimary, null, null, defaultToolTip);
    }

    public CycleButton(final EmoteClueItemsPalette emoteClueItemsPalette, Icon primary, Runnable onSelectPrimary, Icon secondary, Runnable onSelectSecondary, String defaultToolTip) {
        super(new GridBagLayout());
        super.setBackground(emoteClueItemsPalette.getDefaultColor());
        super.setToolTipText(defaultToolTip);
        super.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (CycleButton.this.turnedOn) {
                    CycleButton.this.next(e.getButton() == 1);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (CycleButton.this.turnedOn) {
                    CycleButton.super.setBackground(emoteClueItemsPalette.getHoverColor());
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                CycleButton.super.setBackground(emoteClueItemsPalette.getDefaultColor());
            }
        });
        this.stageCount = 0;
        this.optionLabel = new JLabel();
        this.optionLabel.setHorizontalAlignment(0);
        this.optionLabel.setVerticalAlignment(0);
        this.optionLabel.setIcon(primary);
        this.minWidth = primary.getIconWidth();
        this.minHeight = primary.getIconHeight();
        Dimension size = new Dimension(this.minWidth, this.minHeight);
        super.setMinimumSize(size);
        super.setPreferredSize(size);
        this.stageQueue = new ArrayDeque<Stage>();
        this.defaultToolTip = defaultToolTip;
        this.currentStage = new Stage(primary, onSelectPrimary, secondary, onSelectSecondary, defaultToolTip, this.stageCount++);
        this.currentValue = primary;
        onSelectPrimary.run();
        this.turnedOn = true;
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        super.add((Component)this.optionLabel, c);
    }

    public void reset() {
        this.cycleToStage(0);
    }

    public void cycleToStage(int id) {
        int initialId = this.currentStage.id;
        while (this.currentStage.id != id) {
            this.next(true);
            if (this.currentStage.id != initialId) continue;
            break;
        }
    }

    private void next(Boolean isPrimaryMouseKey) {
        Runnable runnable;
        Stage stage;
        if (isPrimaryMouseKey.booleanValue() || Objects.isNull(this.currentStage.getSecondary())) {
            stage = Objects.requireNonNull(this.stageQueue.poll());
            this.stageQueue.add(this.currentStage);
            if (stage == this.currentStage) {
                return;
            }
            this.currentStage = stage;
            this.currentValue = stage.getPrimary();
            this.optionLabel.setIcon(stage.getPrimary());
            runnable = stage.getOnSelectPrimary();
        } else {
            stage = this.currentStage;
            boolean isPrimaryValue = stage.primary == this.currentValue;
            this.currentValue = isPrimaryValue ? this.currentStage.getSecondary() : this.currentStage.getPrimary();
            this.optionLabel.setIcon(isPrimaryValue ? this.currentStage.getSecondary() : this.currentStage.getPrimary());
            runnable = isPrimaryValue ? stage.getOnSelectSecondary() : stage.getOnSelectPrimary();
        }
        String toolTip = stage.getToolTip();
        super.setToolTipText(toolTip == null ? this.defaultToolTip : toolTip);
        runnable.run();
    }

    public int addOption(Icon icon, Runnable onSelect, String toolTip) {
        return this.addOption(icon, onSelect, null, null, toolTip);
    }

    public int addOption(Icon primary, Runnable onSelectPrimary, Icon secondary, Runnable onSelectSecondary, String toolTip) {
        int stageId = this.stageCount++;
        this.stageQueue.add(new Stage(primary, onSelectPrimary, secondary, onSelectSecondary, toolTip, stageId));
        this.minWidth = Math.max(this.minWidth, primary.getIconWidth());
        this.minHeight = Math.max(this.minHeight, primary.getIconHeight());
        Dimension size = new Dimension(this.minWidth, this.minHeight);
        super.setMinimumSize(size);
        super.setPreferredSize(size);
        return stageId;
    }

    public void turnOn() {
        if (!this.turnedOn) {
            super.setToolTipText(this.toolTipBeforeDisabled);
            this.toolTipBeforeDisabled = null;
            this.optionLabel.setIcon(this.iconBeforeDisabled);
            this.iconBeforeDisabled = null;
            this.turnedOn = true;
        }
    }

    public void turnOff(@NonNull Icon disabledIcon, String disabledToolTip) {
        if (disabledIcon == null) {
            throw new NullPointerException("disabledIcon is marked non-null but is null");
        }
        if (this.turnedOn) {
            this.toolTipBeforeDisabled = super.getToolTipText();
            this.iconBeforeDisabled = this.optionLabel.getIcon();
            this.optionLabel.setIcon(disabledIcon);
            if (Objects.nonNull(disabledToolTip)) {
                super.setToolTipText(disabledToolTip);
            }
            this.turnedOn = false;
        }
    }

    public boolean isTurnedOn() {
        return this.turnedOn;
    }

    private static final class Stage {
        private final Icon primary;
        private final Runnable onSelectPrimary;
        private final Icon secondary;
        private final Runnable onSelectSecondary;
        private final String toolTip;
        private final int id;

        public Stage(Icon primary, Runnable onSelectPrimary, Icon secondary, Runnable onSelectSecondary, String toolTip, int id) {
            this.primary = primary;
            this.onSelectPrimary = onSelectPrimary;
            this.secondary = secondary;
            this.onSelectSecondary = onSelectSecondary;
            this.toolTip = toolTip;
            this.id = id;
        }

        public Icon getPrimary() {
            return this.primary;
        }

        public Runnable getOnSelectPrimary() {
            return this.onSelectPrimary;
        }

        public Icon getSecondary() {
            return this.secondary;
        }

        public Runnable getOnSelectSecondary() {
            return this.onSelectSecondary;
        }

        public String getToolTip() {
            return this.toolTip;
        }

        public int getId() {
            return this.id;
        }
    }
}

