/*
 * Decompiled with CFR 0.152.
 */
package com.larsvansoest.runelite.clueitems.ui.clues;

import com.larsvansoest.runelite.clueitems.EmoteClueItemsImages;
import com.larsvansoest.runelite.clueitems.data.EmoteClue;
import com.larsvansoest.runelite.clueitems.data.EmoteClueDifficulty;
import com.larsvansoest.runelite.clueitems.ui.EmoteClueItemsPalette;
import com.larsvansoest.runelite.clueitems.ui.components.DescriptionPanel;
import com.larsvansoest.runelite.clueitems.ui.components.FoldablePanel;
import com.larsvansoest.runelite.clueitems.ui.components.PropertyPanel;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.runelite.client.plugins.cluescrolls.clues.Enemy;
import net.runelite.client.plugins.cluescrolls.clues.emote.Emote;

public class EmoteCluePanel
extends FoldablePanel {
    private final Emote firstEmote;
    private final Emote secondEmote;
    private final Enemy enemy;
    private final String description;
    private final EmoteClueDifficulty difficulty;

    public EmoteCluePanel(EmoteClueItemsPalette palette, EmoteClue emoteClue) {
        super(palette, emoteClue.getLocationName(), 160, 20);
        this.difficulty = emoteClue.getEmoteClueDifficulty();
        super.addLeft(new JLabel(new ImageIcon(EmoteClueItemsImages.Icons.RuneScape.EmoteClue.Scroll.get(this.difficulty))), new Insets(2, 4, 2, 0), 0, 0, FoldablePanel.DisplayMode.All);
        this.firstEmote = emoteClue.getFirstEmote();
        this.secondEmote = emoteClue.getSecondEmote();
        this.enemy = emoteClue.getEnemy();
        this.description = emoteClue.getText();
        super.addChild(new PropertyPanel(palette, "Difficulty", this.difficulty.name()), FoldablePanel.DisplayMode.All);
        super.addChild(new PropertyPanel(palette, "First emote", this.firstEmote.getName()), FoldablePanel.DisplayMode.All);
        super.addChild(new PropertyPanel(palette, "Second emote", this.secondEmote == null ? "none" : this.secondEmote.getName()), FoldablePanel.DisplayMode.All);
        super.addChild(new PropertyPanel(palette, "Enemy", this.enemy == null ? "none" : this.enemy.getText()), FoldablePanel.DisplayMode.All);
        super.addChild(new DescriptionPanel(palette, "Description", this.description), FoldablePanel.DisplayMode.All);
    }

    public Emote getFirstEmote() {
        return this.firstEmote;
    }

    public Emote getSecondEmote() {
        return this.secondEmote;
    }

    public Enemy getEnemy() {
        return this.enemy;
    }

    public String getDescription() {
        return this.description;
    }

    public EmoteClueDifficulty getDifficulty() {
        return this.difficulty;
    }
}

