/*
 * Decompiled with CFR 0.152.
 */
package com.larsvansoest.runelite.clueitems.ui.clues;

import com.larsvansoest.runelite.clueitems.EmoteClueItemsImages;
import com.larsvansoest.runelite.clueitems.data.EmoteClue;
import com.larsvansoest.runelite.clueitems.data.EmoteClueAssociations;
import com.larsvansoest.runelite.clueitems.data.EmoteClueDifficulty;
import com.larsvansoest.runelite.clueitems.data.EmoteClueItem;
import com.larsvansoest.runelite.clueitems.ui.EmoteClueItemsPalette;
import com.larsvansoest.runelite.clueitems.ui.components.FoldablePanel;
import com.larsvansoest.runelite.clueitems.ui.components.ItemCollectionPanel;
import com.larsvansoest.runelite.clueitems.ui.components.RequirementPanel;
import com.larsvansoest.runelite.clueitems.ui.stashes.StashUnitPanel;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class EmoteClueItemPanel
extends RequirementPanel {
    private final EmoteClueDifficulty[] difficulties;
    private final int quantity;
    private final ArrayList<StashUnitPanel> stashUnitPanels;
    private ItemCollectionPanel itemCollectionPanel;

    public EmoteClueItemPanel(EmoteClueItemsPalette palette, EmoteClueItem emoteClueItem) {
        super(palette, emoteClueItem.getCollectiveName(), 160, 20);
        EmoteClue[] emoteClues = EmoteClueAssociations.EmoteClueItemParentToEmoteClues.get((Object)emoteClueItem);
        this.stashUnitPanels = new ArrayList();
        this.difficulties = (EmoteClueDifficulty[])Arrays.stream(emoteClues).map(EmoteClue::getEmoteClueDifficulty).distinct().toArray(EmoteClueDifficulty[]::new);
        Insets insets = new Insets(2, 0, 2, 5);
        Arrays.stream(this.difficulties).map(EmoteClueItemsImages.Icons.RuneScape.EmoteClue.Ribbon::get).map(ImageIcon::new).map(JLabel::new).forEach(label -> super.addRight((JLabel)label, insets, 0, 0, FoldablePanel.DisplayMode.Default));
        this.quantity = emoteClues.length;
        super.addRight(new JLabel(String.valueOf(this.quantity)), insets, 0, 0, FoldablePanel.DisplayMode.Default);
    }

    public void setItemCollectionPanel(ItemCollectionPanel itemCollectionPanel, FoldablePanel.DisplayMode ... displayModes) {
        if (Objects.nonNull(this.itemCollectionPanel)) {
            super.removeChild(itemCollectionPanel, new FoldablePanel.DisplayMode[0]);
        }
        Runnable onHeaderMousePressed = itemCollectionPanel.getOnHeaderMousePressed();
        itemCollectionPanel.setOnHeaderMousePressed(() -> {
            this.stashUnitPanels.stream().map(StashUnitPanel::getItemCollectionPanel).filter(Objects::nonNull).forEach(ItemCollectionPanel::fold);
            onHeaderMousePressed.run();
        });
        this.itemCollectionPanel = itemCollectionPanel;
        super.addChild(itemCollectionPanel, displayModes);
    }

    public void addStashUnitPanel(StashUnitPanel stashUnitPanel, FoldablePanel.DisplayMode ... displayModes) {
        ItemCollectionPanel stashUnitItemCollectionPanel = stashUnitPanel.getItemCollectionPanel();
        Runnable onHeaderMousePressed = stashUnitItemCollectionPanel.getOnHeaderMousePressed();
        stashUnitItemCollectionPanel.setOnHeaderMousePressed(() -> {
            if (Objects.nonNull(this.itemCollectionPanel)) {
                this.itemCollectionPanel.fold();
            }
            onHeaderMousePressed.run();
        });
        this.stashUnitPanels.add(stashUnitPanel);
        super.addChild(stashUnitPanel, displayModes);
    }

    public EmoteClueDifficulty[] getDifficulties() {
        return this.difficulties;
    }

    public int getQuantity() {
        return this.quantity;
    }
}

