/*
 * Decompiled with CFR 0.152.
 */
package com.larsvansoest.runelite.clueitems.ui.clues;

import com.larsvansoest.runelite.clueitems.EmoteClueItemsImages;
import com.larsvansoest.runelite.clueitems.data.EmoteClueDifficulty;
import com.larsvansoest.runelite.clueitems.ui.EmoteClueItemsPalette;
import com.larsvansoest.runelite.clueitems.ui.clues.EmoteClueItemPanel;
import com.larsvansoest.runelite.clueitems.ui.components.DataGrid;
import com.larsvansoest.runelite.clueitems.ui.components.FoldablePanelGrid;
import com.larsvansoest.runelite.clueitems.ui.components.StatusPanel;
import java.awt.Component;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.ImageIcon;

public class EmoteClueItemGrid
extends FoldablePanelGrid<EmoteClueItemPanel> {
    public EmoteClueItemGrid(EmoteClueItemsPalette palette) {
        super(palette, 25);
        this.createRequirementStatusFilterButton();
        this.createDifficultyFilterButton(palette);
        this.createSortFilterButton();
    }

    private void createRequirementStatusFilterButton() {
        String filterKey = "status";
        String toolTipTextFormat = "Toggle show %s statuses.";
        super.addFilter("status", new ImageIcon(EmoteClueItemsImages.Icons.CheckSquare.UNKNOWN), DataGrid.getToolTipText("Toggle show %s statuses.", "all"), $ -> true);
        super.addFilter("status", new ImageIcon(EmoteClueItemsImages.Icons.CheckSquare.INCOMPLETE), DataGrid.getToolTipText("Toggle show %s statuses.", "incomplete"), itemPanel -> itemPanel.getStatus() == StatusPanel.Status.InComplete);
        super.addFilter("status", new ImageIcon(EmoteClueItemsImages.Icons.CheckSquare.IN_PROGRESS), DataGrid.getToolTipText("Toggle show %s statuses.", "in progress"), itemPanel -> itemPanel.getStatus() == StatusPanel.Status.InProgress);
        super.addFilter("status", new ImageIcon(EmoteClueItemsImages.Icons.CheckSquare.COMPLETE), DataGrid.getToolTipText("Toggle show %s statuses.", "complete"), itemPanel -> itemPanel.getStatus() == StatusPanel.Status.Complete);
    }

    private void createDifficultyFilterButton(EmoteClueItemsPalette palette) {
        String filterKey = "difficulty";
        String toolTipTextFormat = "Toggle show %s difficulties.";
        super.addFilter("difficulty", new ImageIcon(EmoteClueItemsImages.Icons.RuneScape.EmoteClue.Ribbon.ALL), DataGrid.getToolTipText("Toggle show %s difficulties.", "all"), $ -> true, palette.getBrandingColor());
        super.addFilter("difficulty", new ImageIcon(EmoteClueItemsImages.Icons.RuneScape.EmoteClue.Ribbon.BEGINNER), DataGrid.getToolTipText("Toggle show %s difficulties.", "beginner"), itemPanel -> Arrays.stream(itemPanel.getDifficulties()).anyMatch(difficulty -> difficulty == EmoteClueDifficulty.Beginner), EmoteClueDifficulty.Beginner.getColor());
        super.addFilter("difficulty", new ImageIcon(EmoteClueItemsImages.Icons.RuneScape.EmoteClue.Ribbon.EASY), DataGrid.getToolTipText("Toggle show %s difficulties.", "easy"), itemPanel -> Arrays.stream(itemPanel.getDifficulties()).anyMatch(difficulty -> difficulty == EmoteClueDifficulty.Easy), EmoteClueDifficulty.Easy.getColor());
        super.addFilter("difficulty", new ImageIcon(EmoteClueItemsImages.Icons.RuneScape.EmoteClue.Ribbon.MEDIUM), DataGrid.getToolTipText("Toggle show %s difficulties.", "medium"), itemPanel -> Arrays.stream(itemPanel.getDifficulties()).anyMatch(difficulty -> difficulty == EmoteClueDifficulty.Medium), EmoteClueDifficulty.Medium.getColor());
        super.addFilter("difficulty", new ImageIcon(EmoteClueItemsImages.Icons.RuneScape.EmoteClue.Ribbon.HARD), DataGrid.getToolTipText("Toggle show %s difficulties.", "hard"), itemPanel -> Arrays.stream(itemPanel.getDifficulties()).anyMatch(difficulty -> difficulty == EmoteClueDifficulty.Hard), EmoteClueDifficulty.Hard.getColor());
        super.addFilter("difficulty", new ImageIcon(EmoteClueItemsImages.Icons.RuneScape.EmoteClue.Ribbon.ELITE), DataGrid.getToolTipText("Toggle show %s difficulties.", "elite"), itemPanel -> Arrays.stream(itemPanel.getDifficulties()).anyMatch(difficulty -> difficulty == EmoteClueDifficulty.Elite), EmoteClueDifficulty.Elite.getColor());
        super.addFilter("difficulty", new ImageIcon(EmoteClueItemsImages.Icons.RuneScape.EmoteClue.Ribbon.MASTER), DataGrid.getToolTipText("Toggle show %s difficulties.", "master"), itemPanel -> Arrays.stream(itemPanel.getDifficulties()).anyMatch(difficulty -> difficulty == EmoteClueDifficulty.Master), EmoteClueDifficulty.Master.getColor());
    }

    private void createSortFilterButton() {
        super.addSort(new ImageIcon(EmoteClueItemsImages.Icons.SortType.QUANTITY_ASCENDING), DataGrid.getToolTipText("Toggle order by %s (descending).", "quantity"), Comparator.comparingInt(EmoteClueItemPanel::getQuantity));
        super.addSort(new ImageIcon(EmoteClueItemsImages.Icons.SortType.QUANTITY_DESCENDING), DataGrid.getToolTipText("Toggle order by %s (ascending).", "quantity"), Comparator.comparingInt(EmoteClueItemPanel::getQuantity).reversed());
        super.addSort(new ImageIcon(EmoteClueItemsImages.Icons.SortType.NAME_ASCENDING), DataGrid.getToolTipText("Toggle order by %s (ascending).", "name"), Comparator.comparing(Component::getName));
        super.addSort(new ImageIcon(EmoteClueItemsImages.Icons.SortType.NAME_DESCENDING), DataGrid.getToolTipText("Toggle order by %s (ascending).", "name"), Comparator.comparing(Component::getName).reversed());
    }
}

