/*
 * Decompiled with CFR 0.152.
 */
package com.larsvansoest.runelite.clueitems.ui.clues;

import com.larsvansoest.runelite.clueitems.data.EmoteClueItem;
import com.larsvansoest.runelite.clueitems.ui.EmoteClueItemsPalette;
import com.larsvansoest.runelite.clueitems.ui.components.ItemCollectionPanel;
import com.larsvansoest.runelite.clueitems.ui.components.StatusPanel;
import java.util.HashMap;
import java.util.HashSet;
import net.runelite.client.plugins.cluescrolls.clues.item.AllRequirementsCollection;
import net.runelite.client.plugins.cluescrolls.clues.item.ItemRequirement;
import net.runelite.client.plugins.cluescrolls.clues.item.SingleItemRequirement;

public class EmoteClueItemCollectionPanel
extends ItemCollectionPanel {
    private final HashSet<EmoteClueItem> parents;
    private final HashMap<EmoteClueItem, StatusPanel.Status> requirementStatuses = new HashMap();
    private final boolean strong;

    public EmoteClueItemCollectionPanel(EmoteClueItemsPalette palette, String name, int slotRowSize, boolean strong) {
        super(palette, name, slotRowSize);
        this.parents = new HashSet();
        this.strong = strong;
    }

    public void addRequirement(EmoteClueItem emoteClueItem) {
        this.parents.add(emoteClueItem);
        this.addRequirementStatus(emoteClueItem);
    }

    private void addRequirementStatus(EmoteClueItem emoteClueItem) {
        this.requirementStatuses.put(emoteClueItem, StatusPanel.Status.InComplete);
        emoteClueItem.getChildren().forEach(this::addRequirementStatus);
    }

    public void setStatus(EmoteClueItem emoteClueItem, StatusPanel.Status status) {
        if (this.requirementStatuses.containsKey((Object)emoteClueItem)) {
            this.requirementStatuses.put(emoteClueItem, status);
            boolean complete = this.strong ? this.parents.stream().allMatch(this::complete) : this.parents.stream().anyMatch(this::complete);
            super.setStatus(complete ? StatusPanel.Status.Complete : StatusPanel.Status.InComplete);
        }
    }

    private boolean complete(EmoteClueItem emoteClueItem) {
        ItemRequirement itemRequirement = emoteClueItem.getItemRequirement();
        if (itemRequirement instanceof SingleItemRequirement) {
            return this.requirementStatuses.get((Object)emoteClueItem) == StatusPanel.Status.Complete;
        }
        if (itemRequirement instanceof AllRequirementsCollection) {
            return emoteClueItem.getChildren().stream().allMatch(this::complete);
        }
        return emoteClueItem.getChildren().stream().anyMatch(this::complete);
    }
}

