/*
 * Decompiled with CFR 0.152.
 */
package com.larsvansoest.runelite.clueitems.ui;

import com.larsvansoest.runelite.clueitems.data.EmoteClue;
import com.larsvansoest.runelite.clueitems.data.EmoteClueAssociations;
import com.larsvansoest.runelite.clueitems.data.EmoteClueItem;
import com.larsvansoest.runelite.clueitems.data.StashUnit;
import com.larsvansoest.runelite.clueitems.ui.EmoteClueItemsPalette;
import com.larsvansoest.runelite.clueitems.ui.clues.EmoteClueItemCollectionPanel;
import com.larsvansoest.runelite.clueitems.ui.clues.EmoteClueItemGrid;
import com.larsvansoest.runelite.clueitems.ui.clues.EmoteClueItemPanel;
import com.larsvansoest.runelite.clueitems.ui.clues.EmoteCluePanel;
import com.larsvansoest.runelite.clueitems.ui.components.FoldablePanel;
import com.larsvansoest.runelite.clueitems.ui.components.HeaderPanel;
import com.larsvansoest.runelite.clueitems.ui.components.ItemSlotPanel;
import com.larsvansoest.runelite.clueitems.ui.components.StatusPanel;
import com.larsvansoest.runelite.clueitems.ui.components.TabMenu;
import com.larsvansoest.runelite.clueitems.ui.stashes.StashUnitGrid;
import com.larsvansoest.runelite.clueitems.ui.stashes.StashUnitPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JPanel;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.cluescrolls.clues.item.AllRequirementsCollection;
import net.runelite.client.plugins.cluescrolls.clues.item.ItemRequirement;
import net.runelite.client.ui.PluginPanel;

public class EmoteClueItemsPanel
extends PluginPanel {
    private final Map<EmoteClueItem, EmoteClueItemPanel> itemPanelMap;
    private final Map<StashUnit, StashUnitPanel> stashUnitPanelMap;
    private final Map<EmoteClue, EmoteCluePanel> emoteCluePanelMap;
    private final Map<EmoteClueItem, ArrayList<EmoteClueItemCollectionPanel>> collectionPanelsMap;
    private final Map<EmoteClueItem, ItemSlotPanel> itemSlotPanelMap;
    private final EmoteClueItemGrid clueItemsGrid;
    private final StashUnitGrid stashUnitGrid;
    private StashUnitPanel stashUnitPanelShownOnMap;

    public EmoteClueItemsPanel(EmoteClueItemsPalette palette, ItemManager itemManager, BiConsumer<StashUnit, Boolean> onStashFillStatusChanged, BiConsumer<StashUnit, Boolean> onAddStashUnitToMap, Runnable onRemoveStashUnitFromMap, String pluginName, String pluginVersion, String gitHubUrl, String payPalUrl) {
        super.setLayout((LayoutManager)new GridBagLayout());
        super.getScrollPane().setVerticalScrollBarPolicy(22);
        this.collectionPanelsMap = new HashMap<EmoteClueItem, ArrayList<EmoteClueItemCollectionPanel>>();
        this.itemPanelMap = EmoteClueAssociations.EmoteClueItemParentToEmoteClues.keySet().stream().collect(Collectors.toMap(Function.identity(), emoteClueItem -> new EmoteClueItemPanel(palette, (EmoteClueItem)((Object)emoteClueItem))));
        this.itemSlotPanelMap = EmoteClueAssociations.ItemIdToEmoteClueItem.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, entry -> new ItemSlotPanel(itemManager, (Integer)entry.getKey(), ((EmoteClueItem)((Object)((Object)entry.getValue()))).getCollectiveName())));
        this.emoteCluePanelMap = EmoteClue.CLUES.stream().collect(Collectors.toMap(Function.identity(), emoteClue -> new EmoteCluePanel(palette, (EmoteClue)emoteClue)));
        this.stashUnitPanelShownOnMap = null;
        this.stashUnitPanelMap = Arrays.stream(StashUnit.values()).collect(Collectors.toMap(Function.identity(), stash -> new StashUnitPanel(palette, (StashUnit)((Object)stash), onStashFillStatusChanged, (panel, built) -> {
            this.setStashUnitShownOnMap((StashUnitPanel)panel);
            onAddStashUnitToMap.accept((StashUnit)((Object)stash), (Boolean)built);
        }, onRemoveStashUnitFromMap)));
        this.itemPanelMap.forEach((emoteClueItem, itemPanel) -> {
            EmoteClueItemCollectionPanel collectionPanel = new EmoteClueItemCollectionPanel(palette, "Eligible Inventory Items", 6, emoteClueItem.getItemRequirement() instanceof AllRequirementsCollection);
            collectionPanel.addRequirement((EmoteClueItem)((Object)emoteClueItem));
            this.addEmoteClueItemToCollectionPanel(collectionPanel, (EmoteClueItem)((Object)emoteClueItem));
            itemPanel.setItemCollectionPanel(collectionPanel, new FoldablePanel.DisplayMode[0]);
            Arrays.stream(EmoteClueAssociations.EmoteClueItemParentToEmoteClues.get(emoteClueItem)).map(this.emoteCluePanelMap::get).forEach(x$0 -> itemPanel.addChild((FoldablePanel)x$0, new FoldablePanel.DisplayMode[0]));
        });
        this.stashUnitPanelMap.forEach((stashUnit, stashUnitPanel) -> {
            EmoteClueItemCollectionPanel collectionPanel = new EmoteClueItemCollectionPanel(palette, "Eligible Inventory Items", 6, true);
            stashUnitPanel.setItemCollectionPanel(collectionPanel, FoldablePanel.DisplayMode.All);
            collectionPanel.setStatus(StatusPanel.Status.InComplete);
            for (EmoteClue emoteClue : EmoteClueAssociations.STASHUnitToEmoteClues.get(stashUnit)) {
                for (ItemRequirement itemRequirement : emoteClue.getItemRequirements()) {
                    if (!(itemRequirement instanceof EmoteClueItem)) continue;
                    EmoteClueItem emoteClueItem = (EmoteClueItem)itemRequirement;
                    collectionPanel.addRequirement(emoteClueItem);
                    this.addEmoteClueItemToCollectionPanel(collectionPanel, emoteClueItem);
                    this.itemPanelMap.get((Object)emoteClueItem).addStashUnitPanel((StashUnitPanel)stashUnitPanel, new FoldablePanel.DisplayMode[0]);
                }
                stashUnitPanel.addChild(this.emoteCluePanelMap.get(emoteClue), new FoldablePanel.DisplayMode[0]);
            }
        });
        this.clueItemsGrid = new EmoteClueItemGrid(palette);
        this.clueItemsGrid.load(this.itemPanelMap.values());
        this.stashUnitGrid = new StashUnitGrid(palette);
        this.stashUnitGrid.load(this.stashUnitPanelMap.values());
        TabMenu tabMenu = new TabMenu(palette, (JPanel)this.clueItemsGrid, "Items", "Emote Clue Items");
        tabMenu.addTab((JPanel)this.stashUnitGrid, "Stashes", "Stash Units", false, 1);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        super.add((Component)new HeaderPanel(pluginName, pluginVersion, gitHubUrl, payPalUrl), (Object)c);
        ++c.gridy;
        super.add((Component)tabMenu, (Object)c);
        ++c.gridy;
        super.add((Component)this.clueItemsGrid, (Object)c);
        super.add((Component)this.stashUnitGrid, (Object)c);
    }

    public void reset() {
        for (EmoteClueItem emoteClueItem : EmoteClueItem.values()) {
            this.setEmoteClueItemQuantity(emoteClueItem, 0);
            this.setEmoteClueItemStatus(emoteClueItem, StatusPanel.Status.InComplete);
            this.setEmoteClueItemCollectionLogStatus(emoteClueItem, StatusPanel.Status.InComplete);
        }
        for (Enum enum_ : StashUnit.values()) {
            this.setSTASHUnitStatus((StashUnit)enum_, false, false);
        }
        this.setStashUnitShownOnMap(null);
        this.setPlayerConstructionLevel(null);
        this.clueItemsGrid.reset();
        this.stashUnitGrid.reset();
        this.disableMapLinks();
    }

    private void setStashUnitShownOnMap(StashUnitPanel stashUnitPanel) {
        if (Objects.nonNull(this.stashUnitPanelShownOnMap)) {
            this.stashUnitPanelShownOnMap.setMapLinkShowDelete(false);
        }
        this.stashUnitPanelShownOnMap = stashUnitPanel;
    }

    private void addEmoteClueItemToCollectionPanel(EmoteClueItemCollectionPanel collectionPanel, EmoteClueItem emoteClueItem) {
        ArrayList<EmoteClueItemCollectionPanel> collectionPanels = this.collectionPanelsMap.getOrDefault((Object)emoteClueItem, new ArrayList());
        collectionPanels.add(collectionPanel);
        this.collectionPanelsMap.put(emoteClueItem, collectionPanels);
        ItemSlotPanel slotPanel = this.itemSlotPanelMap.get((Object)emoteClueItem);
        if (slotPanel != null) {
            collectionPanel.addItem(slotPanel);
            return;
        }
        List<EmoteClueItem> successors = emoteClueItem.getChildren();
        if (successors != null) {
            for (EmoteClueItem successor : successors) {
                this.addEmoteClueItemToCollectionPanel(collectionPanel, successor);
            }
        }
    }

    public void setEmoteClueItemQuantity(EmoteClueItem emoteClueItem, int quantity) {
        ItemSlotPanel slotPanel = this.itemSlotPanelMap.get((Object)emoteClueItem);
        if (slotPanel != null) {
            slotPanel.setQuantity(quantity);
        }
    }

    public void setEmoteClueItemCollectionLogStatus(EmoteClueItem emoteClueItem, StatusPanel.Status status) {
        for (EmoteClueItemCollectionPanel collectionPanel : this.collectionPanelsMap.get((Object)emoteClueItem)) {
            collectionPanel.setStatus(emoteClueItem, status);
        }
    }

    public void setEmoteClueItemStatus(EmoteClueItem emoteClueItem, StatusPanel.Status status) {
        EmoteClueItemPanel itemPanel = this.itemPanelMap.get((Object)emoteClueItem);
        if (itemPanel != null) {
            itemPanel.setStatus(status);
        }
    }

    public void setSTASHUnitStatus(StashUnit stashUnit, boolean built, boolean filled) {
        StashUnitPanel stashUnitPanel = this.stashUnitPanelMap.get((Object)stashUnit);
        if (stashUnitPanel != null) {
            if (!built) {
                stashUnitPanel.setBuilt(false);
            } else {
                stashUnitPanel.setBuilt(true);
                stashUnitPanel.setFilled(filled);
            }
        }
    }

    public void setStashUnitFilledStatus(StashUnit stashUnit, boolean filled) {
        StashUnitPanel stashUnitPanel = this.stashUnitPanelMap.get((Object)stashUnit);
        if (filled != stashUnitPanel.isFilled()) {
            stashUnitPanel.setFilled(filled);
        }
    }

    public void turnOnSTASHFilledButton(StashUnit stashUnit) {
        StashUnitPanel stashUnitPanel = this.stashUnitPanelMap.get((Object)stashUnit);
        if (stashUnitPanel != null) {
            stashUnitPanel.turnOnFilledButton();
        }
    }

    public void turnOffSTASHFilledButton(StashUnit stashUnit, Icon icon, String toolTip) {
        StashUnitPanel stashUnitPanel = this.stashUnitPanelMap.get((Object)stashUnit);
        if (stashUnitPanel != null) {
            stashUnitPanel.turnOffFilledButton(icon, toolTip);
        }
    }

    public void setEmoteClueItemGridDisclaimer(String text) {
        this.clueItemsGrid.setDisclaimer(text, null);
    }

    public void setEmoteClueItemGridDisclaimer(String text, Runnable onClose) {
        this.clueItemsGrid.setDisclaimer(text, onClose);
    }

    public void setSTASHUnitGridDisclaimer(String text) {
        this.stashUnitGrid.setDisclaimer(text, null);
    }

    public void removeEmoteClueItemGridDisclaimer() {
        this.clueItemsGrid.removeDisclaimer();
    }

    public void removeSTASHUnitGridDisclaimer() {
        this.stashUnitGrid.removeDisclaimer();
    }

    public void setPlayerConstructionLevel(Integer level) {
        this.stashUnitPanelMap.values().forEach(stashUnitPanel -> stashUnitPanel.setPlayerConstructionLevel(level));
    }

    public void enableMapLinks() {
        this.stashUnitPanelMap.values().forEach(StashUnitPanel::turnOnMapLinkButton);
    }

    public void disableMapLinks() {
        this.stashUnitPanelMap.values().forEach(StashUnitPanel::turnOffMapLinkButton);
    }
}

