/*
 * Decompiled with CFR 0.152.
 */
package com.larsvansoest.runelite.clueitems.progress;

import com.larsvansoest.runelite.clueitems.data.StashUnit;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import net.runelite.client.config.ConfigManager;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

class StashMonitor {
    private static final int[] STASH_IDS_ORDERED = Arrays.stream(StashUnit.values()).mapToInt(stashUnit -> stashUnit.getStashUnit().getObjectId()).sorted().toArray();
    private static final String STASH_IDS_ORDERED_FINGERPRINT = Arrays.stream(STASH_IDS_ORDERED).mapToObj(String::valueOf).collect(Collectors.joining("-"));
    private static final String LEGACY_GROUP = "[EmoteClueItems]";
    private static final String LEGACY_FILLED_KEY = "STASHUnit fill statuses";
    private static final String LEGACY_FINGERPRINT_KEY = "_fingerprint";
    private static final String GROUP = "emote-clue-items";
    private static final String FILLED_KEY = "stashes-filled";
    private static final String FINGERPRINT_KEY = "stashes-fingerprint";
    private final ConfigManager config;

    public void setStashFilled(StashUnit stashUnit, boolean filled) {
        String stashes = this.config.getRSProfileConfiguration(GROUP, FILLED_KEY);
        if (Objects.nonNull(stashes)) {
            StringBuilder stashesBuilder = new StringBuilder(stashes);
            stashesBuilder.setCharAt(ArrayUtils.indexOf((int[])STASH_IDS_ORDERED, (int)stashUnit.getStashUnit().getObjectId()), filled ? (char)'t' : 'f');
            this.config.setRSProfileConfiguration(GROUP, FILLED_KEY, (Object)stashesBuilder.toString());
        }
    }

    public boolean getStashFilled(StashUnit stashUnit) {
        String stashes = this.config.getRSProfileConfiguration(GROUP, FILLED_KEY);
        if (Objects.isNull(stashes)) {
            return false;
        }
        char stash = stashes.charAt(ArrayUtils.indexOf((int[])STASH_IDS_ORDERED, (int)stashUnit.getStashUnit().getObjectId()));
        return stash == 't';
    }

    public void validate() {
        this.migrateConfig();
        String stashes = this.config.getRSProfileConfiguration(GROUP, FILLED_KEY);
        String fingerPrint = this.config.getRSProfileConfiguration(GROUP, FINGERPRINT_KEY);
        if (Objects.isNull(stashes) || Objects.isNull(fingerPrint) || !fingerPrint.equals(STASH_IDS_ORDERED_FINGERPRINT) || stashes.length() != STASH_IDS_ORDERED.length) {
            this.config.setRSProfileConfiguration(GROUP, FILLED_KEY, (Object)StringUtils.repeat((char)'f', (int)STASH_IDS_ORDERED.length));
            this.config.setRSProfileConfiguration(GROUP, FINGERPRINT_KEY, (Object)STASH_IDS_ORDERED_FINGERPRINT);
        }
    }

    @Deprecated
    private void migrateConfig() {
        String legacyFilledConfig = this.config.getRSProfileConfiguration(LEGACY_GROUP, LEGACY_FILLED_KEY);
        String filledConfig = this.config.getRSProfileConfiguration(GROUP, FILLED_KEY);
        if (Objects.nonNull(legacyFilledConfig) && Objects.isNull(filledConfig)) {
            this.config.setRSProfileConfiguration(GROUP, FILLED_KEY, (Object)legacyFilledConfig);
        }
        String legacyFingerprintConfig = this.config.getRSProfileConfiguration(LEGACY_GROUP, LEGACY_FINGERPRINT_KEY);
        String fingerprintConfig = this.config.getRSProfileConfiguration(GROUP, FINGERPRINT_KEY);
        if (Objects.nonNull(legacyFingerprintConfig) && Objects.isNull(fingerprintConfig)) {
            this.config.setRSProfileConfiguration(GROUP, FINGERPRINT_KEY, (Object)legacyFingerprintConfig.replace(',', '-'));
        }
    }

    public StashMonitor(ConfigManager config) {
        this.config = config;
    }
}

