/*
 * Decompiled with CFR 0.152.
 */
package com.larsvansoest.runelite.clueitems.progress;

import com.larsvansoest.runelite.clueitems.EmoteClueItemsConfig;
import com.larsvansoest.runelite.clueitems.data.EmoteClue;
import com.larsvansoest.runelite.clueitems.data.EmoteClueAssociations;
import com.larsvansoest.runelite.clueitems.data.EmoteClueItem;
import com.larsvansoest.runelite.clueitems.data.StashUnit;
import com.larsvansoest.runelite.clueitems.progress.InventoryMonitor;
import com.larsvansoest.runelite.clueitems.progress.StashMonitor;
import com.larsvansoest.runelite.clueitems.ui.components.StatusPanel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.vars.AccountType;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.cluescrolls.clues.item.AllRequirementsCollection;
import net.runelite.client.plugins.cluescrolls.clues.item.AnyRequirementCollection;
import net.runelite.client.plugins.cluescrolls.clues.item.ItemRequirement;

public class ProgressManager {
    private final Client client;
    private final ClientThread clientThread;
    private final EmoteClueItemsConfig config;
    private final InventoryMonitor inventoryMonitor;
    private final StashMonitor stashMonitor;
    private final HashMap<EmoteClueItem, StatusPanel.Status> inventoryStatusMap;
    private final Map<EmoteClueItem, Map<StashUnit, Boolean>> stashFilledStatusMap;
    private final BiConsumer<EmoteClueItem, Integer> onEmoteClueItemQuantityChanged;
    private final BiConsumer<EmoteClueItem, StatusPanel.Status> onEmoteClueItemInventoryStatusChanged;
    private final BiConsumer<EmoteClueItem, StatusPanel.Status> onEmoteClueItemStatusChanged;

    public ProgressManager(Client client, ClientThread clientThread, ConfigManager configManager, EmoteClueItemsConfig config, ItemManager itemManager, BiConsumer<EmoteClueItem, Integer> onEmoteClueItemQuantityChanged, BiConsumer<EmoteClueItem, StatusPanel.Status> onEmoteClueItemInventoryStatusChanged, BiConsumer<EmoteClueItem, StatusPanel.Status> onEmoteClueItemStatusChanged) {
        this.client = client;
        this.clientThread = clientThread;
        this.config = config;
        this.inventoryMonitor = new InventoryMonitor(config, itemManager);
        this.stashMonitor = new StashMonitor(configManager);
        this.inventoryStatusMap = new HashMap(EmoteClueItem.values().length);
        this.stashFilledStatusMap = new HashMap<EmoteClueItem, Map<StashUnit, Boolean>>(EmoteClueAssociations.EmoteClueItemToEmoteClues.keySet().size());
        this.onEmoteClueItemQuantityChanged = onEmoteClueItemQuantityChanged;
        this.onEmoteClueItemInventoryStatusChanged = onEmoteClueItemInventoryStatusChanged;
        this.onEmoteClueItemStatusChanged = onEmoteClueItemStatusChanged;
        EmoteClueAssociations.EmoteClueItemToEmoteClues.forEach((emoteClueItem, emoteClues) -> {
            HashMap<StashUnit, Boolean> emoteClueStashFillStatusMap = new HashMap<StashUnit, Boolean>(((EmoteClue[])emoteClues).length);
            for (EmoteClue emoteClue : emoteClues) {
                emoteClueStashFillStatusMap.put(emoteClue.getStashUnit(), false);
            }
            this.stashFilledStatusMap.put((EmoteClueItem)((Object)emoteClueItem), (Map<StashUnit, Boolean>)emoteClueStashFillStatusMap);
        });
        this.reset();
    }

    public void reset() {
        this.inventoryMonitor.reset();
        for (EmoteClueItem emoteClueItem : EmoteClueItem.values()) {
            this.inventoryStatusMap.put(emoteClueItem, StatusPanel.Status.InComplete);
        }
        for (EmoteClueItem emoteClueItem : EmoteClueAssociations.EmoteClueItemToEmoteClues.keySet()) {
            Map<StashUnit, Boolean> emoteClueStashFillStatusMap = this.stashFilledStatusMap.get((Object)emoteClueItem);
            emoteClueStashFillStatusMap.keySet().forEach(key -> emoteClueStashFillStatusMap.put((StashUnit)((Object)key), false));
        }
    }

    public void processInventoryChanges(int containerId, Item[] items) {
        this.clientThread.invoke(() -> this.handleItemChanges(this.inventoryMonitor.fetchEmoteClueItemChanges(containerId, items)));
    }

    public void toggleBankTracking(boolean track) {
        this.handleItemChanges(this.inventoryMonitor.toggleBankTracking(track));
        if (track) {
            this.refreshContainer(InventoryID.BANK);
        }
    }

    public void toggleInventoryTracking(boolean track) {
        this.handleItemChanges(this.inventoryMonitor.toggleInventoryTracking(track));
        if (track) {
            this.refreshContainer(InventoryID.INVENTORY);
        }
    }

    public void toggleEquipmentTracking(boolean track) {
        this.handleItemChanges(this.inventoryMonitor.toggleEquipmentTracking(track));
        if (track) {
            this.refreshContainer(InventoryID.EQUIPMENT);
        }
    }

    public void toggleGroupStorageTracking(boolean track) {
        this.handleItemChanges(this.inventoryMonitor.toggleGroupStorageTracking(track));
        if (track) {
            this.refreshContainer(InventoryID.GROUP_STORAGE);
        }
    }

    private void refreshContainer(InventoryID inventoryID) {
        ItemContainer container = this.client.getItemContainer(inventoryID);
        if (container != null) {
            this.processInventoryChanges(container.getId(), container.getItems());
        }
    }

    public List<String> getUnopenedInterfaces() {
        AccountType accountType;
        ArrayList<String> unopenedContainers = new ArrayList<String>(4);
        if (this.config.trackBank() && !this.inventoryMonitor.getHasSeenBank().booleanValue()) {
            unopenedContainers.add("bank");
        }
        if (this.config.trackInventory() && !this.inventoryMonitor.getHasSeenInventory().booleanValue()) {
            unopenedContainers.add("inventory");
        }
        if (this.config.trackEquipment() && !this.inventoryMonitor.getHasSeenEquipment().booleanValue()) {
            unopenedContainers.add("equipment");
        }
        if (((accountType = this.client.getAccountType()) == AccountType.GROUP_IRONMAN || accountType == AccountType.HARDCORE_GROUP_IRONMAN) && this.config.trackGroupStorage() && !this.inventoryMonitor.getHasSeenGroupStorage().booleanValue()) {
            unopenedContainers.add("group storage");
        }
        return unopenedContainers;
    }

    public void validateConfig() {
        this.stashMonitor.validate();
        for (StashUnit stashUnit : StashUnit.values()) {
            this.setStashUnitFilled(stashUnit, this.stashMonitor.getStashFilled(stashUnit));
        }
    }

    private void handleItemChanges(List<Item> emoteClueItemChanges) {
        if (emoteClueItemChanges != null) {
            for (Item item : emoteClueItemChanges) {
                int quantity = item.getQuantity();
                EmoteClueItem emoteClueItem = EmoteClueAssociations.ItemIdToEmoteClueItem.get(item.getId());
                this.onEmoteClueItemQuantityChanged.accept(emoteClueItem, quantity);
                StatusPanel.Status status = quantity > 0 ? StatusPanel.Status.Complete : StatusPanel.Status.InComplete;
                this.inventoryStatusMap.put(emoteClueItem, status);
                this.setEmoteClueItemStatus(emoteClueItem, this.getEmoteClueItemStatus(emoteClueItem));
            }
        }
    }

    public boolean getStashUnitFilled(StashUnit stashUnit) {
        return this.stashMonitor.getStashFilled(stashUnit);
    }

    public void setStashUnitFilled(StashUnit stashUnit, boolean filled) {
        this.stashMonitor.setStashFilled(stashUnit, filled);
        for (EmoteClue emoteClue : EmoteClueAssociations.STASHUnitToEmoteClues.get((Object)stashUnit)) {
            for (EmoteClueItem emoteClueItem : EmoteClueAssociations.EmoteClueToEmoteClueItems.get(emoteClue)) {
                this.stashFilledStatusMap.get((Object)emoteClueItem).put(stashUnit, filled);
                this.setEmoteClueItemStatus(emoteClueItem, this.getEmoteClueItemStatus(emoteClueItem));
            }
        }
    }

    private StatusPanel.Status getEmoteClueItemStatus(EmoteClueItem emoteClueItem) {
        ItemRequirement itemRequirement;
        StatusPanel.Status intermediateStatus = this.inventoryStatusMap.get((Object)emoteClueItem);
        this.onEmoteClueItemInventoryStatusChanged.accept(emoteClueItem, intermediateStatus);
        if (intermediateStatus == StatusPanel.Status.Complete) {
            return StatusPanel.Status.Complete;
        }
        Map<StashUnit, Boolean> emoteClueStashFilledMap = this.stashFilledStatusMap.get((Object)emoteClueItem);
        if (Objects.nonNull(emoteClueStashFilledMap)) {
            if (this.stashFilledStatusMap.get((Object)emoteClueItem).values().stream().allMatch(Boolean::booleanValue)) {
                return StatusPanel.Status.Complete;
            }
            if (this.stashFilledStatusMap.get((Object)emoteClueItem).values().stream().anyMatch(Boolean::booleanValue)) {
                intermediateStatus = StatusPanel.Status.InProgress;
            }
        }
        if ((itemRequirement = emoteClueItem.getItemRequirement()) instanceof AnyRequirementCollection) {
            for (EmoteClueItem child : emoteClueItem.getChildren()) {
                if (this.getEmoteClueItemStatus(child) != StatusPanel.Status.Complete) continue;
                return StatusPanel.Status.Complete;
            }
        }
        if (itemRequirement instanceof AllRequirementsCollection) {
            boolean anyMatch = false;
            boolean allMatch = true;
            for (EmoteClueItem child : emoteClueItem.getChildren()) {
                if (this.getEmoteClueItemStatus(child) == StatusPanel.Status.Complete) {
                    anyMatch = true;
                    continue;
                }
                allMatch = false;
            }
            if (allMatch) {
                return StatusPanel.Status.Complete;
            }
            if (anyMatch) {
                intermediateStatus = StatusPanel.Status.InProgress;
            }
        }
        return intermediateStatus;
    }

    private void setEmoteClueItemStatus(EmoteClueItem emoteClueItem, StatusPanel.Status status) {
        this.onEmoteClueItemStatusChanged.accept(emoteClueItem, status);
        for (EmoteClueItem parent : emoteClueItem.getParents()) {
            this.setEmoteClueItemStatus(parent, this.getEmoteClueItemStatus(parent));
        }
    }
}

