/*
 * Decompiled with CFR 0.152.
 */
package com.larsvansoest.runelite.clueitems.progress;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.client.game.ItemManager;

class ItemTracker {
    private final ItemManager itemManager;
    private final ArrayList<Item> items;

    public ItemTracker(ItemManager itemManager) {
        this.itemManager = itemManager;
        this.items = new ArrayList();
    }

    public Map<Integer, Integer> getItems() {
        return this.items.stream().filter(item -> item.getId() != -1).collect(Collectors.toMap(Item::getId, Item::getQuantity, Integer::sum));
    }

    public void reset() {
        this.items.clear();
    }

    public Map<Integer, Integer> writeDeltas(@NonNull Item[] items) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        HashMap<Integer, Integer> deltas = new HashMap<Integer, Integer>();
        for (int i = 0; i < items.length; ++i) {
            if (this.items.size() == i) {
                this.items.add(new Item(-1, 0));
            }
            Item previousItem = this.items.get(i);
            Item currentItem = this.canonicalize(items[i]);
            this.items.set(i, currentItem);
            int currentItemId = currentItem.getId();
            int currentQuantity = currentItem.getQuantity();
            int previousItemId = previousItem.getId();
            int previousQuantity = previousItem.getQuantity();
            if (previousItemId != currentItemId) {
                if (previousItemId == -1) {
                    deltas.put(currentItemId, deltas.getOrDefault(currentItemId, 0) + currentQuantity);
                    continue;
                }
                if (currentItemId == -1) {
                    deltas.put(previousItemId, deltas.getOrDefault(previousItemId, 0) - previousQuantity);
                    continue;
                }
                deltas.put(currentItemId, deltas.getOrDefault(currentItemId, 0) + currentQuantity);
                deltas.put(previousItemId, deltas.getOrDefault(previousItemId, 0) - previousQuantity);
                continue;
            }
            if (previousQuantity == currentQuantity) continue;
            deltas.put(currentItemId, deltas.getOrDefault(currentItemId, 0) + (currentQuantity - previousQuantity));
        }
        return deltas;
    }

    private Item canonicalize(Item item) {
        ItemComposition itemComposition = this.itemManager.getItemComposition(item.getId());
        int quantity = itemComposition.getPlaceholderTemplateId() == -1 ? item.getQuantity() : 0;
        return new Item(this.itemManager.canonicalize(item.getId()), quantity);
    }
}

