/*
 * Decompiled with CFR 0.152.
 */
package com.larsvansoest.runelite.clueitems.progress;

import com.larsvansoest.runelite.clueitems.EmoteClueItemsConfig;
import com.larsvansoest.runelite.clueitems.data.EmoteClueAssociations;
import com.larsvansoest.runelite.clueitems.progress.ItemTracker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.runelite.api.Item;
import net.runelite.client.game.ItemManager;

class InventoryMonitor {
    private final HashMap<Integer, Integer> collection = new HashMap(EmoteClueAssociations.ItemIdToEmoteClueItem.keySet().size());
    private final ItemTracker bankTracker;
    private final ItemTracker inventoryTracker;
    private final ItemTracker equipmentTracker;
    private final ItemTracker groupStorageTracker;
    private Boolean isTrackingBank;
    private Boolean isTrackingInventory;
    private Boolean isTrackingEquipment;
    private Boolean isTrackingGroupStorage;
    private Boolean hasSeenBank;
    private Boolean hasSeenInventory;
    private Boolean hasSeenEquipment;
    private Boolean hasSeenGroupStorage;

    public InventoryMonitor(EmoteClueItemsConfig config, ItemManager itemManager) {
        this.bankTracker = new ItemTracker(itemManager);
        this.inventoryTracker = new ItemTracker(itemManager);
        this.equipmentTracker = new ItemTracker(itemManager);
        this.groupStorageTracker = new ItemTracker(itemManager);
        this.isTrackingBank = config.trackBank();
        this.isTrackingInventory = config.trackInventory();
        this.isTrackingEquipment = config.trackEquipment();
        this.isTrackingGroupStorage = config.trackGroupStorage();
        this.reset();
    }

    public void reset() {
        for (Integer itemId : EmoteClueAssociations.ItemIdToEmoteClueItem.keySet()) {
            this.collection.put(itemId, 0);
        }
        this.bankTracker.reset();
        this.inventoryTracker.reset();
        this.equipmentTracker.reset();
        this.groupStorageTracker.reset();
        this.hasSeenBank = false;
        this.hasSeenInventory = false;
        this.hasSeenEquipment = false;
        this.hasSeenGroupStorage = false;
    }

    public List<Item> toggleBankTracking(boolean track) {
        this.isTrackingBank = track;
        this.hasSeenBank = false;
        return this.toggleItemTracker(this.bankTracker, track);
    }

    public List<Item> toggleInventoryTracking(boolean track) {
        this.isTrackingInventory = track;
        this.hasSeenInventory = false;
        return this.toggleItemTracker(this.inventoryTracker, track);
    }

    public List<Item> toggleEquipmentTracking(boolean track) {
        this.isTrackingEquipment = track;
        this.hasSeenEquipment = false;
        return this.toggleItemTracker(this.equipmentTracker, track);
    }

    public List<Item> toggleGroupStorageTracking(boolean track) {
        this.isTrackingGroupStorage = track;
        this.hasSeenGroupStorage = false;
        return this.toggleItemTracker(this.groupStorageTracker, track);
    }

    private List<Item> getEmoteClueItemDeltas(Map<Integer, Integer> deltas) {
        ArrayList<Item> emoteClueDeltas = new ArrayList<Item>();
        deltas.forEach((id, delta) -> {
            Integer logQuantity = this.collection.get(id);
            if (logQuantity != null) {
                int quantity = logQuantity + delta;
                this.collection.put((Integer)id, quantity);
                emoteClueDeltas.add(new Item(id.intValue(), quantity));
            }
        });
        return emoteClueDeltas;
    }

    private List<Item> toggleItemTracker(ItemTracker itemTracker, boolean track) {
        if (track) {
            return null;
        }
        Map<Integer, Integer> items = itemTracker.getItems();
        items.replaceAll((id, quantity) -> -quantity.intValue());
        itemTracker.reset();
        return this.getEmoteClueItemDeltas(items);
    }

    public List<Item> fetchEmoteClueItemChanges(int containerId, Item[] items) {
        switch (containerId) {
            case 95: {
                if (this.isTrackingBank.booleanValue()) {
                    this.hasSeenBank = true;
                    return this.getEmoteClueItemDeltas(this.bankTracker.writeDeltas(items));
                }
                return null;
            }
            case 93: 
            case 660: {
                if (this.isTrackingInventory.booleanValue()) {
                    this.hasSeenInventory = true;
                    return this.getEmoteClueItemDeltas(this.inventoryTracker.writeDeltas(items));
                }
                return null;
            }
            case 94: {
                if (this.isTrackingEquipment.booleanValue()) {
                    this.hasSeenEquipment = true;
                    return this.getEmoteClueItemDeltas(this.equipmentTracker.writeDeltas(items));
                }
                return null;
            }
            case 659: {
                if (this.isTrackingGroupStorage.booleanValue()) {
                    this.hasSeenGroupStorage = true;
                    return this.getEmoteClueItemDeltas(this.groupStorageTracker.writeDeltas(items));
                }
                return null;
            }
        }
        return null;
    }

    public Boolean getHasSeenBank() {
        return this.hasSeenBank;
    }

    public Boolean getHasSeenInventory() {
        return this.hasSeenInventory;
    }

    public Boolean getHasSeenEquipment() {
        return this.hasSeenEquipment;
    }

    public Boolean getHasSeenGroupStorage() {
        return this.hasSeenGroupStorage;
    }
}

