/*
 * Decompiled with CFR 0.152.
 */
package com.larsvansoest.runelite.clueitems.overlay;

import com.larsvansoest.runelite.clueitems.data.EmoteClueDifficulty;
import com.larsvansoest.runelite.clueitems.overlay.ItemContainerWidgetData;
import com.larsvansoest.runelite.clueitems.overlay.Widget;
import com.larsvansoest.runelite.clueitems.overlay.WidgetContainer;
import com.larsvansoest.runelite.clueitems.overlay.WidgetContext;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.runelite.api.Client;
import net.runelite.api.widgets.WidgetItem;

public abstract class WidgetInspector {
    public static void InspectItemContainer(WidgetItem widgetItem, ItemContainerWidgetData itemContainerWidgetDataRef, int maxDepth) {
        net.runelite.api.widgets.Widget widget = widgetItem.getWidget();
        itemContainerWidgetDataRef.setWidgetContainer(null);
        itemContainerWidgetDataRef.setWidgetContext(null);
        for (int i = 0; i < maxDepth && widget != null; widget = widget.getParent(), ++i) {
            int id = widget.getId();
            if (id == Widget.BANK.id) {
                itemContainerWidgetDataRef.setWidgetContext(WidgetContext.InBank);
                itemContainerWidgetDataRef.setWidgetContainer(WidgetContainer.Bank);
                return;
            }
            if (id == Widget.BANK_EQUIPMENT.id) {
                itemContainerWidgetDataRef.setWidgetContext(WidgetContext.InBank);
                itemContainerWidgetDataRef.setWidgetContainer(WidgetContainer.Equipment);
                return;
            }
            if (id == Widget.BANK_EQUIPMENT_INVENTORY.id) {
                itemContainerWidgetDataRef.setWidgetContext(WidgetContext.InBank);
                itemContainerWidgetDataRef.setWidgetContainer(WidgetContainer.Inventory);
                return;
            }
            if (id == Widget.BANK_INVENTORY.id) {
                itemContainerWidgetDataRef.setWidgetContext(WidgetContext.InBank);
                itemContainerWidgetDataRef.setWidgetContainer(WidgetContainer.Inventory);
                return;
            }
            if (id == Widget.EQUIPMENT.id) {
                itemContainerWidgetDataRef.setWidgetContext(WidgetContext.Default);
                itemContainerWidgetDataRef.setWidgetContainer(WidgetContainer.Equipment);
                return;
            }
            if (id == Widget.EQUIPMENT_EQUIPMENT.id) {
                itemContainerWidgetDataRef.setWidgetContext(WidgetContext.InEquipment);
                itemContainerWidgetDataRef.setWidgetContainer(WidgetContainer.Equipment);
                return;
            }
            if (id == Widget.EQUIPMENT_INVENTORY.id) {
                itemContainerWidgetDataRef.setWidgetContext(WidgetContext.InEquipment);
                itemContainerWidgetDataRef.setWidgetContainer(WidgetContainer.Inventory);
                return;
            }
            if (id == Widget.DEPOSIT_BOX.id) {
                itemContainerWidgetDataRef.setWidgetContext(WidgetContext.InDepositBox);
                itemContainerWidgetDataRef.setWidgetContainer(WidgetContainer.DepositBox);
                return;
            }
            if (id == Widget.GUIDE_PRICES.id) {
                itemContainerWidgetDataRef.setWidgetContext(WidgetContext.InGuidePrices);
                itemContainerWidgetDataRef.setWidgetContainer(WidgetContainer.GuidePrices);
                return;
            }
            if (id == Widget.GUIDE_PRICES_INVENTORY.id) {
                itemContainerWidgetDataRef.setWidgetContext(WidgetContext.InGuidePrices);
                itemContainerWidgetDataRef.setWidgetContainer(WidgetContainer.Inventory);
                return;
            }
            if (id == Widget.INVENTORY.id) {
                itemContainerWidgetDataRef.setWidgetContext(WidgetContext.Default);
                itemContainerWidgetDataRef.setWidgetContainer(WidgetContainer.Inventory);
                return;
            }
            if (id == Widget.KEPT_ON_DEATH.id) {
                itemContainerWidgetDataRef.setWidgetContext(WidgetContext.InKeptOnDeath);
                itemContainerWidgetDataRef.setWidgetContainer(WidgetContainer.KeptOnDeath);
                return;
            }
            if (id == Widget.SHOP.id) {
                itemContainerWidgetDataRef.setWidgetContext(WidgetContext.InShop);
                itemContainerWidgetDataRef.setWidgetContainer(WidgetContainer.Shop);
                return;
            }
            if (id == Widget.SHOP_INVENTORY.id) {
                itemContainerWidgetDataRef.setWidgetContext(WidgetContext.InShop);
                itemContainerWidgetDataRef.setWidgetContainer(WidgetContainer.Inventory);
                return;
            }
            if (id == Widget.GROUP_STORAGE.id) {
                itemContainerWidgetDataRef.setWidgetContext(WidgetContext.InGroupStorage);
                itemContainerWidgetDataRef.setWidgetContainer(WidgetContainer.GroupStorage);
                continue;
            }
            if (id != Widget.GROUP_STORAGE_INVENTORY.id) continue;
            itemContainerWidgetDataRef.setWidgetContext(WidgetContext.InGroupStorage);
            itemContainerWidgetDataRef.setWidgetContainer(WidgetContainer.Inventory);
        }
    }

    public static boolean TryReadWatsonBoard(Client client, Function<EmoteClueDifficulty, BiConsumer<String, Boolean>> stashUnitFillStatusCallback) {
        return WidgetInspector.TryReadWatsonBoard(Widget.WATSON_NOTICE_BOARD_BEGINNER, client, stashUnitFillStatusCallback.apply(EmoteClueDifficulty.Beginner)) | WidgetInspector.TryReadWatsonBoard(Widget.WATSON_NOTICE_BOARD_EASY, client, stashUnitFillStatusCallback.apply(EmoteClueDifficulty.Easy)) | WidgetInspector.TryReadWatsonBoard(Widget.WATSON_NOTICE_BOARD_MEDIUM, client, stashUnitFillStatusCallback.apply(EmoteClueDifficulty.Medium)) | WidgetInspector.TryReadWatsonBoard(Widget.WATSON_NOTICE_BOARD_HARD, client, stashUnitFillStatusCallback.apply(EmoteClueDifficulty.Hard)) | WidgetInspector.TryReadWatsonBoard(Widget.WATSON_NOTICE_BOARD_ELITE, client, stashUnitFillStatusCallback.apply(EmoteClueDifficulty.Elite)) | WidgetInspector.TryReadWatsonBoard(Widget.WATSON_NOTICE_BOARD_MASTER, client, stashUnitFillStatusCallback.apply(EmoteClueDifficulty.Master));
    }

    private static boolean TryReadWatsonBoard(Widget watsonNoticeBoard, Client client, BiConsumer<String, Boolean> stashUnitFillStatusCallback) {
        net.runelite.api.widgets.Widget stashListWidget = client.getWidget(watsonNoticeBoard.groupId, watsonNoticeBoard.childId);
        if (Objects.isNull(stashListWidget)) {
            return false;
        }
        net.runelite.api.widgets.Widget[] stashListWidgetChildren = stashListWidget.getChildren();
        if (Objects.isNull(stashListWidgetChildren)) {
            return false;
        }
        String location = null;
        int checkMarkCount = 0;
        for (net.runelite.api.widgets.Widget widget : stashListWidgetChildren) {
            boolean widgetContainsCheckMark;
            boolean widgetContainsLocationName;
            boolean bl = widgetContainsLocationName = widget.getType() == 4;
            if (widgetContainsLocationName) {
                if (Objects.nonNull(location)) {
                    boolean stashUnitFilled = checkMarkCount == 2;
                    stashUnitFillStatusCallback.accept(location, stashUnitFilled);
                    checkMarkCount = 0;
                }
                location = widget.getText();
            }
            boolean bl2 = widgetContainsCheckMark = Objects.nonNull(location) && widget.getType() == 5;
            if (!widgetContainsCheckMark) continue;
            ++checkMarkCount;
        }
        if (Objects.nonNull(location)) {
            boolean stashUnitFilled = checkMarkCount == 2;
            stashUnitFillStatusCallback.accept(location, stashUnitFilled);
        }
        return true;
    }
}

